/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.impl;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.emf.emfstore.internal.common.ResourceFactoryRegistry;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESFileBasedChangePackageImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.OperationProxy;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningPackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.ChangePackageContainer;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.Direction;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.FileBasedOperationIterable;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.OperationEmitter;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedChangePackageImpl
extends EObjectImpl
implements FileBasedChangePackage {
    private static final URI VIRTUAL_URI = URI.createURI((String)"virtualResource.xmi");
    private static final String EMPTY_CHANGE_PACKAGE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xmi:XMI xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\"/>\n<org.eclipse.emf.emfstore.internal.server.model.versioning:ChangePackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:org.eclipse.emf.emfstore.internal.server.model.versioning=\"http://eclipse.org/emf/emfstore/server/model/versioning\" xmlns:org.eclipse.emf.emfstore.internal.server.model.versioning.operations=\"http://eclipse.org/emf/emfstore/server/model/versioning/operations\">\n</org.eclipse.emf.emfstore.internal.server.model.versioning:ChangePackage>";
    private static final String TEMP_FILE_PREFIX = "temp-";
    private static final String TEMP_SUFFIX = ".temp";
    private static final String OPERATION_FILE_SUFFIX = ".eoc";
    public static final String FILE_OP_INDEX = ".1";
    protected LogMessage logMessage;
    private static Map<Object, Object> resourceOptions;
    private ESChangePackage apiImpl;
    protected static final String FILE_PATH_EDEFAULT;
    protected String filePath = FILE_PATH_EDEFAULT;
    protected EList<OperationProxy> operationProxies;
    private Optional<Integer> cachedSize = Optional.absent();
    private Optional<Integer> cachedLeafSize = Optional.absent();

    static {
        FILE_PATH_EDEFAULT = null;
    }

    protected FileBasedChangePackageImpl() {
    }

    protected EClass eStaticClass() {
        return VersioningPackage.Literals.FILE_BASED_CHANGE_PACKAGE;
    }

    @Override
    public LogMessage getLogMessage() {
        if (this.logMessage != null && this.logMessage.eIsProxy()) {
            InternalEObject oldLogMessage = (InternalEObject)this.logMessage;
            this.logMessage = (LogMessage)this.eResolveProxy(oldLogMessage);
            if (this.logMessage != oldLogMessage) {
                InternalEObject newLogMessage = (InternalEObject)this.logMessage;
                NotificationChain msgs = oldLogMessage.eInverseRemove((InternalEObject)this, -1, null, null);
                if (newLogMessage.eInternalContainer() == null) {
                    msgs = newLogMessage.eInverseAdd((InternalEObject)this, -1, null, msgs);
                }
                if (msgs != null) {
                    msgs.dispatch();
                }
                if (this.eNotificationRequired()) {
                    this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldLogMessage, (Object)this.logMessage));
                }
            }
        }
        return this.logMessage;
    }

    public LogMessage basicGetLogMessage() {
        return this.logMessage;
    }

    public NotificationChain basicSetLogMessage(LogMessage newLogMessage, NotificationChain msgs) {
        LogMessage oldLogMessage = this.logMessage;
        this.logMessage = newLogMessage;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldLogMessage, (Object)newLogMessage);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setLogMessage(LogMessage newLogMessage) {
        if (newLogMessage != this.logMessage) {
            NotificationChain msgs = null;
            if (this.logMessage != null) {
                msgs = ((InternalEObject)this.logMessage).eInverseRemove((InternalEObject)this, -1, null, msgs);
            }
            if (newLogMessage != null) {
                msgs = ((InternalEObject)newLogMessage).eInverseAdd((InternalEObject)this, -1, null, msgs);
            }
            if ((msgs = this.basicSetLogMessage(newLogMessage, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newLogMessage, (Object)newLogMessage));
        }
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public String getTempFilePath() {
        return this.getTempFilePath(this.filePath);
    }

    private String getTempFilePath(String filePath) {
        return String.valueOf(filePath) + TEMP_SUFFIX;
    }

    @Override
    public void setFilePath(String newFilePath) {
        String oldFilePath = this.filePath;
        this.filePath = newFilePath;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldFilePath, (Object)this.filePath));
        }
    }

    @Override
    public EList<OperationProxy> getOperationProxies() {
        if (this.operationProxies == null) {
            this.operationProxies = new EObjectContainmentEList.Resolving(OperationProxy.class, (InternalEObject)this, 2);
        }
        return this.operationProxies;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetLogMessage(null, msgs);
            }
            case 2: {
                return ((InternalEList)this.getOperationProxies()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getLogMessage();
                }
                return this.basicGetLogMessage();
            }
            case 1: {
                return this.getFilePath();
            }
            case 2: {
                return this.getOperationProxies();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setLogMessage((LogMessage)newValue);
                return;
            }
            case 1: {
                this.setFilePath((String)newValue);
                return;
            }
            case 2: {
                this.getOperationProxies().clear();
                this.getOperationProxies().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setLogMessage(null);
                return;
            }
            case 1: {
                this.setFilePath(FILE_PATH_EDEFAULT);
                return;
            }
            case 2: {
                this.getOperationProxies().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.logMessage != null;
            }
            case 1: {
                return FILE_PATH_EDEFAULT == null ? this.filePath != null : !FILE_PATH_EDEFAULT.equals(this.filePath);
            }
            case 2: {
                return this.operationProxies != null && !this.operationProxies.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (filePath: ");
        result.append(this.filePath);
        result.append(')');
        return result.toString();
    }

    @Override
    public ESChangePackage toAPI() {
        if (this.apiImpl == null) {
            this.apiImpl = this.createAPI();
        }
        return this.apiImpl;
    }

    public ESChangePackage createAPI() {
        return new ESFileBasedChangePackageImpl(this);
    }

    @Override
    public void addAll(List<AbstractOperation> ops) {
        for (AbstractOperation op : ops) {
            this.add(op);
        }
    }

    @Override
    public void add(AbstractOperation op) {
        this.updateCaches(1, op.getLeafOperations().size());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Resource resource = FileBasedChangePackageImpl.createVirtualResource();
        resource.getContents().add((Object)op);
        Optional maybeRandomAccessFile = Optional.absent();
        try {
            try {
                outputStream.write(FileBasedChangePackageImpl.asBytes("<operations>\n"));
                XMLHelperImpl helper = new XMLHelperImpl((XMLResource)resource);
                XMLSaveImpl save = new XMLSaveImpl((XMLHelper)helper);
                save.save((XMLResource)resource, (OutputStream)outputStream, FileBasedChangePackageImpl.resourceOptions());
                outputStream.write(FileBasedChangePackageImpl.asBytes("</operations>\n"));
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.getTempFilePath(), "rw");
                maybeRandomAccessFile = Optional.of((Object)randomAccessFile);
                randomAccessFile.skipBytes((int)(randomAccessFile.length() - (long)FileBasedChangePackageImpl.asBytes("</org.eclipse.emf.emfstore.internal.server.model.versioning:ChangePackage>").length));
                randomAccessFile.write(outputStream.toByteArray());
                randomAccessFile.write(FileBasedChangePackageImpl.asBytes("</org.eclipse.emf.emfstore.internal.server.model.versioning:ChangePackage>"));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            try {
                outputStream.close();
                if (maybeRandomAccessFile.isPresent()) {
                    ((RandomAccessFile)maybeRandomAccessFile.get()).close();
                }
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
            }
        }
    }

    @Override
    public FileBasedChangePackage reverse() {
        FileBasedChangePackage reversedChangePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        try {
            File tempFile = File.createTempFile(TEMP_FILE_PREFIX, OPERATION_FILE_SUFFIX);
            tempFile.deleteOnExit();
            reversedChangePackage.initialize(tempFile.getAbsolutePath());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        ESCloseableIterable<AbstractOperation> operationsHandle = this.reversedOperations();
        try {
            Iterable<AbstractOperation> operations = operationsHandle.iterable();
            for (AbstractOperation operation : operations) {
                AbstractOperation reversedOperation = operation.reverse();
                reversedChangePackage.add(reversedOperation);
            }
        }
        finally {
            operationsHandle.close();
        }
        return reversedChangePackage;
    }

    public FileBasedChangePackage copy() {
        FileBasedChangePackage changePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        try {
            File tempFile = File.createTempFile(TEMP_FILE_PREFIX, OPERATION_FILE_SUFFIX);
            tempFile.deleteOnExit();
            changePackage.initialize(tempFile.getAbsolutePath());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        ESCloseableIterable<AbstractOperation> operationsHandle = this.operations();
        try {
            Iterable<AbstractOperation> operations = operationsHandle.iterable();
            for (AbstractOperation operation : operations) {
                changePackage.add(operation);
            }
        }
        finally {
            operationsHandle.close();
        }
        return changePackage;
    }

    @Override
    public ESCloseableIterable<AbstractOperation> reversedOperations() {
        return new FileBasedOperationIterable(this.getTempFilePath(), Direction.Backward);
    }

    private static Map<Object, Object> resourceOptions() {
        if (resourceOptions == null) {
            resourceOptions = new LinkedHashMap<Object, Object>();
            resourceOptions.put("DECLARE_XML", Boolean.FALSE);
            resourceOptions.put("RECORD_ANY_TYPE_NAMESPACE_DECLARATIONS", Boolean.TRUE);
        }
        return resourceOptions;
    }

    private static byte[] asBytes(String s) {
        return s.getBytes();
    }

    private static Resource createVirtualResource() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryRegistry());
        return resourceSet.createResource(VIRTUAL_URI);
    }

    @Override
    public int size() {
        if (!this.cachedSize.isPresent()) {
            this.computeSize();
        }
        return (Integer)this.cachedSize.get();
    }

    @Override
    public ESCloseableIterable<AbstractOperation> operations() {
        return new FileBasedOperationIterable(this.getTempFilePath(), Direction.Forward);
    }

    @Override
    public boolean isEmpty() {
        if (!this.cachedSize.isPresent()) {
            this.computeSize();
        }
        return (Integer)this.cachedSize.get() == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<AbstractOperation> removeAtEnd(int n) {
        ArrayList<AbstractOperation> arrayList;
        ArrayList<AbstractOperation> ops = new ArrayList<AbstractOperation>();
        Optional maybeReversedReader = Optional.absent();
        RandomAccessFile raf = null;
        OperationEmitter operationEmitter = null;
        try {
            operationEmitter = new OperationEmitter(Direction.Backward, new File(this.getTempFilePath()));
            int counter = n;
            Optional<AbstractOperation> maybeOperation = operationEmitter.tryEmit();
            int removedOps = 0;
            int removedLeafOps = 0;
            while (true) {
                if (counter <= 0 || !maybeOperation.isPresent()) {
                    this.updateCaches(-removedOps, -removedLeafOps);
                    raf = new RandomAccessFile(this.getTempFilePath(), "rw");
                    long skip = operationEmitter.getOffset();
                    raf.seek(skip);
                    byte[] bytes = FileBasedChangePackageImpl.asBytes("\n</org.eclipse.emf.emfstore.internal.server.model.versioning:ChangePackage>");
                    raf.write(bytes);
                    raf.setLength(skip + (long)bytes.length);
                    arrayList = ops;
                    break;
                }
                AbstractOperation operation = (AbstractOperation)maybeOperation.get();
                ops.add(operation);
                ++removedOps;
                removedLeafOps += operation.getLeafOperations().size();
                --counter;
            }
        }
        catch (IOException ex) {
            try {
                throw new IllegalStateException(ex);
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(raf, (boolean)true);
                    Closeables.close(operationEmitter, (boolean)true);
                    if (!maybeReversedReader.isPresent()) throw throwable;
                    Closeables.close((Closeable)((Closeable)maybeReversedReader.get()), (boolean)true);
                    throw throwable;
                }
                catch (IOException ex2) {
                    ModelUtil.logException((Throwable)ex2);
                }
                throw throwable;
            }
        }
        try {
            Closeables.close((Closeable)raf, (boolean)true);
            Closeables.close((Closeable)operationEmitter, (boolean)true);
            if (!maybeReversedReader.isPresent()) return arrayList;
            Closeables.close((Closeable)((Closeable)maybeReversedReader.get()), (boolean)true);
            return arrayList;
        }
        catch (IOException ex) {
            ModelUtil.logException((Throwable)ex);
        }
        return arrayList;
    }

    private void invalidateCaches() {
        this.cachedSize = Optional.absent();
        this.cachedLeafSize = Optional.absent();
    }

    private void updateCaches(int size, int leafSize) {
        int lSize = this.cachedSize.isPresent() ? (Integer)this.cachedSize.get() : 0;
        int lLeafSize = this.cachedLeafSize.isPresent() ? (Integer)this.cachedLeafSize.get() : 0;
        int newSize = lSize + size;
        int newLeafSize = lLeafSize + leafSize;
        this.cachedSize = Optional.of((Object)(newSize >= 0 ? newSize : 0));
        this.cachedLeafSize = Optional.of((Object)(newLeafSize >= 0 ? newLeafSize : 0));
    }

    @Override
    public void clear() {
        this.invalidateCaches();
        Optional maybeRandomAccessFile = Optional.absent();
        try {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.getTempFilePath(), "rw");
                maybeRandomAccessFile = Optional.of((Object)randomAccessFile);
                randomAccessFile.seek(0L);
                randomAccessFile.write(FileBasedChangePackageImpl.asBytes(EMPTY_CHANGE_PACKAGE));
                randomAccessFile.setLength(EMPTY_CHANGE_PACKAGE.length());
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (maybeRandomAccessFile.isPresent()) {
                try {
                    ((RandomAccessFile)maybeRandomAccessFile.get()).close();
                }
                catch (IOException ex) {
                    ModelUtil.logException((Throwable)ex);
                }
            }
        }
    }

    @Override
    public void attachToProjectSpace(ChangePackageContainer changePackageContainer) {
        URI changePackageUri = changePackageContainer.getChangePackageUri();
        String operationFileString = changePackageUri.toFileString();
        File tempOperationFile = new File(String.valueOf(operationFileString) + FILE_OP_INDEX + TEMP_SUFFIX);
        File thisFile = new File(this.getTempFilePath());
        try {
            FileUtil.copyFile((File)thisFile, (File)tempOperationFile);
            thisFile.delete();
            this.setFilePath(String.valueOf(operationFileString) + FILE_OP_INDEX);
            changePackageContainer.setChangePackage(this);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void delete() {
        File opFile = new File(this.getFilePath());
        File tempOpFile = new File(this.getTempFilePath());
        opFile.delete();
        tempOpFile.delete();
    }

    @Override
    public int leafSize() {
        if (!this.cachedLeafSize.isPresent()) {
            this.computeSize();
        }
        return (Integer)this.cachedLeafSize.get();
    }

    private void computeSize() {
        Optional maybeReversedReader = Optional.absent();
        int size = 0;
        int leafSize = 0;
        try {
            try {
                String line;
                ReversedLinesFileReader reversedReader = new ReversedLinesFileReader(new File(this.getTempFilePath()));
                maybeReversedReader = Optional.of((Object)reversedReader);
                while ((line = reversedReader.readLine()) != null) {
                    if (line.contains("</operations>")) {
                        ++size;
                        continue;
                    }
                    if (!line.contains("</subOperations>")) continue;
                    ++leafSize;
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        finally {
            if (maybeReversedReader.isPresent()) {
                try {
                    ((ReversedLinesFileReader)maybeReversedReader.get()).close();
                }
                catch (IOException ex) {
                    ModelUtil.logException((Throwable)ex);
                }
            }
        }
        this.updateCaches(size, leafSize);
    }

    @Override
    public void initialize(String filePath) {
        this.setFilePath(filePath);
        this.initializeEmptyChangePackage();
    }

    private void initializeEmptyChangePackage() {
        Optional maybeWriter = Optional.absent();
        Optional maybeTempWriter = Optional.absent();
        try {
            try {
                FileWriter fileWriter = new FileWriter(this.getFilePath());
                FileWriter tempFileWriter = new FileWriter(this.getTempFilePath());
                maybeWriter = Optional.of((Object)fileWriter);
                maybeTempWriter = Optional.of((Object)tempFileWriter);
                fileWriter.write(EMPTY_CHANGE_PACKAGE);
                tempFileWriter.write(EMPTY_CHANGE_PACKAGE);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        finally {
            if (maybeWriter.isPresent()) {
                try {
                    ((FileWriter)maybeWriter.get()).close();
                }
                catch (IOException ex) {
                    ModelUtil.logException((Throwable)ex);
                }
            }
            if (maybeTempWriter.isPresent()) {
                try {
                    ((FileWriter)maybeTempWriter.get()).close();
                }
                catch (IOException ex) {
                    ModelUtil.logException((Throwable)ex);
                }
            }
        }
    }

    @Override
    public void apply(Project project) {
        this.apply(project, false);
    }

    @Override
    public void apply(Project project, boolean forceApplication) {
        ESCloseableIterable<AbstractOperation> operations = this.operations();
        try {
            Iterable<AbstractOperation> operationsIterable = operations.iterable();
            for (AbstractOperation operation : operationsIterable) {
                try {
                    operation.apply((IdEObjectCollection)project);
                }
                catch (IllegalStateException e) {
                    if (forceApplication) continue;
                    throw e;
                }
            }
        }
        finally {
            operations.close();
        }
    }

    @Override
    public AbstractOperation get(int index) {
        ESCloseableIterable<AbstractOperation> operations = this.operations();
        try {
            Iterable<AbstractOperation> iterable = operations.iterable();
            AbstractOperation abstractOperation = (AbstractOperation)Iterables.get(iterable, (int)index);
            return abstractOperation;
        }
        finally {
            operations.close();
        }
    }

    @Override
    public ChangePackage toInMemoryChangePackage() {
        ChangePackage changePackage = VersioningFactory.eINSTANCE.createChangePackage();
        ESCloseableIterable<AbstractOperation> operationsHandle = this.operations();
        try {
            for (AbstractOperation operation : operationsHandle.iterable()) {
                changePackage.add(operation);
            }
        }
        finally {
            operationsHandle.close();
        }
        changePackage.setLogMessage((LogMessage)ModelUtil.clone((EObject)this.getLogMessage()));
        return changePackage;
    }

    @Override
    public void save() throws IOException {
        File tempFile = new File(this.getTempFilePath());
        File filePath = new File(this.getFilePath());
        FileUtil.copyFile((File)tempFile, (File)filePath);
    }

    @Override
    public void move(String newFilePath) throws IOException {
        if (newFilePath == null) {
            throw new IOException();
        }
        if (newFilePath.equals(this.getFilePath())) {
            return;
        }
        File currentTempFile = new File(this.getTempFilePath());
        File currentFilePath = new File(this.getFilePath());
        File targetTempFile = new File(this.getTempFilePath(newFilePath));
        File targetFilePath = new File(newFilePath);
        FileUtil.moveAndOverwrite((File)currentTempFile, (File)targetTempFile);
        try {
            FileUtil.moveAndOverwrite((File)currentFilePath, (File)targetFilePath);
        }
        catch (IOException ex) {
            FileUtil.moveAndOverwrite((File)targetTempFile, (File)currentTempFile);
            throw ex;
        }
        this.setFilePath(newFilePath);
    }
}

