/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictDescription {
    private final Map<String, Object> values;
    private String description;
    private String imageName;
    private DecisionManager decisionManager;

    public ConflictDescription(String description) {
        this.description = description;
        this.values = new LinkedHashMap<String, Object>();
    }

    public void add(String key, Object value) {
        if (value instanceof ModelElementId) {
            value = this.decisionManager.getModelElement((ModelElementId)value);
        }
        this.values.put(key, value);
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public String getImage() {
        return this.imageName;
    }

    public void setImage(String name) {
        this.imageName = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getResolvedDescription() {
        String result = this.description;
        for (String token : this.values.keySet()) {
            String tmp = "[" + token + "]";
            Object value = this.values.get(token);
            if (value instanceof EObject) {
                value = DecisionUtil.getClassAndName((EObject)value);
            }
            result = result.replace(tmp, value != null ? value.toString() : "");
        }
        return result;
    }

    public void setDecisionManager(DecisionManager decisionManager) {
        this.decisionManager = decisionManager;
    }
}

