/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.emfstore.internal.common.api.APIDelegate;
import org.eclipse.emf.emfstore.internal.common.api.InternalAPIDelegator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APIUtil {
    private APIUtil() {
    }

    public static <T> List<T> copy(List<T> toCopy) {
        if (toCopy == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(toCopy.size());
        for (T element : toCopy) {
            result.add(element);
        }
        return result;
    }

    public static <IMPL extends InternalAPIDelegator<API, INT>, INT extends APIDelegate<API>, API> List<INT> toInternal(List<API> toCopy) {
        if (toCopy == null) {
            return null;
        }
        ArrayList result = new ArrayList(toCopy.size());
        for (API element : toCopy) {
            InternalAPIDelegator i = (InternalAPIDelegator)element;
            result.add(i.toInternalAPI());
        }
        return result;
    }

    public static <IMPL extends InternalAPIDelegator<API, INT>, INT extends APIDelegate<API>, API, DESIRED> List<INT> toInternal(Class<DESIRED> cls, List<API> toCopy) {
        if (toCopy == null) {
            return null;
        }
        ArrayList result = new ArrayList(toCopy.size());
        for (API element : toCopy) {
            InternalAPIDelegator i = (InternalAPIDelegator)element;
            result.add(i.toInternalAPI());
        }
        return result;
    }

    public static <IMPL extends InternalAPIDelegator<API, INT>, INT extends APIDelegate<API>, API> List<API> toExternal(List<INT> toCopy) {
        if (toCopy == null) {
            return null;
        }
        ArrayList result = new ArrayList(toCopy.size());
        for (APIDelegate element : toCopy) {
            result.add(element.toAPI());
        }
        return result;
    }

    public static <IMPL extends InternalAPIDelegator<API, INT>, INT extends APIDelegate<API>, API> Set<API> toExternal(Set<INT> toCopy) {
        if (toCopy == null) {
            return null;
        }
        LinkedHashSet result = new LinkedHashSet(toCopy.size());
        for (APIDelegate element : toCopy) {
            result.add(element.toAPI());
        }
        return result;
    }

    public static <T extends APIDelegate<U>, V, U extends V> List<V> mapToAPI(Class<V> apiClass, List<T> toCopy) {
        if (toCopy == null) {
            return null;
        }
        ArrayList result = new ArrayList(toCopy.size());
        for (APIDelegate element : toCopy) {
            result.add(element.toAPI());
        }
        return result;
    }

    public static <V, U extends InternalAPIDelegator<U, T>, T extends APIDelegate<U>> List<T> mapToInternalAPI(Class<T> apiClass, List<V> toCopy) {
        if (toCopy == null) {
            return null;
        }
        ArrayList result = new ArrayList(toCopy.size());
        for (V element : toCopy) {
            result.add(((InternalAPIDelegator)element).toInternalAPI());
        }
        return result;
    }

    public static <IMPL extends InternalAPIDelegator<API, INT>, INT extends APIDelegate<API>, API> Set<INT> toInternal(Set<API> toCopy) {
        if (toCopy == null) {
            return null;
        }
        LinkedHashSet result = new LinkedHashSet(toCopy.size());
        for (API element : toCopy) {
            InternalAPIDelegator i = (InternalAPIDelegator)element;
            result.add(i.toInternalAPI());
        }
        return result;
    }

    public static <V, U extends InternalAPIDelegator<U, T>, T extends APIDelegate<U>> T toInternal(Class<T> apiClass, V element) {
        if (element == null) {
            return null;
        }
        return (T)((InternalAPIDelegator)element).toInternalAPI();
    }
}

