/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common.model.util;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.emfstore.internal.common.model.util.Messages;
import org.eclipse.emf.emfstore.internal.common.model.util.NotificationInfo;

final class NotificationValidator {
    public static NotificationValidator getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private NotificationValidator() {
    }

    protected void validate(NotificationInfo n) {
        if (n == null) {
            throw new IllegalArgumentException(Messages.NotificationValidator_NotificationInfoMustNotBeNull);
        }
        n.setValid(true);
        n.setValidationMessage("OK");
        if (n.isTouch() || n.isTransient()) {
            return;
        }
        switch (n.getEventType()) {
            case 1: {
                this.handleSetNotification(n);
                break;
            }
            case 3: {
                this.handleAddNotification(n);
                break;
            }
            case 4: {
                this.handleRemoveNotification(n);
                break;
            }
            case 5: {
                this.handleAddManyNotification(n);
                break;
            }
            case 6: {
                this.handleRemoveManyNotification(n);
                break;
            }
            case 2: {
                this.handleUnsetNotification(n);
                break;
            }
            case 7: {
                this.handleMoveNotification(n);
                break;
            }
            default: {
                this.handleUnknownNotification(n);
            }
        }
    }

    private void handleUnknownNotification(NotificationInfo n) {
        n.setValid(false);
        n.setValidationMessage(String.valueOf(Messages.NotificationValidator_UnknownNotificationType) + n.toString());
    }

    private void handleMoveNotification(NotificationInfo n) {
        if (n.isReferenceNotification()) {
            if (n.getNewValue() == null || n.getOldValue() == null) {
                n.setValid(false);
                n.setValidationMessage(MessageFormat.format(Messages.NotificationValidator_NullDetected, n.getNotifier().getClass().getCanonicalName(), n.getReference().getName()));
                return;
            }
            if (!(n.getNewValue() instanceof EObject)) {
                n.setValid(false);
                n.setValidationMessage(MessageFormat.format(Messages.NotificationValidator_NonTransientFeatureDetected, n.getNotifier().getClass().getCanonicalName(), n.getReference().getName()));
                return;
            }
            if (!(n.getOldValue() instanceof Integer)) {
                n.setValid(false);
                n.setValidationMessage(Messages.NotificationValidator_ErrorDuringMove);
                return;
            }
        }
    }

    private void handleUnsetNotification(NotificationInfo n) {
        if (!((EStructuralFeature)n.getFeature()).isUnsettable()) {
            n.setValidationMessage(Messages.NotificationValidator_FeatureCantBeUnset);
            n.setValid(false);
            return;
        }
    }

    private void handleRemoveManyNotification(NotificationInfo n) {
        if (n.isReferenceNotification()) {
            if (!(n.getOldValue() instanceof List)) {
                n.setValid(false);
                n.setValidationMessage(MessageFormat.format(Messages.NotificationValidator_NonListOldValue_REMOVE_MANY, n.getNotifier().getClass().getCanonicalName(), n.getReference().getName()));
                return;
            }
            if (!n.getReference().isMany()) {
                n.setValid(false);
                n.setValidationMessage(Messages.NotificationValidator_UnknownNotificationState_REMOVE_MANY);
                return;
            }
        }
    }

    private void handleAddManyNotification(NotificationInfo n) {
        if (n.isReferenceNotification()) {
            if (!(n.getNewValue() instanceof List)) {
                n.setValid(false);
                n.setValidationMessage(MessageFormat.format(Messages.NotificationValidator_NonListNewValue_REMOVE_MANY, n.getNotifier().getClass().getCanonicalName(), n.getReference().getName()));
                return;
            }
            if (!n.getReference().isMany()) {
                n.setValid(false);
                n.setValidationMessage(Messages.NotificationValidator_UnknownNotificationState_ADD_MANY);
                return;
            }
        }
    }

    private void handleRemoveNotification(NotificationInfo n) {
        if (n.isReferenceNotification()) {
            if (!(n.getOldValue() instanceof EObject)) {
                n.setValid(false);
                n.setValidationMessage(MessageFormat.format(Messages.NotificationValidator_NonTransientFeatureDetected, n.getNotifier().getClass().getCanonicalName(), n.getReference().getName()));
                return;
            }
            if (!n.getReference().isMany()) {
                n.setValid(false);
                n.setValidationMessage(Messages.NotificationValidator_UnknownNotificationState_REMOVE);
            }
        }
    }

    private void handleAddNotification(NotificationInfo n) {
        if (n.isReferenceNotification()) {
            if (!(n.getNewValue() instanceof EObject)) {
                n.setValid(false);
                n.setValidationMessage(MessageFormat.format(Messages.NotificationValidator_NonTransientFeatureDetected, n.getNotifier().getClass().getCanonicalName(), n.getReference().getName()));
                return;
            }
            if (!n.getReference().isMany()) {
                n.setValid(false);
                n.setValidationMessage(Messages.NotificationValidator_UnknownNotificationState_ADD);
            }
        }
    }

    private void handleSetNotification(NotificationInfo n) {
        if (n.isReferenceNotification()) {
            boolean oldValIsNoME;
            Object newValueObject = n.getNewValue();
            Object oldValueObject = n.getOldValue();
            boolean newValIsNoME = newValueObject != null && !(newValueObject instanceof EObject);
            boolean bl = oldValIsNoME = oldValueObject != null && !(oldValueObject instanceof EObject);
            if (newValIsNoME || oldValIsNoME) {
                n.setValid(false);
                n.setValidationMessage(MessageFormat.format(Messages.NotificationValidator_NonTransientFeatureDetected, n.getNotifier().getClass().getCanonicalName(), n.getReference().getName()));
                return;
            }
        }
    }

    /* synthetic */ NotificationValidator(NotificationValidator notificationValidator) {
        this();
    }

    private static class SingletonHolder {
        public static final NotificationValidator INSTANCE = new NotificationValidator(null);

        private SingletonHolder() {
        }
    }
}

