/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangePackageUtil {
    private ChangePackageUtil() {
    }

    public static AbstractChangePackage createChangePackage(boolean useInMemoryChangePackage) {
        if (useInMemoryChangePackage) {
            return VersioningFactory.eINSTANCE.createChangePackage();
        }
        FileBasedChangePackage fileBasedChangePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        fileBasedChangePackage.initialize(FileUtil.createLocationForTemporaryChangePackage());
        return fileBasedChangePackage;
    }

    public static Iterator<ChangePackageEnvelope> splitChangePackage(final FileBasedChangePackage changePackage, final int changePackageFragmentSize) {
        return new Iterator<ChangePackageEnvelope>(){
            private int fragmentIndex;
            private int count;
            private ChangePackageEnvelope envelope;
            private boolean isInitialized;

            @Override
            public boolean hasNext() {
                if (!this.isInitialized) {
                    this.init();
                }
                if (this.envelope == null) {
                    this.envelope = VersioningFactory.eINSTANCE.createChangePackageEnvelope();
                    this.envelope.setFragmentCount(this.count);
                }
                List<String> readLines = this.readLines(this.fragmentIndex * changePackageFragmentSize, changePackage, changePackageFragmentSize);
                this.envelope.getFragment().addAll(readLines);
                this.envelope.setFragmentIndex(this.fragmentIndex);
                return !this.envelope.getFragment().isEmpty() || this.fragmentIndex == 0;
            }

            private void init() {
                LineNumberReader lineNumberReader = null;
                try {
                    try {
                        lineNumberReader = new LineNumberReader(new FileReader(new File(changePackage.getTempFilePath())));
                        lineNumberReader.skip(Long.MAX_VALUE);
                        int lines = lineNumberReader.getLineNumber() + 1;
                        this.count = lines / changePackageFragmentSize;
                        if (lines % changePackageFragmentSize != 0) {
                            ++this.count;
                        }
                    }
                    catch (FileNotFoundException ex) {
                        throw new IllegalStateException(ex);
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(lineNumberReader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)lineNumberReader);
                this.isInitialized = true;
            }

            private List<String> readLines(int from, FileBasedChangePackage changePackage2, int changePackageFragmentSize2) {
                int readLines = 0;
                ArrayList<String> lines = new ArrayList<String>();
                try {
                    FileReader reader = new FileReader(new File(changePackage2.getTempFilePath()));
                    LineIterator lineIterator = new LineIterator((Reader)reader);
                    int read = 0;
                    while (read < from) {
                        if (!lineIterator.hasNext()) {
                            return lines;
                        }
                        lineIterator.next();
                        ++read;
                    }
                    while (readLines < changePackageFragmentSize2 && lineIterator.hasNext()) {
                        String nextLine = lineIterator.next();
                        ++readLines;
                        lines.add(nextLine);
                    }
                }
                catch (FileNotFoundException ex) {
                    throw new IllegalStateException(ex);
                }
                return lines;
            }

            @Override
            public ChangePackageEnvelope next() {
                boolean hasNext;
                if (this.envelope == null && !(hasNext = this.hasNext())) {
                    throw new NoSuchElementException();
                }
                ChangePackageEnvelope ret = this.envelope;
                this.envelope = null;
                ++this.fragmentIndex;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int countLeafOperations(Collection<AbstractOperation> operations) {
        int ret = 0;
        for (AbstractOperation operation : operations) {
            if (operation instanceof CompositeOperation) {
                ret += ChangePackageUtil.getSize((CompositeOperation)operation);
                continue;
            }
            ++ret;
        }
        return ret;
    }

    public static int countLeafOperations(AbstractOperation operation) {
        return ChangePackageUtil.countLeafOperations(Collections.singleton(operation));
    }

    public static int countLeafOperations(List<AbstractChangePackage> changePackages) {
        int count = 0;
        for (AbstractChangePackage changePackage : changePackages) {
            ESCloseableIterable<AbstractOperation> operations = changePackage.operations();
            try {
                for (AbstractOperation operation : operations.iterable()) {
                    count += ChangePackageUtil.countLeafOperations(operation);
                }
            }
            finally {
                operations.close();
            }
        }
        return count;
    }

    public static int countOperations(List<AbstractChangePackage> changePackages) {
        int count = 0;
        for (AbstractChangePackage changePackage : changePackages) {
            count += changePackage.size();
        }
        return count;
    }

    private static int getSize(CompositeOperation compositeOperation) {
        int ret = 0;
        EList<AbstractOperation> subOperations = compositeOperation.getSubOperations();
        for (AbstractOperation abstractOperation : subOperations) {
            if (abstractOperation instanceof CompositeOperation) {
                ret += ChangePackageUtil.getSize((CompositeOperation)abstractOperation);
                continue;
            }
            ++ret;
        }
        return ret;
    }
}

