/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies;

import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.graphdef.editor.edit.parts.AbstractFigureEditPart;
import org.eclipse.gmf.graphdef.editor.edit.policies.KeyHandlerEditPolicy;
import org.eclipse.gmf.graphdef.editor.edit.policies.assistant.AssistantFigureKeyListener;
import org.eclipse.gmf.graphdef.editor.edit.policies.assistant.BubbleFigure;
import org.eclipse.gmf.graphdef.editor.edit.policies.assistant.HeadlessDiagramGraphicalViewer;
import org.eclipse.gmf.graphdef.editor.edit.policies.assistant.PreviewFigure;
import org.eclipse.gmf.graphdef.editor.edit.policies.assistant.SelectEditPartDragTracker;
import org.eclipse.gmf.graphdef.editor.edit.policies.assistant.SelectableBubbleItemFigure;
import org.eclipse.gmf.graphdef.editor.edit.policies.keyhandler.KeyHandler;
import org.eclipse.gmf.graphdef.editor.edit.policies.keyhandler.KeyPressedRequest;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphDiagramEditorPlugin;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Display;

public class ChildFigureSelectionEditPolicy
extends DiagramAssistantEditPolicy
implements KeyHandlerEditPolicy {
    private static final String PNG_EXTENSION = ".png";
    private static final String ICONS_FOLDER = "icons/handles/";
    private static final String UNKNOWN_FIGURE_ICON = "icons/handles/Unknown.png";
    private BubbleFigure myFeedbackFigure;

    private static Figure getFigure(EditPart editPart) {
        View view = ((IGraphicalEditPart)editPart).getNotationView();
        if (view != null && view.getElement() instanceof Figure) {
            return (Figure)view.getElement();
        }
        return null;
    }

    @Override
    public void processRequest(KeyPressedRequest request) {
        if (KeyHandler.ACTIVATE_CHILD_SELECTION.equals((Object)request.getKeyStroke()) && !this.isDiagramAssistantShowing()) {
            this.showDiagramAssistant(request.getLocation());
            request.markPerformed();
        }
    }

    public void activate() {
        this.getHost().addEditPartListener((EditPartListener)new EditPartListener.Stub(){

            public void selectedStateChanged(EditPart editpart) {
                if (!editpart.hasFocus() || !ChildFigureSelectionEditPolicy.this.shouldShowDiagramAssistant()) {
                    ChildFigureSelectionEditPolicy.this.hideDiagramAssistant();
                }
            }
        });
    }

    protected void hideDiagramAssistant() {
        if (this.getHost() instanceof AbstractFigureEditPart) {
            ((AbstractFigureEditPart)this.getHost()).setDragAllowed(true);
        }
        if (this.getFeedbackFigure() == null) {
            return;
        }
        this.disposeFeedbackFigure();
    }

    protected boolean isDiagramAssistant(Object object) {
        return object instanceof BubbleFigure;
    }

    protected boolean isDiagramAssistantShowing() {
        return this.getFeedbackFigure() != null;
    }

    protected void showDiagramAssistant(Point referencePoint) {
        if (this.getFeedbackFigure() != null || this.getRealFigure() == null || this.getRealFigure().getChildren().size() == 0) {
            return;
        }
        this.initFeedbackFigure();
        this.setLocation(this.getFeedbackFigure(), referencePoint);
        if (this.getHost() instanceof AbstractFigureEditPart) {
            ((AbstractFigureEditPart)this.getHost()).setDragAllowed(false);
        }
    }

    private void setLocation(BubbleFigure feedbackFigure, Point referencePoint) {
        Point point = referencePoint.getCopy();
        this.getHostFigure().translateToAbsolute((Translatable)point);
        feedbackFigure.translateToRelative((Translatable)point);
        point.translate(0, -feedbackFigure.getSize().height);
        feedbackFigure.setLocation(point);
    }

    private void initFeedbackFigure() {
        IFigure layer = this.getLayer("Handle Layer");
        this.myFeedbackFigure = new BubbleFigure();
        HeadlessDiagramGraphicalViewer viewer = new HeadlessDiagramGraphicalViewer(this.getHost().getViewer().getEditPartFactory(), layer.getFont(), TransactionUtil.getEditingDomain((EObject)this.getRealFigure()));
        for (IGraphicalEditPart childEditPart : this.getHost().getChildren()) {
            Figure figure = ChildFigureSelectionEditPolicy.getFigure((EditPart)childEditPart);
            if (figure == null) continue;
            final SelectableBubbleItemFigure itemFigure = new SelectableBubbleItemFigure(new SelectEditPartDragTracker((EditPart)childEditPart));
            itemFigure.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseEntered(MouseEvent me) {
                    ChildFigureSelectionEditPolicy.this.myFeedbackFigure.selectChild(itemFigure);
                }
            });
            this.myFeedbackFigure.add((IFigure)itemFigure);
            PreviewFigure previewFigure = new PreviewFigure(childEditPart.getNotationView(), viewer);
            if (previewFigure.isPreviewValid()) {
                previewFigure.setPreferredSize(15, 15);
                itemFigure.setItemRepresentation(BubbleFigure.Mode.PREVIEW, (IFigure)previewFigure);
            } else {
                itemFigure.setItemRepresentation(BubbleFigure.Mode.PREVIEW, (IFigure)new ImageFigure(GMFGraphDiagramEditorPlugin.getInstance().getBundledImage(UNKNOWN_FIGURE_ICON)));
            }
            itemFigure.setItemRepresentation(BubbleFigure.Mode.ICON, this.getImageFigure(figure));
            if (this.myFeedbackFigure.getChildren().size() != 1) continue;
            this.myFeedbackFigure.selectChild(itemFigure);
        }
        this.myFeedbackFigure.setMode(BubbleFigure.Mode.PREVIEW);
        this.myFeedbackFigure.setSize(this.myFeedbackFigure.getPreferredSize());
        layer.add((IFigure)this.myFeedbackFigure);
        this.myFeedbackFigure.addKeyListener((KeyListener)new AssistantFigureKeyListener(this.myFeedbackFigure){

            @Override
            protected void hideAssistant() {
                ChildFigureSelectionEditPolicy.this.hideDiagramAssistant();
            }
        });
        this.myFeedbackFigure.addFocusListener((FocusListener)new FocusListener.Stub(){

            public void focusLost(FocusEvent fe) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ChildFigureSelectionEditPolicy.this.hideDiagramAssistant();
                    }
                });
            }
        });
        this.myFeedbackFigure.requestFocus();
    }

    private IFigure getImageFigure(Figure figure) {
        switch (figure.eClass().getClassifierID()) {
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 49: {
                return new ImageFigure(GMFGraphDiagramEditorPlugin.getInstance().getBundledImage(ICONS_FOLDER + figure.eClass().getName() + PNG_EXTENSION));
            }
        }
        return new ImageFigure(GMFGraphDiagramEditorPlugin.getInstance().getBundledImage(UNKNOWN_FIGURE_ICON));
    }

    private void disposeFeedbackFigure() {
        IFigure layer = this.getLayer("Handle Layer");
        layer.remove((IFigure)this.getFeedbackFigure());
        this.myFeedbackFigure = null;
    }

    private RealFigure getRealFigure() {
        Figure figure = ChildFigureSelectionEditPolicy.getFigure(this.getHost());
        return figure instanceof RealFigure ? (RealFigure)figure : null;
    }

    private BubbleFigure getFeedbackFigure() {
        return this.myFeedbackFigure;
    }
}

