/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Persistence {
    private static final int PERSISTENCE_VERSION = 0;
    private static final byte NULL = 0;
    private static final byte OBJECT = 1;
    private static final byte INDEX = 2;
    private static final byte LONG_STRING = 3;

    private Persistence() {
    }

    public static class Reader
    implements Closeable {
        private final Map<Integer, String> readStringCache = new HashMap<Integer, String>();
        private final DataInputStream in;

        public Reader(DataInputStream in) {
            this.in = in;
        }

        public boolean isValidPersistenceVersion() throws IOException {
            return this.in.readInt() == 0;
        }

        public void readIndexedStrings() throws IOException {
            int num = this.in.readInt();
            int i = 0;
            while (i < num) {
                this.readIndexedString();
                ++i;
            }
        }

        private String readIndexedString() throws IOException {
            String string = this.readString();
            this.readStringCache.put(this.in.readInt(), string);
            return string;
        }

        public String readString() throws IOException {
            String string;
            byte type = this.in.readByte();
            if (type == 2) {
                int index = this.in.readInt();
                return this.readStringCache.get(index);
            }
            if (type == 0) {
                return null;
            }
            if (type == 3) {
                int length = this.in.readInt();
                byte[] data = new byte[length];
                this.in.readFully(data);
                string = new String(data, StandardCharsets.UTF_8);
            } else {
                string = this.in.readUTF();
            }
            return string;
        }

        public long readLong() throws IOException {
            return this.in.readLong();
        }

        public int readInt() throws IOException {
            return this.in.readInt();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        public boolean readBoolean() throws IOException {
            return this.in.readBoolean();
        }

        public short readShort() throws IOException {
            return this.in.readShort();
        }

        public char readCharacter() throws IOException {
            return this.in.readChar();
        }

        public byte readByte() throws IOException {
            return this.in.readByte();
        }

        public double readDouble() throws IOException {
            return this.in.readDouble();
        }

        public float readFloat() throws IOException {
            return this.in.readFloat();
        }
    }

    public static class Writer
    implements Closeable {
        private final Map<String, Integer> writeStringCache = new HashMap<String, Integer>();
        private final DataOutputStream out;

        public Writer(DataOutputStream out) {
            this.out = out;
        }

        public void writePersistenceVersion() throws IOException {
            this.out.writeInt(0);
        }

        public void writeIndexedStrings(Set<String> strings) throws IOException {
            strings.remove(null);
            this.out.writeInt(strings.size());
            for (String string : strings) {
                this.writeIndexedString(string);
            }
        }

        private void writeIndexedString(String string) throws IOException {
            this.writeString(string);
            this.addToIndex(string);
        }

        public void writeString(String string) throws IOException {
            Integer index;
            Integer n = index = string != null ? this.writeStringCache.get(string) : null;
            if (index != null) {
                this.out.writeByte(2);
                this.out.writeInt(index);
                return;
            }
            if (string == null) {
                this.out.writeByte(0);
            } else {
                byte[] data = string.getBytes(StandardCharsets.UTF_8);
                if (data.length > 65535) {
                    this.out.writeByte(3);
                    this.out.writeInt(data.length);
                    this.out.write(data);
                } else {
                    this.out.writeByte(1);
                    this.out.writeUTF(string);
                }
            }
        }

        private void addToIndex(String string) throws IOException {
            if (string == null) {
                throw new NullPointerException();
            }
            Integer cur = this.writeStringCache.get(string);
            if (cur != null) {
                throw new IllegalStateException("String is already in the write table: " + string);
            }
            Integer index = this.writeStringCache.size();
            this.writeStringCache.put(string, index);
            this.out.writeInt(index);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        public void writeInt(int v) throws IOException {
            this.out.writeInt(v);
        }

        public void writeLong(long v) throws IOException {
            this.out.writeLong(v);
        }

        public void writeBoolean(boolean v) throws IOException {
            this.out.writeBoolean(v);
        }

        public void writeShort(Short v) throws IOException {
            this.out.writeShort(v.shortValue());
        }

        public void writeCharacter(Character v) throws IOException {
            this.out.writeChar(v.charValue());
        }

        public void writeByte(Byte v) throws IOException {
            this.out.writeByte(v.byteValue());
        }

        public void writeDouble(Double v) throws IOException {
            this.out.writeDouble(v);
        }

        public void writeFloat(Float v) throws IOException {
            this.out.writeFloat(v.floatValue());
        }
    }
}

