/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.classes;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.java.JavaClass;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.java.JavaMethod;
import org.eclipse.escet.chi.codegen.statements.seq.AssignmentConversions;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.CommunicationStatement;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.ReceiveStatement;
import org.eclipse.escet.chi.metamodel.chi.SendStatement;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SelectAlternativeClass {
    public static final String PROCESS_VAR = "process";

    private SelectAlternativeClass() {
    }

    public static String createSelectCaseClass(int selChoiceNumber, List<VariableDeclaration> vars, String guardKind, Expression guard, String channelKind, CommunicationStatement commStat, CodeGeneratorContext ctxt, JavaFile processClass) {
        List processVars = Lists.list();
        if (vars != null) {
            for (VariableDeclaration v : vars) {
                processVars.add(ctxt.getDefinition((PositionObject)v));
            }
        }
        String name = ctxt.makeUniqueName("SelectChoice" + String.valueOf(selChoiceNumber));
        JavaClass sac = ctxt.addJavaClass(name, false, "SelectChoice", null);
        sac.addImport("org.eclipse.escet.chi.runtime.SelectChoice", false);
        sac.addVariable("public final " + ctxt.specName + " spec;");
        String consParams = processClass.getClassName() + " process";
        sac.addVariable("private " + consParams + ";");
        String posdata = "org.eclipse.escet.chi.runtime.data.PositionData";
        sac.addImport(posdata, false);
        sac.addImport("java.util.List", false);
        posdata = posdata.substring(posdata.lastIndexOf(46) + 1);
        sac.addVariable("private " + posdata + " position;");
        sac.addVariable("private List<" + posdata + "> positionStack;");
        ctxt.openScope(CodeGeneratorContext.ActiveScope.SELECT_ALT);
        if (vars != null) {
            for (VariableDeclaration v : vars) {
                TypeID tid = TypeIDCreation.createTypeID(v.getType(), ctxt);
                String varName = ctxt.makeUniqueName(v.getName());
                String varDecl = tid.getJavaType() + " " + varName;
                consParams = consParams + ", " + (String)varDecl;
                String varLine = Strings.fmt((String)"private %s;", (Object[])new Object[]{varDecl});
                sac.addVariable(varLine);
                ctxt.addDefinition((PositionObject)v, varName);
            }
        }
        Object parms = "ChiCoordinator chiCoordinator";
        parms = (String)parms + ", Channel channel";
        parms = (String)parms + ", " + ctxt.specName + " spec";
        parms = (String)parms + ", " + consParams;
        JavaMethod cM = new JavaMethod("public", null, name, (String)parms, null);
        String superCall = Strings.fmt((String)"super(chiCoordinator, %s, %s, channel, %d);", (Object[])new Object[]{guardKind, channelKind, selChoiceNumber});
        cM.lines.add(superCall);
        cM.lines.add("this.process = process;");
        cM.lines.add("this.position = process.position;");
        cM.lines.add("this.positionStack = process.positionStack;");
        cM.lines.add("this.spec = spec;");
        sac.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        sac.addImport("org.eclipse.escet.chi.runtime.SelectChoice.ChannelKind", false);
        sac.addImport("org.eclipse.escet.chi.runtime.data.Channel", false);
        if (vars != null) {
            for (VariableDeclaration v : vars) {
                String varName = ctxt.getDefinition((PositionObject)v);
                cM.lines.add("this.%s = %s;", new Object[]{varName, varName});
            }
        }
        sac.addMethod(cM);
        cM = new JavaMethod("public", "BaseProcess", "getProcess", null, null);
        cM.lines.add("return process;");
        sac.addImport("org.eclipse.escet.chi.runtime.data.BaseProcess", false);
        sac.addMethod(cM);
        if (vars != null) {
            JavaMethod setMethod = new JavaMethod("public", "void", "setVariables", null, null);
            int i = 0;
            while (i < vars.size()) {
                VariableDeclaration v = vars.get(i);
                String processName = (String)processVars.get(i);
                String varName = ctxt.getDefinition((PositionObject)v);
                setMethod.lines.add("this.process." + processName + " = " + varName + ";");
                ++i;
            }
            sac.addMethod(setMethod);
        }
        if (guard != null) {
            Assert.check((boolean)guardKind.equals("GuardKind.FUNC"));
            JavaMethod guardMethod = new JavaMethod("public", "boolean", "getGuard", null, null);
            if (vars != null) {
                guardMethod.lines.add("setVariables();");
            }
            ExpressionBase ge = ExpressionBase.convertExpression(guard, ctxt, sac);
            guardMethod.lines.add(ge.getCode());
            guardMethod.lines.add("return " + ge.getValue() + ";");
            sac.addMethod(guardMethod);
        }
        JavaMethod sendDataMethod = new JavaMethod("public", "Object", "getSendData", null, null);
        if (commStat == null || !(commStat instanceof SendStatement)) {
            sendDataMethod.lines.add("return null;");
        } else if (commStat.getData() == null) {
            sendDataMethod.lines.add("return null;");
        } else {
            if (vars != null) {
                sendDataMethod.lines.add("setVariables();");
            }
            ExpressionBase value = ExpressionBase.convertExpression(commStat.getData(), ctxt, sac);
            value.setCurrentPositionStatement(sendDataMethod.lines);
            sendDataMethod.lines.add(value.getCode());
            sendDataMethod.lines.add("return " + value.getValue() + ";");
        }
        sac.addMethod(sendDataMethod);
        JavaMethod recvDataMethod = new JavaMethod("public", "void", "putReceiveData", "Object obj", null);
        if (commStat instanceof ReceiveStatement && commStat.getData() != null) {
            if (vars != null) {
                recvDataMethod.lines.add("setVariables();");
            }
            Expression lhs = commStat.getData();
            TypeID tid = TypeIDCreation.createTypeID(lhs.getType(), ctxt);
            String tName = tid.getJavaType();
            String tClassName = tid.getJavaClassType();
            recvDataMethod.lines.add(tName + " data = (" + tClassName + ")obj;");
            recvDataMethod.lines.add(AssignmentConversions.convertAssignment(lhs, "data", lhs.getType(), ctxt, sac));
        }
        sac.addMethod(recvDataMethod);
        ctxt.closeScope();
        return sac.getClassName();
    }
}

