/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.options;

import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.java.Strings;

public class SimulinkSampleTimeOption
extends StringOption {
    private static final String NAME = "Simulink sample time";
    private static final String OPT_DIALOG_DESCR = "Set Simulink sample time. Possible values are \"continuous\", \"inherited\", \"variable\", or a floating point sample time.";
    private static final String DEFAULT_VALUE = "continuous";
    private static final boolean EMPTY_AS_NULL = false;
    private static final String DESCRIPTION = Strings.fmt((String)"%s [DEFAULT=%s]", (Object[])new Object[]{"Set Simulink sample time. Possible values are \"continuous\", \"inherited\", \"variable\", or a floating point sample time.", "continuous"});
    private static final Character CMD_SHORT = null;
    private static final String CMD_LONG = "simulink-sample-time";
    private static final String CMD_VALUE = "STIME";
    private static final boolean SHOW_IN_DIALOG = true;
    private static final String OPT_DIALOG_TEXT = "Sample time:";

    public SimulinkSampleTimeOption() {
        super(NAME, DESCRIPTION, CMD_SHORT, CMD_LONG, CMD_VALUE, DEFAULT_VALUE, false, true, OPT_DIALOG_DESCR, OPT_DIALOG_TEXT);
    }

    public static String getSampleTime() {
        return Strings.makeUppercase((String)((String)Options.get(SimulinkSampleTimeOption.class)));
    }

    public static Double sampleGetValue() {
        try {
            Double d = Double.parseDouble(SimulinkSampleTimeOption.getSampleTime());
            return d;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static boolean offsetMayBeNonzero() {
        String value = SimulinkSampleTimeOption.getSampleTime();
        return !value.equals("CONTINUOUS") && !value.equals("INHERITED") && !value.equals("VARIABLE");
    }

    public static boolean offsetMayBeFixed() {
        String value = SimulinkSampleTimeOption.getSampleTime();
        return value.equals("CONTINUOUS") || value.equals("INHERITED");
    }

    public static boolean sampleIsValidPositiveReal() {
        Double d = SimulinkSampleTimeOption.sampleGetValue();
        if (d != null) {
            return d > 0.0;
        }
        return false;
    }

    public static String getSimulinkSampleTimeText() {
        String value = SimulinkSampleTimeOption.getSampleTime();
        if (value.equals("CONTINUOUS")) {
            return "CONTINUOUS_SAMPLE_TIME";
        }
        if (value.equals("INHERITED")) {
            return "INHERITED_SAMPLE_TIME";
        }
        if (value.equals("VARIABLE")) {
            return "VARIABLE_SAMPLE_TIME";
        }
        if (SimulinkSampleTimeOption.sampleIsValidPositiveReal()) {
            return value;
        }
        return null;
    }
}

