/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import org.eclipse.escet.common.java.Assert;

public class TextPosition
implements Comparable<TextPosition> {
    public final String location;
    public final String source;
    public final int startLine;
    public final int endLine;
    public final int startColumn;
    public final int endColumn;
    public final int startOffset;
    public final int endOffset;

    public TextPosition(String location, int startLine, int startColumn, int endLine, int endColumn, int startOffset, int endOffset) {
        this(location, null, startLine, startColumn, endLine, endColumn, startOffset, endOffset);
    }

    public TextPosition(String location, String source, int startLine, int startColumn, int endLine, int endColumn, int startOffset, int endOffset) {
        this.location = location;
        this.source = source;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        Assert.check(startLine >= 1);
        Assert.check(startColumn >= 1);
        Assert.check(startOffset >= 0);
        Assert.check(endLine >= 1 && endLine >= startLine);
        Assert.check(endColumn >= 1);
        Assert.implies(startLine == endLine, startColumn <= endColumn);
        Assert.check(endOffset >= 0 && endOffset >= startOffset);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TextPosition)) {
            return false;
        }
        return this.compareTo((TextPosition)other) == 0;
    }

    public int hashCode() {
        int hash = this.location.hashCode() + (this.source == null ? 0 : 13 * this.source.hashCode());
        return hash += 17 * this.startLine + 23 * this.startColumn + 29 * this.startOffset + 37 * this.endLine + 41 * this.endColumn + 43 * this.endOffset;
    }

    @Override
    public int compareTo(TextPosition other) {
        if (other == null) {
            throw new NullPointerException();
        }
        int result = this.location.compareTo(other.location);
        if (result != 0) {
            return result;
        }
        if (this.source == null) {
            if (other.source != null) {
                return -1;
            }
        } else {
            if (other.source == null) {
                return 1;
            }
            result = this.source.compareTo(other.source);
            if (result != 0) {
                return result;
            }
        }
        if (this.startOffset != other.startOffset) {
            return this.startOffset < other.startOffset ? -1 : 1;
        }
        if (this.endOffset != other.endOffset) {
            return this.endOffset < other.endOffset ? -1 : 1;
        }
        if (this.startLine != other.startLine) {
            return this.startLine < other.startLine ? -1 : 1;
        }
        if (this.endLine != other.endLine) {
            return this.endLine < other.endLine ? -1 : 1;
        }
        if (this.startColumn != other.startColumn) {
            return this.startColumn < other.startColumn ? -1 : 1;
        }
        if (this.endColumn != other.endColumn) {
            return this.endColumn < other.endColumn ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder txt = new StringBuilder();
        if (this.source != null) {
            txt.append(this.source);
        }
        if (this.startLine == this.endLine) {
            txt.append("line ");
            txt.append(this.startLine);
            if (this.startColumn == this.endColumn) {
                txt.append(", column ");
                txt.append(this.endColumn);
            } else {
                txt.append(", columns ");
                txt.append(this.startColumn);
                txt.append(" .. ");
                txt.append(this.endColumn);
            }
        } else {
            txt.append("line ");
            txt.append(this.startLine);
            txt.append(" column ");
            txt.append(this.startColumn);
            txt.append(" .. line ");
            txt.append(this.endLine);
            txt.append(" column ");
            txt.append(this.endColumn);
        }
        return txt.toString();
    }

    public static TextPosition createDummy(String location) {
        return TextPosition.createDummy(location, null);
    }

    public static TextPosition createDummy(String location, String source) {
        return new TextPosition(location, source, 1, 1, 1, 1, 0, 0);
    }

    public static TextPosition mergePositions(TextPosition p1, TextPosition p2) {
        int endColumn;
        int endLine;
        int endOffset;
        int startColumn;
        int startLine;
        int startOffset;
        Assert.notNull(p1);
        Assert.notNull(p2);
        Assert.areEqual(p1.location, p2.location);
        Assert.check(p1.source == null == (p2.source == null));
        if (p1.source != null && p2.source != null) {
            Assert.areEqual(p1.source, p2.source);
        }
        if (p1.startOffset < p2.startOffset) {
            startOffset = p1.startOffset;
            startLine = p1.startLine;
            startColumn = p1.startColumn;
        } else {
            startOffset = p2.startOffset;
            startLine = p2.startLine;
            startColumn = p2.startColumn;
        }
        if (p1.endOffset > p2.endOffset) {
            endOffset = p1.endOffset;
            endLine = p1.endLine;
            endColumn = p1.endColumn;
        } else {
            endOffset = p2.endOffset;
            endLine = p2.endLine;
            endColumn = p2.endColumn;
        }
        return new TextPosition(p1.location, p1.source, startLine, startColumn, endLine, endColumn, startOffset, endOffset);
    }
}

