/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators.prechecks;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class VarContOnlyTimers
extends CifCheckNoCompDefInst {
    protected void preprocessContVariable(ContVariable contVar, CifCheckViolations violations) {
        if (contVar.getValue() != null) {
            this.checkValue(contVar.getValue(), "has an initial value", (PositionObject)contVar, violations);
        }
        this.checkDerivative(contVar, violations);
    }

    protected void preprocessContVariableExpression(ContVariableExpression cvExpr, CifCheckViolations violations) {
        Assignment asgn;
        PositionObject newAncestor;
        if (cvExpr.isDerivative()) {
            return;
        }
        EObject exprParent = cvExpr.eContainer();
        if (exprParent instanceof Assignment) {
            Assignment asg = (Assignment)exprParent;
            if (cvExpr == asg.getAddressable()) {
                this.checkValue(asg.getValue(), "is assigned a value", (PositionObject)cvExpr, violations);
                return;
            }
        } else if (exprParent instanceof BinaryExpression) {
            boolean varAtLeft;
            BinaryExpression binExpr = (BinaryExpression)exprParent;
            boolean bl = varAtLeft = binExpr.getLeft() == cvExpr;
            if (varAtLeft) {
                if (binExpr.getOperator() == BinaryOperator.LESS_EQUAL) {
                    this.checkValue(binExpr.getRight(), "is compared to a value", (PositionObject)cvExpr, violations);
                    return;
                }
            } else if (binExpr.getOperator() == BinaryOperator.GREATER_EQUAL) {
                this.checkValue(binExpr.getLeft(), "is compared to a value", (PositionObject)cvExpr, violations);
                return;
            }
            if (binExpr.getOperator() == BinaryOperator.EQUAL || binExpr.getOperator() == BinaryOperator.UNEQUAL || binExpr.getOperator() == BinaryOperator.GREATER_EQUAL || binExpr.getOperator() == BinaryOperator.GREATER_THAN || binExpr.getOperator() == BinaryOperator.LESS_EQUAL || binExpr.getOperator() == BinaryOperator.LESS_THAN) {
                violations.add((PositionObject)cvExpr, "Continuous variable is compared, but not as \"variable <= ...\" or \"... >= variable\"", new Object[0]);
                return;
            }
        }
        ContVariableExpression ancestor = cvExpr;
        while ((newAncestor = (PositionObject)ancestor.eContainer()) != null && newAncestor instanceof Expression) {
            ancestor = newAncestor;
        }
        if (newAncestor instanceof Assignment && (asgn = (Assignment)newAncestor).getAddressable() == ancestor) {
            violations.add((PositionObject)cvExpr, "Continuous variable is assigned in a multi-assignment", new Object[0]);
            return;
        }
        violations.add((PositionObject)cvExpr, "Continuous variable is not assigned or compared", new Object[0]);
    }

    private void checkDerivative(ContVariable contVar, CifCheckViolations violations) {
        Double d;
        Integer i;
        Expression derivative = contVar.getDerivative();
        if (derivative == null) {
            violations.add((PositionObject)contVar, "Continuous variable has its derivative declared through one or more equations, rather than directly with its declaration", new Object[0]);
            return;
        }
        Object evalValue = this.getStaticEvaluableValue(derivative, "has a derivative", (PositionObject)contVar, violations);
        if (evalValue == null || evalValue instanceof Integer && (i = (Integer)evalValue) == -1 || evalValue instanceof Double && (d = (Double)evalValue) == -1.0) {
            return;
        }
        violations.add((PositionObject)contVar, "Continuous variable has a derivative that is not -1 or -1.0", new Object[0]);
    }

    private void checkValue(Expression value, String valueDescr, PositionObject reportObj, CifCheckViolations violations) {
        Double d;
        Integer i;
        Object evalValue = this.getStaticEvaluableValue(value, valueDescr, reportObj, violations);
        if (evalValue == null || evalValue instanceof Integer && (i = (Integer)evalValue) >= 0 || evalValue instanceof Double && (d = (Double)evalValue) >= 0.0) {
            return;
        }
        violations.add(reportObj, "Continuous variable " + valueDescr + " that is negative", new Object[0]);
    }

    private Object getStaticEvaluableValue(Expression value, String valueDescr, PositionObject reportObj, CifCheckViolations violations) {
        if (!CifValueUtils.hasSingleValue((Expression)value, (boolean)CifValueUtils.isInitialExpr((Expression)value), (boolean)true)) {
            violations.add(reportObj, "Continuous variable " + valueDescr + " that cannot be evaluated statically", new Object[0]);
            return null;
        }
        try {
            return CifEvalUtils.eval((Expression)value, (boolean)CifValueUtils.isInitialExpr((Expression)value));
        }
        catch (CifEvalException ex) {
            violations.add(reportObj, "Continuous variable " + valueDescr + " that cannot be evaluated statically, as evaluating it results in an evaluation error", new Object[0]);
            return null;
        }
    }
}

