/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.escet.common.java.Strings;

public class FileSizes {
    private static final String[] SI_NAMES = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB"};
    private static final String[] IEEE_1541_2002_NAMES = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB"};
    private static final int MAX_SCALE = SI_NAMES.length;

    private FileSizes() {
    }

    public static String formatFileSizeEx(long size) {
        return Strings.fmt("%s bytes (~%s)", new DecimalFormat("###,###,###,###,###,###,##0", new DecimalFormatSymbols(Locale.US)).format(size), FileSizes.formatFileSize(size, false));
    }

    public static String formatFileSize(long size, boolean si) {
        BigDecimal unit = si ? new BigDecimal(1000) : new BigDecimal(1024);
        BigDecimal value = new BigDecimal(size);
        int scale = 0;
        while (value.compareTo(unit) >= 0) {
            value = value.divide(unit, MAX_SCALE * 3, RoundingMode.HALF_UP);
            ++scale;
        }
        if ((value = value.divide(BigDecimal.ONE, 3, RoundingMode.HALF_UP)).compareTo(new BigDecimal(1000)) >= 0) {
            value = value.divide(unit, 3, RoundingMode.HALF_UP);
            ++scale;
        }
        StringBuilder result = new StringBuilder();
        result.append(new DecimalFormat("##0.###", new DecimalFormatSymbols(Locale.US)).format(value));
        result.append(' ');
        result.append((si ? SI_NAMES : IEEE_1541_2002_NAMES)[scale]);
        return result.toString();
    }
}

