/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.actioneditor.sourceviewer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.etrice.ui.behavior.actioneditor.sourceviewer.AbstractActionCodeEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewerExtension7;
import org.eclipse.jface.text.TabsToSpacesConverter;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class SourceViewerActionCodeEditor
extends AbstractActionCodeEditor {
    public static final String CONTENT_ASSIST_COMMAND_ID = "org.eclipse.etrice.ui.behavior.actioneditor.contentAssist";
    public static final String UNDO_COMMAND_ID = "org.eclipse.etrice.ui.behavior.actioneditor.undo";
    public static final String REDO_COMMAND_ID = "org.eclipse.etrice.ui.behavior.actioneditor.redo";
    public static final String ACTION_EDITOR_CONTEXT_ID = "org.eclipse.etrice.ui.behavior.actioneditor.context";
    private ISourceViewer fSourceViewer;
    private SourceViewerConfiguration fConfiguration;
    private IDocument fDocument;
    protected IContextActivation fActivation;
    protected Map<String, IHandlerActivation> activatedHandlers;

    public IDocument getDocument() {
        return this.fDocument;
    }

    public final SourceViewerConfiguration getSourceViewerConfiguration() {
        return this.fConfiguration;
    }

    public final ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        this.fConfiguration = configuration;
    }

    protected IDocument createDocument(String detailCode) {
        Document document = new Document(detailCode);
        return document;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return new SourceViewer(parent, ruler, styles);
    }

    public boolean isEditable() {
        return true;
    }

    @Override
    public void init(String detailCode) {
        this.doSetDetailCode(detailCode);
    }

    @Override
    public void createControl(Composite parent) {
        int styles = 68354;
        this.fSourceViewer = this.createSourceViewer(parent, null, styles);
        if (this.fConfiguration == null) {
            this.fConfiguration = new SourceViewerConfiguration();
        }
        this.fSourceViewer.configure(this.fConfiguration);
        this.installTabsToSpacesConverter();
        StyledText styledText = this.fSourceViewer.getTextWidget();
        styledText.setFont(JFaceResources.getTextFont());
        styledText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SourceViewerActionCodeEditor.this.deactivateContext();
            }

            public void focusGained(FocusEvent e) {
                SourceViewerActionCodeEditor.this.activateContext();
            }
        });
        styledText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SourceViewerActionCodeEditor.this.dispose();
            }
        });
        styledText.addListener(44, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        this.fSourceViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                SourceViewerActionCodeEditor.this.fSourceViewer.getTextWidget().notifyListeners(24, null);
            }
        });
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.initializeSourceViewer();
    }

    public void setDetailCode(String detailCode) {
        this.doSetDetailCode(detailCode);
    }

    public Control getControl() {
        return this.fSourceViewer.getTextWidget();
    }

    public void insertText(String text) {
        if (this.fSourceViewer != null && this.fSourceViewer.getTextWidget() != null) {
            int braceBegin = text.indexOf(40);
            int braceEnd = text.indexOf(41);
            int offset = this.fSourceViewer.getSelectedRange().x;
            int length = this.fSourceViewer.getSelectedRange().y;
            try {
                this.fDocument.replace(offset, length, text);
            }
            catch (BadLocationException badLocationException) {}
            if (braceBegin >= 0 && braceEnd >= 0 && braceEnd > braceBegin + 1) {
                this.fSourceViewer.setSelectedRange(offset + braceBegin + 1, braceEnd - braceBegin - 1);
            }
            this.fSourceViewer.getTextWidget().setFocus();
        }
    }

    protected void doSetDetailCode(String detailCode) {
        this.fDocument = this.createDocument(detailCode);
        if (this.fSourceViewer != null) {
            this.initializeSourceViewer();
        }
    }

    private void initializeSourceViewer() {
        if (this.fDocument != null) {
            this.fSourceViewer.setDocument(this.fDocument, null);
            this.fSourceViewer.setEditable(this.isEditable());
            this.fSourceViewer.showAnnotations(false);
        }
    }

    @Override
    public void dispose() {
        this.deactivateContext();
        this.fDocument = null;
        this.fSourceViewer = null;
        this.fConfiguration = null;
    }

    protected void activateContext() {
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        if (contextService != null) {
            this.fActivation = contextService.activateContext(ACTION_EDITOR_CONTEXT_ID);
        }
        this.activateHandler(CONTENT_ASSIST_COMMAND_ID, 13);
        this.activateHandler(UNDO_COMMAND_ID, 1);
        this.activateHandler(REDO_COMMAND_ID, 2);
    }

    protected void deactivateContext() {
        IHandlerService handlerService;
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        if (contextService != null) {
            contextService.deactivateContext(this.fActivation);
        }
        if ((handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)) != null && this.activatedHandlers != null) {
            handlerService.deactivateHandlers(this.activatedHandlers.values());
            this.activatedHandlers = null;
        }
    }

    protected void activateHandler(String commandId, int operation) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (handlerService != null) {
            IHandlerActivation contentAssistHandlerActivation = handlerService.activateHandler(commandId, (IHandler)new ActionCodeHandler(operation));
            if (this.activatedHandlers == null) {
                this.activatedHandlers = new HashMap<String, IHandlerActivation>();
            }
            this.activatedHandlers.put(commandId, contentAssistHandlerActivation);
        }
    }

    protected void deactivateHandler(String commandId) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (handlerService != null && this.activatedHandlers != null) {
            handlerService.deactivateHandler(this.activatedHandlers.get(commandId));
            this.activatedHandlers.remove(commandId);
        }
    }

    protected void installTabsToSpacesConverter() {
        SourceViewerConfiguration config = this.getSourceViewerConfiguration();
        if (config != null && this.fSourceViewer instanceof ITextViewerExtension7) {
            int tabWidth = config.getTabWidth(this.fSourceViewer);
            TabsToSpacesConverter tabToSpacesConverter = new TabsToSpacesConverter();
            tabToSpacesConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            tabToSpacesConverter.setNumberOfSpacesPerTab(tabWidth);
            ((ITextViewerExtension7)this.fSourceViewer).setTabsToSpacesConverter((IAutoEditStrategy)tabToSpacesConverter);
        }
    }

    public class ActionCodeHandler
    extends AbstractHandler {
        int fOperation;

        public ActionCodeHandler(int operation) {
            this.fOperation = operation;
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            SourceViewerActionCodeEditor.this.fSourceViewer.getTextOperationTarget().doOperation(this.fOperation);
            return null;
        }
    }
}

