/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.Wire;
import org.eclipse.etrice.core.genmodel.etricegen.WiredActorClass;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.cpp.gen.StateMachineGen;
import org.eclipse.etrice.generator.cpp.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class ActorClassGen
extends GenericActorClassGenerator {
    @Inject
    protected IGeneratorFileIO fileIO;
    @Inject
    @Extension
    protected CppExtensions _cppExtensions;
    @Inject
    @Extension
    protected RoomExtensions _roomExtensions;
    @Inject
    @Extension
    protected ProcedureHelpers _procedureHelpers;
    @Inject
    protected Initialization initHelper;
    @Inject
    @Extension
    protected StateMachineGen _stateMachineGen;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public void doGenerate(Root root) {
        HashMap ac2wired = CollectionLiterals.newHashMap();
        Consumer<WiredActorClass> consumer = it -> ac2wired.put(it.getActorClass(), it);
        Iterables.filter((Iterable)root.getWiredInstances(), WiredActorClass.class).forEach(consumer);
        Functions.Function1 function1 = it -> {
            boolean bl = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !bl;
        };
        Functions.Function1 function12 = it -> root.getExpandedActorClass(it);
        Consumer<ExpandedActorClass> consumer2 = xpac -> {
            WiredActorClass wired = (WiredActorClass)ac2wired.get(xpac.getActorClass());
            boolean manualBehavior = this._roomHelpers.isBehaviorAnnotationPresent(xpac.getActorClass(), "BehaviorManual");
            String path = this._roomExtensions.getPath((RoomClass)xpac.getActorClass());
            String string = null;
            string = manualBehavior ? "Abstract" : "";
            String file = string;
            String string2 = this._cppExtensions.getCppHeaderFileName((RoomClass)xpac.getActorClass());
            String string3 = path + file + string2;
            this.fileIO.generateFile("generating ActorClass declaration", string3, this.generateHeaderFile(root, (ExpandedActorClass)xpac, wired, manualBehavior));
            String string4 = this._cppExtensions.getCppSourceFileName((RoomClass)xpac.getActorClass());
            String string5 = path + file + string4;
            this.fileIO.generateFile("generating ActorClass implementation", string5, this.generateSourceFile(root, (ExpandedActorClass)xpac, wired, manualBehavior));
        };
        IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)root.getActorClasses(), (Functions.Function1)function1), (Functions.Function1)function12).forEach(consumer2);
    }

    protected CharSequence generateHeaderFile(Root root, ExpandedActorClass xpac, WiredActorClass wired, boolean manualBehavior) {
        CharSequence charSequence;
        CharSequence charSequence2;
        String string;
        String string2;
        String string3;
        String string4;
        Object object;
        boolean dc2;
        Object object2;
        CharSequence charSequence3;
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        Object object3 = null;
        if (manualBehavior) {
            String string5 = ac.getName();
            object3 = "Abstract" + string5;
        } else {
            object3 = ac.getName();
        }
        String clsname = object3;
        String string6 = null;
        ActorClass actorClass = ac.getActorBase();
        String string7 = null;
        if (actorClass != null) {
            string7 = actorClass.getName();
        }
        string6 = string7 != null ? string7 : "etRuntime::ActorClassBase";
        String rtBaseClassName = string6;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Header File of ActorClass ");
        stringConcatenation2.append(clsname, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence4 = this._cppExtensions.generateIncludeGuardBegin((RoomClass)ac, "");
        stringConcatenation2.append((Object)charSequence4);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/etDatatypesCpp.hpp\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/messaging/IRTObject.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/modelbase/PortBase.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/modelbase/ReplicatedActorClassBase.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/modelbase/InterfaceItemBase.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/modelbase/SubSystemClassBase.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/messaging/Address.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/messaging/IMessageReceiver.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/debugging/DebuggingService.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        Object object4 = root.getReferencedProtocolClasses((RoomClass)ac);
        for (ProtocolClass pc : object4) {
            stringConcatenation2.append("#include \"");
            charSequence3 = this._roomExtensions.getPath((RoomClass)pc);
            stringConcatenation2.append(charSequence3);
            object2 = pc.getName();
            stringConcatenation2.append((String)object2);
            stringConcatenation2.append(".h\"");
            stringConcatenation2.newLineIfNotEmpty();
        }
        object4 = root.getReferencedDataClasses((RoomClass)ac);
        for (DataClass dc2 : object4) {
            stringConcatenation2.append("#include \"");
            charSequence3 = this._roomExtensions.getPath((RoomClass)dc2);
            stringConcatenation2.append(charSequence3);
            object2 = dc2.getName();
            stringConcatenation2.append((String)object2);
            stringConcatenation2.append(".h\"");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        object4 = ac.getActorBase();
        boolean bl = dc2 = object4 == null;
        if (dc2) {
            stringConcatenation2.append("#include \"common/modelbase/ActorClassBase.h\"");
            stringConcatenation2.newLine();
        } else {
            stringConcatenation2.append("#include \"");
            object = this._roomExtensions.getPath((RoomClass)ac.getActorBase());
            stringConcatenation2.append((String)object);
            charSequence3 = ac.getActorBase().getName();
            stringConcatenation2.append(charSequence3);
            stringConcatenation2.append(".h\"");
            stringConcatenation2.newLineIfNotEmpty();
        }
        object4 = ac.getActorRefs();
        for (ActorRef ar : object4) {
            stringConcatenation2.append("#include \"");
            charSequence3 = this._cppExtensions.getActorIncludePath(ar.getType());
            stringConcatenation2.append(charSequence3);
            stringConcatenation2.append("\"");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        object4 = this._procedureHelpers.userCode(ac.getUserCode1());
        stringConcatenation2.append(object4);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("using namespace etRuntime;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        String string8 = this._cppExtensions.generateNamespaceBegin((RoomClass)ac);
        stringConcatenation2.append(string8);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("class ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append(" : public ");
        stringConcatenation2.append(rtBaseClassName);
        stringConcatenation2.append(" {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("protected:");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("//--------------------- ports");
        stringConcatenation2.newLine();
        object = this._roomHelpers.getEndPorts(ac);
        object2 = object.iterator();
        while (object2.hasNext()) {
            Port ep = (Port)object2.next();
            stringConcatenation2.append("\t\t");
            string4 = this._roomExtensions.getPortClassName((RoomElement)ep);
            stringConcatenation2.append(string4, "\t\t");
            stringConcatenation2.append(" ");
            string3 = ep.getName();
            stringConcatenation2.append(string3, "\t\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("//--------------------- sub actors");
        stringConcatenation2.newLine();
        object = ac.getActorRefs();
        object2 = object.iterator();
        while (object2.hasNext()) {
            boolean bl2;
            ActorRef sub = (ActorRef)object2.next();
            int n = sub.getMultiplicity();
            boolean bl3 = bl2 = n > 1;
            if (bl2) {
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("Replicated");
                string2 = this._cppExtensions.getImplementationClassName(sub.getType());
                stringConcatenation2.append(string2, "\t\t");
                stringConcatenation2.append(" ");
                string = sub.getName();
                stringConcatenation2.append(string, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
                continue;
            }
            stringConcatenation2.append("\t\t");
            string2 = this._cppExtensions.getImplementationClassName(sub.getType());
            stringConcatenation2.append(string2, "\t\t");
            stringConcatenation2.append(" ");
            string = sub.getName();
            stringConcatenation2.append(string, "\t\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("//--------------------- saps");
        stringConcatenation2.newLine();
        object = ac.getServiceAccessPoints();
        object2 = object.iterator();
        while (object2.hasNext()) {
            SAP sap = (SAP)object2.next();
            stringConcatenation2.append("\t\t");
            string4 = this._roomExtensions.getPortClassName((RoomElement)sap);
            stringConcatenation2.append(string4, "\t\t");
            stringConcatenation2.append(" ");
            string3 = sap.getName();
            stringConcatenation2.append(string3, "\t\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("//--------------------- services");
        stringConcatenation2.newLine();
        object = ac.getServiceImplementations();
        object2 = object.iterator();
        while (object2.hasNext()) {
            ServiceImplementation svc = (ServiceImplementation)object2.next();
            stringConcatenation2.append("\t\t");
            string4 = this._roomExtensions.getPortClassName((RoomElement)svc);
            stringConcatenation2.append(string4, "\t\t");
            stringConcatenation2.append(" ");
            string3 = svc.getSpp().getName();
            stringConcatenation2.append(string3, "\t\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("//--------------------- interface item IDs");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        object = this.genInterfaceItemConstants(xpac);
        stringConcatenation2.append((String)object, "\t\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        charSequence3 = this._procedureHelpers.attributes((List)ac.getAttributes());
        stringConcatenation2.append((Object)charSequence3, "\t\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        object2 = this._procedureHelpers.operationsDeclaration((List)ac.getOperations(), ac.getName());
        stringConcatenation2.append(object2, "\t\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public:");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("//--------------------- construction");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        string4 = ac.getName();
        stringConcatenation2.append(string4, "\t\t");
        stringConcatenation2.append("(etRuntime::IRTObject* parent, const String& name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("void initialize(void);");
        stringConcatenation2.newLine();
        boolean bl4 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl4) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("void setProbesActive(bool recursive, bool active);");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("//--------------------- port getters");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        Functions.Function1 function1 = it -> {
            String string2 = this._roomExtensions.getPortClassName((RoomElement)it);
            String string3 = string2 + "&";
            return this._procedureHelpers.getterImplementation(string3, it.getName(), clsname);
        };
        string2 = IterableExtensions.join((Iterable)ListExtensions.map((List)this._roomHelpers.getEndPorts(ac), (Functions.Function1)function1), (CharSequence)this._roomExtensions.NEWLINE);
        stringConcatenation2.append(string2, "\t\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        string = it -> {
            String string2 = this._roomExtensions.getPortClassName((RoomElement)it);
            String string3 = string2 + "&";
            return this._procedureHelpers.getterImplementation(string3, it.getName(), clsname);
        };
        String string9 = IterableExtensions.join((Iterable)ListExtensions.map((List)ac.getServiceAccessPoints(), (Functions.Function1)string), (CharSequence)this._roomExtensions.NEWLINE);
        stringConcatenation2.append(string9, "\t\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        Functions.Function1 function12 = it -> {
            String string2 = this._roomExtensions.getPortClassName((RoomElement)it);
            String string3 = string2 + "&";
            return this._procedureHelpers.getterImplementation(string3, it.getSpp().getName(), clsname);
        };
        String string10 = IterableExtensions.join((Iterable)ListExtensions.map((List)ac.getServiceImplementations(), (Functions.Function1)function12), (CharSequence)this._roomExtensions.NEWLINE);
        stringConcatenation2.append(string10, "\t\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("//--------------------- lifecycle functions");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("virtual void destroy();");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        boolean bl5 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
        if (bl5) {
            stringConcatenation2.append("\t\t");
            charSequence2 = this._stateMachineGen.genStateMachineConstants(xpac.getGraphContainer());
            stringConcatenation2.append((Object)charSequence2, "\t\t");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            charSequence = this._stateMachineGen.genStateMachineMethods(xpac.getGraphContainer(), false);
            stringConcatenation2.append((Object)charSequence, "\t\t");
            stringConcatenation2.newLineIfNotEmpty();
            ComponentCommunicationType componentCommunicationType = ac.getCommType();
            boolean bl6 = Objects.equals(componentCommunicationType, ComponentCommunicationType.DATA_DRIVEN);
            if (bl6) {
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("void receiveEvent(etRuntime::InterfaceItemBase* ifitem, int evt, void* generic_data);");
                stringConcatenation2.newLine();
            }
            if (Objects.equals(ac.getCommType(), ComponentCommunicationType.ASYNCHRONOUS) || Objects.equals(ac.getCommType(), ComponentCommunicationType.DATA_DRIVEN)) {
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("virtual void receive(const etRuntime::Message* msg);");
                stringConcatenation2.newLine();
            }
        } else {
            boolean bl7 = FsmGenExtensions.isEmpty((Graph)xpac.getGraphContainer().getGraph());
            if (bl7) {
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("//--------------------- no state machine");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("virtual void receiveEvent(etRuntime::InterfaceItemBase* ifitem, int evt, void* data);");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("virtual void executeInitTransition() {}");
                stringConcatenation2.newLine();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        CharSequence charSequence5 = this._procedureHelpers.userCode(ac.getUserCode2());
        stringConcatenation2.append((Object)charSequence5, "\t\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("class Replicated");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append(" : public ReplicatedActorClassBase {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("public:");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("Replicated");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("(IRTObject* parent, const String& name) :");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("ReplicatedActorClassBase(parent, name) {}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("protected:");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ActorClassBase* createActor(IRTObject* parent, const String& name) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("return new ");
        stringConcatenation2.append(clsname, "\t\t");
        stringConcatenation2.append("(parent, name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        charSequence2 = this._cppExtensions.generateNamespaceEnd((RoomClass)ac);
        stringConcatenation2.append((String)charSequence2);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        charSequence = this._cppExtensions.generateIncludeGuardEnd((RoomClass)ac, "");
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence generateConstructorInitalizerList(ActorClass ac) {
        CharSequence charSequence = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList();
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = null;
        ActorClass actorClass = ac.getActorBase();
        String string2 = null;
        if (actorClass != null) {
            string2 = actorClass.getName();
        }
        string = string2 != null ? string2 : "ActorClassBase";
        stringConcatenation.append(string);
        stringConcatenation.append("(parent, name)");
        initList.add(stringConcatenation.toString());
        Functions.Function1 function1 = it -> {
            StringConcatenation stringConcatenation = new StringConcatenation();
            String string = it.getName();
            stringConcatenation.append(string);
            stringConcatenation.append("(this, \"");
            String string2 = it.getName();
            stringConcatenation.append(string2);
            stringConcatenation.append("\", IFITEM_");
            String string3 = it.getName();
            stringConcatenation.append(string3);
            stringConcatenation.append(")");
            return stringConcatenation.toString();
        };
        List list = ListExtensions.map((List)this._roomHelpers.getEndPorts(ac), (Functions.Function1)function1);
        Iterables.addAll((Collection)initList, (Iterable)list);
        Functions.Function1 function12 = it -> {
            StringConcatenation stringConcatenation = new StringConcatenation();
            String string = it.getName();
            stringConcatenation.append(string);
            stringConcatenation.append("(this, \"");
            String string2 = it.getName();
            stringConcatenation.append(string2);
            stringConcatenation.append("\")");
            return stringConcatenation.toString();
        };
        List list2 = ListExtensions.map((List)ac.getActorRefs(), (Functions.Function1)function12);
        Iterables.addAll((Collection)initList, (Iterable)list2);
        Functions.Function1 function13 = it -> {
            StringConcatenation stringConcatenation = new StringConcatenation();
            String string = it.getName();
            stringConcatenation.append(string);
            stringConcatenation.append("(this, \"");
            String string2 = it.getName();
            stringConcatenation.append(string2);
            stringConcatenation.append("\", IFITEM_");
            String string3 = it.getName();
            stringConcatenation.append(string3);
            stringConcatenation.append(")");
            return stringConcatenation.toString();
        };
        List list3 = ListExtensions.map((List)ac.getServiceAccessPoints(), (Functions.Function1)function13);
        Iterables.addAll((Collection)initList, (Iterable)list3);
        Functions.Function1 function14 = it -> {
            StringConcatenation stringConcatenation = new StringConcatenation();
            String string = it.getSpp().getName();
            stringConcatenation.append(string);
            stringConcatenation.append("(this, \"");
            String string2 = it.getSpp().getName();
            stringConcatenation.append(string2);
            stringConcatenation.append("\", IFITEM_");
            String string3 = it.getSpp().getName();
            stringConcatenation.append(string3);
            stringConcatenation.append(")");
            return stringConcatenation.toString();
        };
        List list4 = ListExtensions.map((List)ac.getServiceImplementations(), (Functions.Function1)function14);
        Iterables.addAll((Collection)initList, (Iterable)list4);
        Functions.Function1 function15 = it -> {
            StringConcatenation stringConcatenation = new StringConcatenation();
            String string = it.getName();
            stringConcatenation.append(string);
            stringConcatenation.append("(");
            String string2 = initHelper.getInitializerListValue((Attribute)it);
            stringConcatenation.append(string2);
            stringConcatenation.append(")");
            return stringConcatenation.toString();
        };
        List list5 = ListExtensions.map((List)ac.getAttributes(), (Functions.Function1)function15);
        Iterables.addAll((Collection)initList, (Iterable)list5);
        charSequence = initHelper.generateCtorInitializerList(initList);
        return charSequence;
    }

    protected CharSequence generateSourceFile(Root root, ExpandedActorClass xpac, WiredActorClass wired, boolean manualBehavior) {
        String string;
        int n;
        boolean bl;
        int n2;
        int n3;
        Object object;
        boolean bl2;
        int n4;
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        Object object2 = null;
        if (manualBehavior) {
            String string2 = ac.getName();
            object2 = "Abstract" + string2;
        } else {
            object2 = ac.getName();
        }
        String clsname = object2;
        String string3 = null;
        ActorClass actorClass = ac.getActorBase();
        String string4 = null;
        if (actorClass != null) {
            string4 = actorClass.getName();
        }
        string3 = string4 != null ? string4 : "ActorClassBase";
        String rtBaseClassName = string3;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Source File of ActorClass ");
        String string5 = ac.getName();
        stringConcatenation2.append(string5, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        String string6 = this._cppExtensions.getCppHeaderFileName((RoomClass)ac);
        stringConcatenation2.append(string6);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/messaging/RTObject.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/messaging/RTServices.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/debugging/DebuggingService.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/debugging/MSCFunctionObject.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("using namespace etRuntime;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        String string7 = this._cppExtensions.generateNamespaceBegin((RoomClass)ac);
        stringConcatenation2.append(string7);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence = this._procedureHelpers.userCode(ac.getUserCode3());
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("::");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("(etRuntime::IRTObject* parent, const String& name)");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        CharSequence charSequence2 = this.generateConstructorInitalizerList(ac);
        stringConcatenation2.append((Object)charSequence2, "\t\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        boolean bl3 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl3) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"Constructor\");");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        bl3 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
        if (bl3) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("for (int i = 0; i < s_numberOfStates; i++) {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("history[i] = NO_STATE;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("setClassName(\"");
        String string8 = ac.getName();
        stringConcatenation2.append(string8, "\t");
        stringConcatenation2.append("\");");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// sub actors");
        stringConcatenation2.newLine();
        Object object3 = ac.getActorRefs();
        for (ActorRef sub : object3) {
            n4 = sub.getMultiplicity();
            boolean bl4 = bl2 = n4 > 1;
            if (!bl2) continue;
            stringConcatenation2.append("\t");
            object = sub.getName();
            stringConcatenation2.append((String)object, "\t");
            stringConcatenation2.append(".createSubActors(");
            n3 = sub.getMultiplicity();
            stringConcatenation2.append((Object)n3, "\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        object3 = this.initHelper.genExtraInitializers((Iterable<Attribute>)ac.getAttributes());
        stringConcatenation2.append(object3, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        String string9 = this._procedureHelpers.userStructorBody((RoomClass)ac, true);
        stringConcatenation2.append(string9, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        String string10 = ac.getName();
        stringConcatenation2.append(string10);
        stringConcatenation2.append("::initialize() {");
        stringConcatenation2.newLineIfNotEmpty();
        n4 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) ? 1 : 0;
        if (n4 != 0) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"initialize()\");");
            stringConcatenation2.newLine();
            EList eList = ac.getActorRefs();
            for (ActorRef sub_1 : eList) {
                n2 = sub_1.getMultiplicity();
                boolean bl5 = bl = n2 > 1;
                if (bl) {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("for (int i=0; i<");
                    n = sub_1.getMultiplicity();
                    stringConcatenation2.append((Object)n, "\t");
                    stringConcatenation2.append("; ++i) {");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("DebuggingService::getInstance().addMessageActorCreate(*this, ");
                    string = sub_1.getName();
                    stringConcatenation2.append(string, "\t\t");
                    stringConcatenation2.append(".getSubActor(i)->getName());");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("}");
                    stringConcatenation2.newLine();
                    continue;
                }
                stringConcatenation2.append("\t");
                stringConcatenation2.append("DebuggingService::getInstance().addMessageActorCreate(*this, \"");
                String string11 = sub_1.getName();
                stringConcatenation2.append(string11, "\t");
                stringConcatenation2.append("\");");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ActorClassBase::initialize();");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        EList eList = ac.getActorRefs();
        for (ActorRef sub_2 : eList) {
            stringConcatenation2.append("\t");
            String string12 = sub_2.getName();
            stringConcatenation2.append(string12, "\t");
            stringConcatenation2.append(".initialize();");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// wiring");
        stringConcatenation2.newLine();
        eList = wired.getWires();
        for (Wire wire : eList) {
            stringConcatenation2.append("\t");
            String string13 = null;
            n2 = wire.isDataDriven() ? 1 : 0;
            string13 = n2 != 0 ? "DataPortBase" : "InterfaceItemBase";
            stringConcatenation2.append(string13, "\t");
            stringConcatenation2.append("::connect(this, \"");
            String string14 = IterableExtensions.join((Iterable)wire.getPath1(), (CharSequence)"/");
            stringConcatenation2.append(string14, "\t");
            stringConcatenation2.append("\", \"");
            String string15 = IterableExtensions.join((Iterable)wire.getPath2(), (CharSequence)"/");
            stringConcatenation2.append(string15, "\t");
            stringConcatenation2.append("\");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        if (Objects.equals(ac.getCommType(), ComponentCommunicationType.ASYNCHRONOUS) || Objects.equals(ac.getCommType(), ComponentCommunicationType.DATA_DRIVEN)) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("// activate polling for data-driven communication");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("RTServices::getInstance().getMsgSvcCtrl().getMsgSvc(getThread())->addPollingMessageReceiver(*this);");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        boolean bl6 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl6) {
            stringConcatenation2.append("void ");
            String string16 = ac.getName();
            stringConcatenation2.append(string16);
            stringConcatenation2.append("::setProbesActive(bool recursive, bool active) {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("DebuggingService::getInstance().addPortInstance(m_RTSystemPort);");
            stringConcatenation2.newLine();
            int n5 = ac.getActorRefs().size();
            int n6 = n3 = n5 > 0 ? 1 : 0;
            if (n3 != 0) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("if(recursive) {");
                stringConcatenation2.newLine();
                EList eList2 = ac.getActorRefs();
                for (ActorRef sub_3 : eList2) {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    string = sub_3.getName();
                    stringConcatenation2.append(string, "\t\t");
                    stringConcatenation2.append(".setProbesActive(recursive, active);");
                    stringConcatenation2.newLineIfNotEmpty();
                }
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
            object = this._roomHelpers.getEndPorts(ac);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string17;
                Port ep = (Port)iterator.next();
                bl = this._roomHelpers.isDataDriven((InterfaceItem)ep);
                int n7 = n = bl ? 0 : 1;
                if (n == 0) continue;
                boolean bl7 = ep.isReplicated();
                if (bl7) {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("for(int i = 0; i < ");
                    string17 = ep.getName();
                    stringConcatenation2.append(string17, "\t");
                    stringConcatenation2.append(".getNInterfaceItems(); i++)");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("DebuggingService::getInstance().addPortInstance(*(");
                    String string18 = ep.getName();
                    stringConcatenation2.append(string18, "\t\t");
                    stringConcatenation2.append(".getInterfaceItem(i)));");
                    stringConcatenation2.newLineIfNotEmpty();
                    continue;
                }
                stringConcatenation2.append("\t");
                stringConcatenation2.append("DebuggingService::getInstance().addPortInstance(");
                string17 = ep.getName();
                stringConcatenation2.append(string17, "\t");
                stringConcatenation2.append(");");
                stringConcatenation2.newLineIfNotEmpty();
            }
            object = ac.getServiceAccessPoints();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                SAP sap = (SAP)iterator.next();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("DebuggingService::getInstance().addPortInstance(");
                String string19 = sap.getName();
                stringConcatenation2.append(string19, "\t");
                stringConcatenation2.append(");");
                stringConcatenation2.newLineIfNotEmpty();
            }
            object = ac.getServiceProvisionPoints();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                SPP spp = (SPP)iterator.next();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("for(int i = 0; i < ");
                String string20 = spp.getName();
                stringConcatenation2.append(string20, "\t");
                stringConcatenation2.append(".getNInterfaceItems(); i++)");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("DebuggingService::getInstance().addPortInstance(*(");
                String string21 = spp.getName();
                stringConcatenation2.append(string21, "\t\t\t");
                stringConcatenation2.append(".getInterfaceItem(i)));");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        String string22 = ac.getName();
        stringConcatenation2.append(string22);
        stringConcatenation2.append("::destroy(){");
        stringConcatenation2.newLineIfNotEmpty();
        bl2 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl2) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"destroy()\");");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        String string23 = this._procedureHelpers.userStructorBody((RoomClass)ac, false);
        stringConcatenation2.append(string23, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        boolean bl8 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl8) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("DebuggingService::getInstance().addMessageActorDestroy(*this);");
            stringConcatenation2.newLine();
        }
        if (Objects.equals(ac.getCommType(), ComponentCommunicationType.ASYNCHRONOUS) || Objects.equals(ac.getCommType(), ComponentCommunicationType.DATA_DRIVEN)) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("RTServices::getInstance().getMsgSvcCtrl().getMsgSvc(getThread())->removePollingMessageReceiver(*this);");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append(rtBaseClassName, "\t");
        stringConcatenation2.append("::destroy();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence3 = this._procedureHelpers.operationsImplementation((List)ac.getOperations(), ac.getName());
        stringConcatenation2.append((Object)charSequence3);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        n3 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac) ? 1 : 0;
        if (n3 != 0) {
            CharSequence charSequence4 = this._stateMachineGen.genStateMachineMethods(xpac.getGraphContainer(), true);
            stringConcatenation2.append((Object)charSequence4);
            stringConcatenation2.newLineIfNotEmpty();
            Object object4 = ac.getCommType();
            n = Objects.equals(object4, ComponentCommunicationType.DATA_DRIVEN) ? 1 : 0;
            if (n != 0) {
                stringConcatenation2.append("void ");
                string = ac.getName();
                stringConcatenation2.append(string);
                stringConcatenation2.append("::receiveEvent(InterfaceItemBase* ifitem, int evt, void* generic_data) {");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("handleSystemEvent(ifitem, evt, generic_data);");
                stringConcatenation2.newLine();
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
            if (Objects.equals(ac.getCommType(), ComponentCommunicationType.ASYNCHRONOUS) || Objects.equals(ac.getCommType(), ComponentCommunicationType.DATA_DRIVEN)) {
                stringConcatenation2.append("void ");
                object4 = ac.getName();
                stringConcatenation2.append((String)object4);
                stringConcatenation2.append("::receive(const Message* msg) {");
                stringConcatenation2.newLineIfNotEmpty();
                ComponentCommunicationType componentCommunicationType = ac.getCommType();
                boolean bl9 = Objects.equals(componentCommunicationType, ComponentCommunicationType.ASYNCHRONOUS);
                if (bl9) {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("receiveEvent(0, -1, 0);");
                    stringConcatenation2.newLine();
                } else {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("receiveEventInternal();");
                    stringConcatenation2.newLine();
                }
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
        } else {
            boolean bl10 = FsmGenExtensions.isEmpty((Graph)xpac.getGraphContainer().getGraph());
            if (bl10) {
                stringConcatenation2.append("//--------------------- no state machine");
                stringConcatenation2.newLine();
                stringConcatenation2.append("void ");
                String string24 = ac.getName();
                stringConcatenation2.append(string24);
                stringConcatenation2.append("::receiveEvent(InterfaceItemBase* ifitem, int evt, void* data) {");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("handleSystemEvent(ifitem, evt, data);");
                stringConcatenation2.newLine();
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
        }
        stringConcatenation2.newLine();
        String string25 = this._cppExtensions.generateNamespaceEnd((RoomClass)ac);
        stringConcatenation2.append(string25);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }
}

