/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.util.HashSet;
import org.apache.catalina.core.StandardContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedStandardContext
extends StandardContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedStandardContext.class);
    private final Bundle bundle;

    public ExtendedStandardContext(Bundle bundle) {
        this.bundle = bundle;
    }

    public synchronized void reload() {
        if (!this.getState().isAvailable()) {
            throw new IllegalStateException("Context with name [" + this.getName() + "] has not yet been started.");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Reloading Context with name [" + this.getName() + "] has started.");
        }
        Bundle systemBundle = this.bundle.getBundleContext().getBundle(0L);
        FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        bundles.add(this.bundle);
        frameworkWiring.refreshBundles(bundles, new FrameworkListener[0]);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Reloading Context with name [" + this.getName() + "] is completed");
        }
    }

    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        this.parentClassLoader = this.getLoader().getClassLoader();
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        return super.getParentClassLoader();
    }
}

