/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.tracing;

import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.ConsolePlugin;

public class PrintCrossCuttingModelAction
extends Action {
    private static final String toolTipText = "Prints the Crosscutting model of all AspectJ projects in the workspace to the log";

    public PrintCrossCuttingModelAction() {
        super("Print Crosscutting Model");
        this.setToolTipText(toolTipText);
        this.setHoverImageDescriptor(AspectJImages.COMPARISON.getImageDescriptor());
        this.setDisabledImageDescriptor(AspectJImages.COMPARISON.getImageDescriptor());
        this.setImageDescriptor(AspectJImages.COMPARISON.getImageDescriptor());
    }

    public void run() {
        BusyIndicator.showWhile((Display)ConsolePlugin.getStandardDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                PrintCrossCuttingModelAction.this.printCrossCuttingModel();
            }
        });
    }

    private void printCrossCuttingModel() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        AJLog.log((String)"Printing crosscutting model for all AspectJ projects in the workspace");
        int i = 0;
        while (i < allProjects.length) {
            IProject project = allProjects[i];
            if (AspectJPlugin.isAJProject((IProject)project)) {
                AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForProject(project);
                AJLog.log((String)"");
                AJLog.log((String)"--------------------------------------");
                AJLog.log((String)("Printing crosscutting model for " + project.getName()));
                AJLog.log((String)model.getModelAsString());
                AJLog.log((String)"--------------------------------------");
                AJLog.log((String)"");
            }
            ++i;
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
    }

    public void fillViewMenu(IMenuManager viewMenu) {
    }

    private void fillToolBar(IToolBarManager tooBar) {
        PrintCrossCuttingModelAction showDialogAction = new PrintCrossCuttingModelAction();
        showDialogAction.setToolTipText(toolTipText);
        tooBar.add((IAction)showDialogAction);
    }
}

