/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.viewers.CategoryManager;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategory;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategoryItem;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategorySet;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class CategoryViewer
extends Viewer {
    protected TreeViewer _viewer;
    private Input _input = null;
    private final IPropertyChangeListener _configUpdater = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event_p) {
            if ("PROPERTY_CATEGORIES_CONFIGURATION_CHANGES".equals(event_p.getProperty())) {
                CategoryViewer.this.refresh();
            }
        }
    };

    public CategoryViewer(Composite parent_p) {
        this.createControls(parent_p);
    }

    protected void createControls(Composite parent_p) {
        Composite wrapper = new Composite(parent_p, 0);
        GridData wrapperData = new GridData(4, 4, true, true);
        wrapper.setLayoutData((Object)wrapperData);
        TreeColumnLayout layout = new TreeColumnLayout();
        wrapper.setLayout((Layout)layout);
        this._viewer = new TreeViewer(wrapper, 100884);
        this._viewer.getTree().setHeaderVisible(true);
        this._viewer.getTree().setLinesVisible(true);
        this._viewer.setAutoExpandLevel(-1);
        TreeViewerColumn catItemColumn = new TreeViewerColumn(this._viewer, 16384);
        catItemColumn.getColumn().setText(Messages.CategoryViewer_CategoryHeader);
        catItemColumn.setLabelProvider((CellLabelProvider)new HierarchyLabelProvider());
        TreeViewerColumn normalStateColumn = new TreeViewerColumn(this._viewer, 0x1000000);
        normalStateColumn.getColumn().setText(Messages.CategoryViewer_NormalStateHeader);
        normalStateColumn.getColumn().setToolTipText(Messages.CategoryViewer_NormalStateTooltip);
        normalStateColumn.setLabelProvider((CellLabelProvider)new StateLabelProvider(CategoryState.NORMAL));
        normalStateColumn.setEditingSupport((EditingSupport)new StateEditingSupport((ColumnViewer)this._viewer, CategoryState.NORMAL));
        normalStateColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                Input input = CategoryViewer.this.getInput();
                if (input != null) {
                    input.setAll(CategoryState.NORMAL);
                }
            }
        });
        TreeViewerColumn filteredStateColumn = new TreeViewerColumn(this._viewer, 0x1000000);
        filteredStateColumn.getColumn().setText(Messages.CategoryViewer_FilteredStateHeader);
        filteredStateColumn.getColumn().setToolTipText(Messages.CategoryViewer_FilteredStateTooltip);
        filteredStateColumn.setLabelProvider((CellLabelProvider)new StateLabelProvider(CategoryState.FILTERED));
        filteredStateColumn.setEditingSupport((EditingSupport)new StateEditingSupport((ColumnViewer)this._viewer, CategoryState.FILTERED));
        filteredStateColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                Input input = CategoryViewer.this.getInput();
                if (input != null) {
                    input.setAll(CategoryState.FILTERED);
                }
            }
        });
        TreeViewerColumn focusedStateColumn = new TreeViewerColumn(this._viewer, 0x1000000);
        focusedStateColumn.getColumn().setText(Messages.CategoryViewer_FocusedStateHeader);
        focusedStateColumn.getColumn().setToolTipText(Messages.CategoryViewer_FocusedStateTooltip);
        focusedStateColumn.setLabelProvider((CellLabelProvider)new StateLabelProvider(CategoryState.FOCUSED));
        focusedStateColumn.setEditingSupport((EditingSupport)new StateEditingSupport((ColumnViewer)this._viewer, CategoryState.FOCUSED));
        focusedStateColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                Input input = CategoryViewer.this.getInput();
                if (input != null) {
                    input.setAll(CategoryState.FOCUSED);
                }
            }
        });
        layout.setColumnData((Widget)catItemColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 300, true));
        int STATE_COLUMN_WIDTH = 70;
        layout.setColumnData((Widget)normalStateColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, 70, false));
        layout.setColumnData((Widget)filteredStateColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, 70, false));
        layout.setColumnData((Widget)focusedStateColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, 70, false));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this._viewer);
        this._viewer.setContentProvider((IContentProvider)new ContentProvider());
    }

    public Control getControl() {
        return this._viewer.getControl();
    }

    public Input getInput() {
        return this._input;
    }

    public ISelection getSelection() {
        return this._viewer.getSelection();
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    protected void inputChanged(Object input_p, Object oldInput_p) {
        if (oldInput_p instanceof Input) {
            ((Input)oldInput_p).removePropertyChangeListener(this._configUpdater);
        }
        if (input_p instanceof Input) {
            ((Input)input_p).addPropertyChangeListener(this._configUpdater);
        }
    }

    public void refresh() {
        this._viewer.refresh(true);
    }

    public void setInput(Object input_p) {
        if (input_p instanceof Input) {
            Input oldInput = this.getInput();
            this._input = (Input)input_p;
            this.inputChanged(this._input, oldInput);
            this._viewer.setInput(input_p);
        }
    }

    public void setSelection(ISelection selection_p, boolean reveal_p) {
        this._viewer.setSelection(selection_p, reveal_p);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CategoryState {
        NORMAL,
        FILTERED,
        FOCUSED;

    }

    protected static class ContentProvider
    implements ITreeContentProvider {
        private Input _input = null;

        protected ContentProvider() {
        }

        public void dispose() {
            this._input = null;
        }

        public Object[] getChildren(Object parentElement_p) {
            Object[] result;
            if (parentElement_p instanceof IDifferenceCategorySet) {
                IDifferenceCategorySet catSet = (IDifferenceCategorySet)parentElement_p;
                Object listResult = this._input == null ? catSet.getChildren() : this._input.getNode().getCategoryManager().getUIChildrenItems(catSet);
                result = listResult.toArray();
            } else {
                result = new Object[]{};
            }
            return result;
        }

        public Object[] getElements(Object inputElement_p) {
            EMFDiffNode node = ((Input)inputElement_p).getNode();
            return node.getCategoryManager().getUIRootItems().toArray();
        }

        public Object getParent(Object element_p) {
            IDifferenceCategorySet result = null;
            if (element_p instanceof IDifferenceCategoryItem) {
                result = ((IDifferenceCategoryItem)element_p).getParent();
            }
            return result;
        }

        public boolean hasChildren(Object element_p) {
            return this.getChildren(element_p).length > 0;
        }

        public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
            if (newInput_p instanceof Input) {
                this._input = (Input)newInput_p;
            }
        }
    }

    protected class HierarchyLabelProvider
    extends ColumnLabelProvider {
        protected HierarchyLabelProvider() {
        }

        public Image getImage(Object element_p) {
            Image result = null;
            if (element_p instanceof IDifferenceCategoryItem) {
                IDifferenceCategoryItem catItem = (IDifferenceCategoryItem)element_p;
                EMFDiffNode node = CategoryViewer.this.getInput().getNode();
                result = catItem.getImage(node);
            }
            return result;
        }

        public String getText(Object element_p) {
            String result;
            if (element_p instanceof IDifferenceCategoryItem) {
                IDifferenceCategoryItem catItem = (IDifferenceCategoryItem)element_p;
                EMFDiffNode node = CategoryViewer.this.getInput().getNode();
                result = catItem.getText(node);
            } else {
                result = super.getText(element_p);
            }
            return result;
        }

        public String getToolTipText(Object element_p) {
            String result = null;
            if (element_p instanceof IDifferenceCategoryItem) {
                IDifferenceCategoryItem catItem = (IDifferenceCategoryItem)element_p;
                EMFDiffNode node = CategoryViewer.this.getInput().getNode();
                result = catItem.getDescription(node);
            }
            return result;
        }
    }

    public static class Input
    implements IPropertyChangeNotifier {
        public static final String PROPERTY_HAS_CHANGES = "PROPERTY_CATEGORIES_HAS_CHANGES";
        public static final String PROPERTY_CONFIGURATION = "PROPERTY_CATEGORIES_CONFIGURATION_CHANGES";
        private final EMFDiffNode _node;
        private final Set<IPropertyChangeListener> _changeListeners;
        private final Map<IDifferenceCategory, CategoryState> _changedCategories;

        public Input(EMFDiffNode node_p) {
            this._node = node_p;
            this._changedCategories = new HashMap<IDifferenceCategory, CategoryState>();
            this._changeListeners = new HashSet<IPropertyChangeListener>(1);
        }

        public boolean addChange(IDifferenceCategory category_p, CategoryState state_p) {
            boolean hadChanges = this.hasChanges();
            boolean result = this.addSilentChange(category_p, state_p);
            boolean hasChanges = this.hasChanges();
            if (hasChanges != hadChanges) {
                this.firePropertyChangeEvent(PROPERTY_HAS_CHANGES, hasChanges);
            }
            return result;
        }

        protected boolean addSilentChange(IDifferenceCategory category_p, CategoryState state_p) {
            CategoryState previousState;
            CategoryState previousChange;
            CategoryState currentState = this.getActualState(category_p);
            boolean result = currentState == state_p ? (previousChange = this._changedCategories.remove(category_p)) != null : (previousState = this._changedCategories.put(category_p, state_p)) != state_p;
            return result;
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener_p) {
            this._changeListeners.add(listener_p);
        }

        public void applyChanges() {
            if (this.hasChanges()) {
                for (Map.Entry<IDifferenceCategory, CategoryState> change : this._changedCategories.entrySet()) {
                    this.applyChange(change.getKey(), change.getValue());
                }
                this._changedCategories.clear();
                this._node.updateDifferenceNumbers();
                this.firePropertyChangeEvent(PROPERTY_HAS_CHANGES, Boolean.FALSE);
            }
        }

        protected void applyChange(IDifferenceCategory category_p, CategoryState state_p) {
            switch (state_p) {
                case FILTERED: {
                    category_p.setInFocusMode(false);
                    category_p.setActive(true);
                    break;
                }
                case FOCUSED: {
                    category_p.setInFocusMode(true);
                    category_p.setActive(true);
                    break;
                }
                default: {
                    category_p.setActive(false);
                }
            }
        }

        protected void firePropertyChangeEvent(String propertyName_p, Object newValue_p) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, propertyName_p, null, newValue_p);
            for (IPropertyChangeListener listener : this._changeListeners) {
                listener.propertyChange(event);
            }
        }

        protected CategoryState getActualState(IDifferenceCategory category_p) {
            return !category_p.isActive() ? CategoryState.NORMAL : (category_p.isInFocusMode() ? CategoryState.FOCUSED : CategoryState.FILTERED);
        }

        public EMFDiffNode getNode() {
            return this._node;
        }

        public CategoryState getStateWithChanges(IDifferenceCategory category_p) {
            CategoryState result = this._changedCategories.get(category_p);
            if (result == null) {
                result = this.getActualState(category_p);
            }
            return result;
        }

        public boolean hasChanges() {
            return !this._changedCategories.isEmpty();
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener_p) {
            this._changeListeners.remove(listener_p);
        }

        public void removePropertyChangeListeners() {
            this._changeListeners.clear();
        }

        public void resetToDefault() {
            boolean hadChanges = this.hasChanges();
            boolean hadImpact = false;
            CategoryManager manager = this._node.getCategoryManager();
            Collection<IDifferenceCategory> defaultConfig = manager.getDefaultConfiguration();
            for (IDifferenceCategory defaultCat : defaultConfig) {
                String id = defaultCat.getID();
                IDifferenceCategory actualCat = manager.getCategory(id);
                if (actualCat == null) continue;
                CategoryState defaultState = this.getActualState(defaultCat);
                boolean hasImpact = this.addSilentChange(actualCat, defaultState);
                boolean bl = hadImpact = hadImpact || hasImpact;
            }
            boolean hasChanges = this.hasChanges();
            if (hasChanges != hadChanges) {
                this.firePropertyChangeEvent(PROPERTY_HAS_CHANGES, hasChanges);
            }
            if (hadImpact) {
                this.firePropertyChangeEvent(PROPERTY_CONFIGURATION, null);
            }
        }

        public void setAll(CategoryState state_p) {
            boolean hadImpact = false;
            boolean hadChanges = this.hasChanges();
            for (IDifferenceCategory cat : this.getNode().getCategoryManager().getCategories()) {
                if (!cat.isVisible() || !cat.isModifiable()) continue;
                boolean hasImpact = this.addSilentChange(cat, state_p);
                boolean bl = hadImpact = hadImpact || hasImpact;
            }
            boolean hasChanges = this.hasChanges();
            if (hasChanges != hadChanges) {
                this.firePropertyChangeEvent(PROPERTY_HAS_CHANGES, hasChanges);
            }
            if (hadImpact) {
                this.firePropertyChangeEvent(PROPERTY_CONFIGURATION, null);
            }
        }
    }

    protected class StateEditingSupport
    extends EditingSupport {
        protected final CategoryState _state;

        public StateEditingSupport(ColumnViewer viewer_p, CategoryState state_p) {
            super(viewer_p);
            this._state = state_p;
        }

        protected CellEditor getCellEditor(Object element_p) {
            return new CellEditor(){

                public void activate() {
                    this.fireApplyEditorValue();
                }

                public void activate(ColumnViewerEditorActivationEvent activationEvent_p) {
                    if (activationEvent_p.eventType != 5) {
                        super.activate(activationEvent_p);
                    }
                }

                protected Control createControl(Composite parent_p) {
                    return null;
                }

                protected Object doGetValue() {
                    return null;
                }

                protected void doSetFocus() {
                }

                protected void doSetValue(Object value_p) {
                }
            };
        }

        protected boolean canEdit(Object element_p) {
            boolean result = false;
            if (element_p instanceof IDifferenceCategory) {
                IDifferenceCategory cat = (IDifferenceCategory)element_p;
                result = cat.isModifiable();
            }
            return result;
        }

        protected Object getValue(Object element_p) {
            return null;
        }

        protected void setValue(Object element_p, Object value_p) {
            if (element_p instanceof IDifferenceCategory) {
                IDifferenceCategory cat = (IDifferenceCategory)element_p;
                this.selectState(cat);
                this.getViewer().update((Object)cat, null);
            }
        }

        protected void selectState(IDifferenceCategory category_p) {
            if (category_p.isModifiable()) {
                CategoryViewer.this.getInput().addChange(category_p, this._state);
            }
        }
    }

    protected class StateLabelProvider
    extends ColumnLabelProvider {
        protected final CategoryState _state;

        public StateLabelProvider(CategoryState state_p) {
            this._state = state_p;
        }

        public Image getImage(Object element_p) {
            Image result = null;
            if (element_p instanceof IDifferenceCategory) {
                IDifferenceCategory cat = (IDifferenceCategory)element_p;
                boolean selected = this.isSelected(cat);
                EMFDiffMergeUIPlugin.ImageID imageId = cat.isModifiable() ? (selected ? EMFDiffMergeUIPlugin.ImageID.CHECKED : EMFDiffMergeUIPlugin.ImageID.UNCHECKED) : (selected ? EMFDiffMergeUIPlugin.ImageID.CHECKED_DISABLED : EMFDiffMergeUIPlugin.ImageID.UNCHECKED_DISABLED);
                result = EMFDiffMergeUIPlugin.getDefault().getImage(imageId);
            }
            return result;
        }

        public String getText(Object element_p) {
            return null;
        }

        public String getToolTipText(Object element_p) {
            String result;
            switch (this._state) {
                case FILTERED: {
                    result = Messages.CategoryViewer_FilteredStateTooltip;
                    break;
                }
                case FOCUSED: {
                    result = Messages.CategoryViewer_FocusedStateTooltip;
                    break;
                }
                default: {
                    result = Messages.CategoryViewer_NormalStateTooltip;
                }
            }
            return result;
        }

        protected boolean isSelected(IDifferenceCategory category_p) {
            return this._state == CategoryViewer.this.getInput().getStateWithChanges(category_p);
        }
    }
}

