/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.messagingsystem.api;

import java.io.BufferedReader;
import java.net.URL;
import org.eclipse.gemoc.commons.messagingsystem.api.reference.Reference;

public abstract class MessagingSystem {
    public static int UNKNOWN_NBWORKUNIT = -1;
    protected String baseMessageGroup = "";
    protected String userFriendlyName = "";

    public MessagingSystem initialize(String baseMessageGroup, String userFriendlyName) {
        this.baseMessageGroup = baseMessageGroup;
        this.userFriendlyName = userFriendlyName;
        return this;
    }

    public abstract void clearLog();

    public abstract void log(Kind var1, String var2, String var3);

    public abstract void log(Kind var1, String var2, String var3, Throwable var4);

    public abstract void logProblem(Kind var1, String var2, String var3, Reference var4);

    public abstract void logProblem(Kind var1, String var2, String var3, Throwable var4, Reference var5);

    public abstract void flushProblem(String var1, URL var2);

    public abstract void flushAllProblems(URL var1);

    public abstract BufferedReader getReader();

    public abstract String readLine();

    public abstract String readLine(String var1);

    public abstract void initProgress(String var1, String var2, String var3, int var4);

    public abstract void progress(String var1, String var2, String var3, int var4);

    public abstract void doneProgress(String var1, String var2, String var3);

    public void debug(String message, String messageGroup) {
        this.log(Kind.DevDEBUG, message, messageGroup);
    }

    public void devInfo(String message, String messageGroup) {
        this.log(Kind.DevINFO, message, messageGroup);
    }

    public void info(String message, String messageGroup) {
        this.log(Kind.UserINFO, message, messageGroup);
    }

    public void important(String message, String messageGroup) {
        this.log(Kind.UserImportantINFO, message, messageGroup);
    }

    public void warn(String message, String messageGroup, Throwable senderTrace) {
        this.log(Kind.DevWARNING, message, messageGroup, senderTrace);
    }

    public void warn(String message, String messageGroup) {
        this.log(Kind.UserWARNING, message, messageGroup, null);
    }

    public void error(String message, String messageGroup, Throwable senderTrace) {
        this.log(Kind.DevERROR, message, messageGroup, senderTrace);
    }

    public void error(String message, String messageGroup) {
        this.log(Kind.UserERROR, message, messageGroup, null);
    }

    public void focus() {
    }

    public static enum Kind {
        UserINFO,
        UserImportantINFO,
        UserWARNING,
        UserERROR,
        DevDEBUG,
        DevINFO,
        DevWARNING,
        DevERROR;

    }
}

