/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.pde.manifest;

import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class ManifestChangerPluginDependency {
    private ManifestChanger _connection;

    public ManifestChangerPluginDependency(ManifestChanger connection) {
        this._connection = connection;
    }

    public void add(String pluginName) throws BundleException, IOException, CoreException {
        this.add(pluginName, "0.0.0", true, true);
    }

    private Manifest getManifest() throws IOException, CoreException {
        return this._connection.getManifest();
    }

    public void add(String plugin, String version, boolean reexport, boolean overwrite) throws BundleException, IOException, CoreException {
        String requireBundleHeader = "Require-Bundle";
        String bundleVersionAttr = "bundle-version";
        String rexportDirective = "visibility";
        assert (plugin != null);
        if (plugin == null) {
            return;
        }
        if (version == null) {
            version = "1.0.0";
        }
        boolean foundHeader = false;
        boolean hasValuesForPlugin = false;
        StringBuilder strBuilder = new StringBuilder();
        Attributes mainAttrs = this.getManifest().getMainAttributes();
        for (Object entryName : mainAttrs.keySet()) {
            String values;
            String header;
            if (entryName instanceof String) {
                header = (String)entryName;
                values = mainAttrs.getValue(header);
            } else if (entryName instanceof Attributes.Name) {
                header = ((Attributes.Name)entryName).toString();
                values = mainAttrs.getValue((Attributes.Name)entryName);
            } else {
                throw new BundleException("Unknown Main Attribute Key type: " + entryName.getClass() + " (" + entryName + ")");
            }
            if (!"Require-Bundle".equals(header)) continue;
            foundHeader = true;
            if (values == null) break;
            ManifestElement[] elements = ManifestElement.parseHeader((String)header, (String)values);
            int i = 0;
            while (i < elements.length) {
                ManifestElement manifestElement = elements[i];
                Enumeration keys = manifestElement.getKeys();
                Enumeration directiveKeys = manifestElement.getDirectiveKeys();
                StringBuilder valueComponents = new StringBuilder();
                boolean lastElement = i >= elements.length - 1;
                boolean firstElement = i == 0;
                boolean elementIsRequiredPlugin = false;
                int j = 0;
                while (j < manifestElement.getValueComponents().length) {
                    String pureValue = manifestElement.getValueComponents()[j];
                    if (plugin.equalsIgnoreCase(pureValue)) {
                        hasValuesForPlugin = true;
                        elementIsRequiredPlugin = true;
                        if (!overwrite) {
                            return;
                        }
                    }
                    valueComponents.append(String.valueOf(pureValue) + ";");
                    ++j;
                }
                if (!elementIsRequiredPlugin) {
                    strBuilder.append(String.valueOf(firstElement ? "" : " ") + manifestElement + (lastElement ? "" : ",\n"));
                } else {
                    strBuilder.append(String.valueOf(firstElement ? "" : " ") + valueComponents);
                    boolean foundVersionAttr = false;
                    if (keys != null) {
                        while (keys.hasMoreElements()) {
                            String key = (String)keys.nextElement();
                            String value = manifestElement.getAttribute(key);
                            if ("bundle-version".equalsIgnoreCase(key)) {
                                strBuilder.append(String.valueOf(key) + "=\"" + version + "\";");
                                foundVersionAttr = true;
                                continue;
                            }
                            strBuilder.append(String.valueOf(key) + "=\"" + value + "\";");
                        }
                    }
                    if (!foundVersionAttr) {
                        strBuilder.append("bundle-version=" + version + ";");
                    }
                    boolean foundDirective = false;
                    if (directiveKeys != null) {
                        while (directiveKeys.hasMoreElements()) {
                            boolean lastDirective;
                            String key = (String)directiveKeys.nextElement();
                            boolean bl = lastDirective = !directiveKeys.hasMoreElements();
                            if ("visibility".equalsIgnoreCase(key)) {
                                foundDirective = true;
                                strBuilder.append(String.valueOf(key) + ":=");
                                String[] dirValues = manifestElement.getDirectives(key);
                                int j2 = 0;
                                while (j2 < dirValues.length) {
                                    boolean lastDirectiveValue;
                                    String string = dirValues[j2];
                                    boolean bl2 = lastDirectiveValue = j2 >= dirValues.length - 1;
                                    if ("reexport".equalsIgnoreCase(string) && !reexport) {
                                        string = "private";
                                    } else if ("private".equalsIgnoreCase(string) && reexport) {
                                        string = "reexport";
                                    }
                                    strBuilder.append(String.valueOf(string) + (lastDirectiveValue ? "" : ","));
                                    ++j2;
                                }
                            } else {
                                strBuilder.append(String.valueOf(key) + ":=" + manifestElement.getDirective(key));
                            }
                            if (lastDirective) continue;
                            strBuilder.append(";");
                        }
                    }
                    if (!foundDirective) {
                        strBuilder.append("visibility:=" + (reexport ? "reexport" : "private"));
                    }
                    if (!lastElement) {
                        strBuilder.append(",\n");
                    }
                }
                ++i;
            }
            break block0;
        }
        if (!foundHeader) {
            this.getManifest().getMainAttributes().putValue("Require-Bundle", String.valueOf(plugin) + ";" + "bundle-version" + "=" + version + ";" + "visibility" + ":=" + (reexport ? "reexport" : "private"));
        } else if (overwrite) {
            if (hasValuesForPlugin) {
                this.getManifest().getMainAttributes().putValue("Require-Bundle", strBuilder.toString());
            } else {
                String existingValues = strBuilder.toString();
                boolean areExistingValues = existingValues.trim().length() != 0;
                String newValue = String.valueOf(plugin) + ";" + "bundle-version" + "=" + version + ";" + "visibility" + ":=" + (reexport ? "reexport" : "private");
                newValue = areExistingValues ? String.valueOf(existingValues) + ",\n " + newValue : newValue;
                this.getManifest().getMainAttributes().putValue("Require-Bundle", newValue);
            }
        }
    }
}

