/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.WizardElement;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.WizardListSelectionPage;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.WizardNode;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.BaseProjectWizardFields;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.IBaseProjectWizard;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.IProjectContentWizard;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class TemplateListSelectionPage
extends WizardListSelectionPage
implements ISelectionChangedListener,
IExecutableExtension {
    private BaseProjectWizardFields fContext;
    private Button fUseTemplate;
    private String fInitialTemplateId;

    public TemplateListSelectionPage(ElementList wizardElements, BaseProjectWizardFields context, String message) {
        super(wizardElements, message);
        this.fContext = context;
        this.setTitle(PDEUIMessages.WizardListSelectionPage_title);
        this.setDescription(PDEUIMessages.WizardListSelectionPage_desc);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.new_project_code_gen_page");
    }

    @Override
    public void createAbove(Composite container, int span) {
        this.fUseTemplate = new Button(container, 32);
        this.fUseTemplate.setText(PDEUIMessages.WizardListSelectionPage_label);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        this.fUseTemplate.setLayoutData((Object)gd);
        this.fUseTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateListSelectionPage.this.wizardSelectionViewer.getControl().setEnabled(TemplateListSelectionPage.this.fUseTemplate.getSelection());
                if (!TemplateListSelectionPage.this.fUseTemplate.getSelection()) {
                    TemplateListSelectionPage.this.setDescription("");
                }
                TemplateListSelectionPage.this.setDescriptionEnabled(TemplateListSelectionPage.this.fUseTemplate.getSelection());
                TemplateListSelectionPage.this.getContainer().updateButtons();
            }
        });
    }

    @Override
    protected void initializeViewer() {
        this.wizardSelectionViewer.addFilter((ViewerFilter)new WizardFilter());
        if (this.getInitialTemplateId() != null) {
            this.selectInitialTemplate();
        }
        this.fUseTemplate.setSelection(false);
        this.wizardSelectionViewer.getControl().setEnabled(this.fUseTemplate.getSelection());
        this.setDescriptionEnabled(this.fUseTemplate.getSelection());
    }

    private void selectInitialTemplate() {
        this.selectTemplate(this.getInitialTemplateId());
    }

    public void selectTemplate(String templateID) {
        Object[] children = this.wizardElements.getChildren();
        int i = 0;
        while (i < children.length) {
            WizardElement welement = (WizardElement)((Object)children[i]);
            if (welement.getID().equals(templateID)) {
                this.wizardSelectionViewer.setSelection((ISelection)new StructuredSelection((Object)welement), true);
                this.setSelectedNode(this.createWizardNode(welement));
                this.setDescriptionText(welement.getDescription());
                break;
            }
            ++i;
        }
    }

    @Override
    protected IWizardNode createWizardNode(WizardElement element) {
        return new WizardNode(this, element){

            @Override
            public IBaseProjectWizard createWizard() throws CoreException {
                IProjectContentWizard wizard = (IProjectContentWizard)this.wizardElement.createExecutableExtension();
                wizard.init(TemplateListSelectionPage.this.fContext);
                return wizard;
            }
        };
    }

    @Override
    public IProjectContentWizard getSelectedWizard() {
        if (this.fUseTemplate.getSelection()) {
            return super.getSelectedWizard();
        }
        return null;
    }

    public boolean isPageComplete() {
        return !this.fUseTemplate.getSelection() || this.fUseTemplate.getSelection() && this.getSelectedNode() != null;
    }

    @Override
    public boolean canFlipToNextPage() {
        IStructuredSelection ssel = (IStructuredSelection)this.wizardSelectionViewer.getSelection();
        return this.fUseTemplate.getSelection() && ssel != null && !ssel.isEmpty();
    }

    public String getInitialTemplateId() {
        return this.fInitialTemplateId;
    }

    public void setInitialTemplateId(String initialTemplateId) {
        this.fInitialTemplateId = initialTemplateId;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fUseTemplate.setEnabled(true);
            this.wizardSelectionViewer.refresh();
        }
        super.setVisible(visible);
    }

    public boolean setPageComplete() {
        if (!this.fUseTemplate.getSelection()) {
            return true;
        }
        if (this.wizardSelectionViewer != null) {
            this.wizardSelectionViewer.refresh();
            Object firstElement = this.wizardSelectionViewer.getElementAt(0);
            if (firstElement != null) {
                return true;
            }
        }
        return false;
    }

    public void setUseTemplate(boolean useTemplate) {
        this.fUseTemplate.setSelection(useTemplate);
        this.wizardSelectionViewer.getControl().setEnabled(useTemplate);
        if (!useTemplate) {
            this.setDescription("");
        }
        this.setDescriptionEnabled(useTemplate);
        IWizardContainer container = this.getContainer();
        if (container.getCurrentPage() != null) {
            container.updateButtons();
        }
    }

    class WizardFilter
    extends ViewerFilter {
        WizardFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return true;
        }
    }
}

