/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.ide.ui.xdsml.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.commons.eclipse.core.resources.FileFinderVisitor;
import org.eclipse.gemoc.commons.eclipse.core.resources.NewProjectWorkspaceListener;
import org.eclipse.gemoc.commons.eclipse.ui.WizardFinder;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.NewGemocSiriusProjectWizard;
import org.eclipse.gemoc.xdsmlframework.ide.ui.Activator;
import org.eclipse.gemoc.xdsmlframework.ide.ui.xdsml.wizards.MelangeXDSMLProjectHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class CreateEditorProjectWizardContextAction {
    public CreateEditorProjectAction actionToExecute = CreateEditorProjectAction.CREATE_NEW_EMFTREE_PROJECT;
    protected IProject gemocLanguageIProject = null;
    protected IProject createdProject = null;

    public CreateEditorProjectWizardContextAction(IProject updatedGemocLanguageProject) {
        this.gemocLanguageIProject = updatedGemocLanguageProject;
    }

    public void execute() {
        switch (this.actionToExecute) {
            case CREATE_NEW_EMFTREE_PROJECT: {
                this.createNewEMFTreeProject();
                break;
            }
            case CREATE_NEW_XTEXT_PROJECT: {
                this.createNewXTextProject();
                break;
            }
            case CREATE_NEW_SIRIUS_PROJECT: {
                this.createNewODProject();
                break;
            }
            case SELECT_EXISTING_EMFTREE_PROJECT: {
                break;
            }
            case SELECT_EXISTING_XTEXT_PROJECT: {
                break;
            }
            case SELECT_EXISTING_OD_PROJECT: {
                break;
            }
        }
    }

    protected void createNewEMFTreeProject() {
        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Gemoc Language Workbench UI", (String)"Action not implemented yet");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createNewXTextProject() {
        IWizardDescriptor descriptor = WizardFinder.findNewWizardDescriptor((String)"org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.NewXtextProjectFromEcoreWizard");
        if (descriptor != null) {
            NewProjectWorkspaceListener workspaceListener = new NewProjectWorkspaceListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)workspaceListener);
            try {
                try {
                    IWorkbenchWizard wizard = descriptor.createWizard();
                    WizardDialog wd = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    wd.create();
                    wd.setTitle(wizard.getWindowTitle());
                    int res = wd.open();
                    if (res != 0) return;
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                    ArrayList newlyCreatedProjects = workspaceListener.getNewlyCreatedProjects();
                    FileFinderVisitor fileFinder = new FileFinderVisitor("xtext");
                    for (IProject iProject : newlyCreatedProjects) {
                        iProject.accept((IResourceVisitor)fileFinder);
                        if (fileFinder.getFile() == null) continue;
                        this.createdProject = iProject;
                        break;
                    }
                    if (this.createdProject != null) return;
                    Activator.error("not able to detect which project was created by wizard", null);
                    return;
                }
                catch (CoreException e) {
                    Activator.error(e.getMessage(), e);
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                }
                return;
            }
            finally {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
            }
        } else {
            Activator.error("wizard with id=org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.NewXtextProjectFromEcoreWizard not found", null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createNewODProject() {
        IWizardDescriptor descriptor = WizardFinder.findNewWizardDescriptor((String)"org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.NewGemocSiriusProjectWizard");
        if (descriptor != null) {
            NewProjectWorkspaceListener workspaceListener = new NewProjectWorkspaceListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)workspaceListener);
            try {
                try {
                    IWorkbenchWizard wizard = descriptor.createWizard();
                    ((NewGemocSiriusProjectWizard)wizard).setInitialProjectName(MelangeXDSMLProjectHelper.baseProjectName(this.gemocLanguageIProject));
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    wizard.init(workbench, null);
                    WizardDialog wd = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    wd.create();
                    wd.setTitle(wizard.getWindowTitle());
                    int res = wd.open();
                    if (res != 0) return;
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                    this.createdProject = workspaceListener.getLastCreatedProject();
                    if (this.createdProject != null) return;
                    Activator.error("not able to detect which project was created by wizard", null);
                    return;
                }
                catch (CoreException e) {
                    Activator.error(e.getMessage(), e);
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                }
                return;
            }
            finally {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
            }
        } else {
            Activator.error("wizard with id=org.eclipse.sirius.ui.specificationproject.wizard not found", null);
        }
    }

    public String getSiriusPath() {
        if (this.createdProject != null) {
            FileFinderVisitor odesignProjectVisitor = new FileFinderVisitor("odesign");
            try {
                this.createdProject.accept((IResourceVisitor)odesignProjectVisitor);
                IFile odesignIFile = odesignProjectVisitor.getFile();
                if (odesignIFile != null) {
                    return "/" + this.createdProject.getName() + "/" + odesignIFile.getProjectRelativePath().toString();
                }
            }
            catch (CoreException e) {
                Activator.error(e.getMessage(), e);
            }
        }
        return "";
    }

    public String getXtextPath() {
        if (this.createdProject != null) {
            FileFinderVisitor odesignProjectVisitor = new FileFinderVisitor("xtext");
            try {
                this.createdProject.accept((IResourceVisitor)odesignProjectVisitor);
                IFile odesignIFile = odesignProjectVisitor.getFile();
                if (odesignIFile != null) {
                    return "/" + this.createdProject.getName() + "/" + odesignIFile.getProjectRelativePath().toString();
                }
            }
            catch (CoreException e) {
                Activator.error(e.getMessage(), e);
            }
        }
        return "";
    }

    public static enum CreateEditorProjectAction {
        CREATE_NEW_EMFTREE_PROJECT,
        CREATE_NEW_XTEXT_PROJECT,
        CREATE_NEW_SIRIUS_PROJECT,
        SELECT_EXISTING_EMFTREE_PROJECT,
        SELECT_EXISTING_XTEXT_PROJECT,
        SELECT_EXISTING_OD_PROJECT;

    }
}

