/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;

public class LocalDeclarationAnalyzer
extends ASTVisitor {
    private Selection fSelection;
    private List<VariableDeclaration> fAffectedLocals;

    public static VariableDeclaration[] perform(ASTNode parent, Selection selection) {
        LocalDeclarationAnalyzer analyzer = new LocalDeclarationAnalyzer(selection);
        parent.accept((ASTVisitor)analyzer);
        return analyzer.fAffectedLocals.toArray(new VariableDeclaration[analyzer.fAffectedLocals.size()]);
    }

    private LocalDeclarationAnalyzer(Selection selection) {
        this.fSelection = selection;
        this.fAffectedLocals = new ArrayList<VariableDeclaration>(1);
    }

    public boolean visit(SimpleName node) {
        IVariableBinding binding = null;
        if (node.isDeclaration() || !this.considerNode((ASTNode)node) || (binding = ASTNodes.getLocalVariableBinding((Name)node)) == null) {
            return false;
        }
        this.handleReferenceToLocal(node, binding);
        return true;
    }

    private boolean considerNode(ASTNode node) {
        return this.fSelection.getVisitSelectionMode(node) == 3;
    }

    private void handleReferenceToLocal(SimpleName node, IVariableBinding binding) {
        VariableDeclaration declaration = ASTNodes.findVariableDeclaration((IVariableBinding)binding, (ASTNode)node);
        if (declaration != null && this.fSelection.covers((ASTNode)declaration)) {
            this.addLocalDeclaration(declaration);
        }
    }

    private void addLocalDeclaration(VariableDeclaration declaration) {
        if (!this.fAffectedLocals.contains(declaration)) {
            this.fAffectedLocals.add(declaration);
        }
    }
}

