/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.ExpressionsFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class ExpressionsCleanUp
extends AbstractCleanUp {
    public ExpressionsCleanUp(Map<String, String> options) {
        super(options);
    }

    public ExpressionsCleanUp() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    private boolean requireAST() {
        boolean usePrentheses = this.isEnabled("cleanup.use_parentheses_in_expressions");
        if (!usePrentheses) {
            return false;
        }
        return this.isEnabled("cleanup.always_use_parentheses_in_expressions") || this.isEnabled("cleanup.never_use_parentheses_in_expressions");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        boolean usePrentheses = this.isEnabled("cleanup.use_parentheses_in_expressions");
        if (!usePrentheses) {
            return null;
        }
        return ExpressionsFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.always_use_parentheses_in_expressions"), this.isEnabled("cleanup.never_use_parentheses_in_expressions"));
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.always_use_parentheses_in_expressions")) {
            result.add(MultiFixMessages.ExpressionsCleanUp_addParanoiac_description);
        }
        if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.never_use_parentheses_in_expressions")) {
            result.add(MultiFixMessages.ExpressionsCleanUp_removeUnnecessary_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.always_use_parentheses_in_expressions")) {
            buf.append("boolean b= (((i > 0) && (i < 10)) || (i == 50));\n");
        } else if (this.isEnabled("cleanup.use_parentheses_in_expressions") && this.isEnabled("cleanup.never_use_parentheses_in_expressions")) {
            buf.append("boolean b= i > 0 && i < 10 || i == 50;\n");
        } else {
            buf.append("boolean b= (i > 0 && i < 10 || i == 50);\n");
        }
        return buf.toString();
    }
}

