/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.binary;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.binary.AbstractCodeCreationOperation;
import org.eclipse.jdt.internal.corext.refactoring.binary.SourceCreationOperation;
import org.eclipse.jdt.internal.corext.refactoring.binary.StubCreationOperation;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarimport.JarImportMessages;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContext;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryWizard;

public abstract class BinaryRefactoringHistoryWizard
extends RefactoringHistoryWizard {
    private static final String META_INF_FRAGMENT = "META-INF/MANIFEST.MF".substring(0, "META-INF/MANIFEST.MF".indexOf(47));
    private static final String SOURCE_FOLDER = ".src";
    private static final String STUB_FOLDER = ".stubs";
    private boolean fAutoBuild = true;
    protected boolean fCancelled = false;
    protected IJavaProject fJavaProject = null;
    private final Collection<IJavaElement> fProcessedFragments = new HashSet<IJavaElement>();
    private IFolder fSourceFolder = null;

    private static void addExclusionPatterns(List<IClasspathEntry> entries, IPath path) {
        int index = 0;
        while (index < entries.size()) {
            IPath[] patterns;
            IClasspathEntry entry = entries.get(index);
            if (entry.getEntryKind() == 3 && entry.getPath().isPrefixOf(path) && !JavaModelUtil.isExcludedPath((IPath)path, (IPath[])(patterns = entry.getExclusionPatterns()))) {
                IPath[] filters = new IPath[patterns.length + 1];
                System.arraycopy(patterns, 0, filters, 0, patterns.length);
                filters[patterns.length] = path.removeFirstSegments(entry.getPath().segmentCount()).addTrailingSeparator();
                entries.set(index, JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])filters, (IPath)entry.getOutputLocation()));
            }
            ++index;
        }
    }

    private static RefactoringStatus checkPackageFragmentRoots(IPackageFragmentRoot root, IProgressMonitor monitor) {
        RefactoringStatus status;
        block14: {
            status = new RefactoringStatus();
            try {
                IJavaModel model;
                monitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, 100);
                IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
                if (workspace == null || (model = JavaCore.create((IWorkspaceRoot)workspace)) == null) break block14;
                try {
                    URI uri = BinaryRefactoringHistoryWizard.getLocationURI(root.getRawClasspathEntry());
                    if (uri == null) break block14;
                    IJavaProject[] projects = model.getJavaProjects();
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100, 2);
                    try {
                        subMonitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, projects.length * 100);
                        int index = 0;
                        while (index < projects.length) {
                            IPackageFragmentRoot[] roots = projects[index].getPackageFragmentRoots();
                            SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 100, 2);
                            try {
                                subsubMonitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, roots.length);
                                int offset = 0;
                                while (offset < roots.length) {
                                    URI location;
                                    IClasspathEntry entry;
                                    IPackageFragmentRoot current = roots[offset];
                                    if (!current.equals(root) && current.getKind() == 2 && (entry = current.getRawClasspathEntry()).getEntryKind() == 1 && uri.equals(location = BinaryRefactoringHistoryWizard.getLocationURI(entry))) {
                                        status.addFatalError(Messages.format(JarImportMessages.JarImportWizard_error_shared_jar, new String[]{JavaElementLabels.getElementLabel((IJavaElement)current.getJavaProject(), JavaElementLabels.ALL_DEFAULT)}));
                                    }
                                    subsubMonitor.worked(1);
                                    ++offset;
                                }
                            }
                            finally {
                                subsubMonitor.done();
                            }
                            ++index;
                        }
                    }
                    finally {
                        subMonitor.done();
                    }
                }
                catch (CoreException exception) {
                    status.addError(exception.getLocalizedMessage());
                }
            }
            finally {
                monitor.done();
            }
        }
        return status;
    }

    private static void configureClasspath(IJavaProject project, IPackageFragmentRoot root, IFolder folder, IProgressMonitor monitor) throws IllegalStateException, CoreException {
        try {
            monitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, 200);
            IClasspathEntry entry = root.getRawClasspathEntry();
            IClasspathEntry[] entries = project.getRawClasspath();
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            list.addAll(Arrays.asList(entries));
            IFileStore store = EFS.getLocalFileSystem().getStore(JavaPlugin.getDefault().getStateLocation().append(STUB_FOLDER).append(project.getElementName()));
            if (store.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 25, 2)).exists()) {
                store.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 25, 2));
            }
            store.mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 25, 2));
            folder.createLink(store.toURI(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 25, 2));
            BinaryRefactoringHistoryWizard.addExclusionPatterns(list, folder.getFullPath());
            int index = 0;
            while (index < entries.length) {
                if (entries[index].equals(entry)) {
                    list.add(index, JavaCore.newSourceEntry((IPath)folder.getFullPath()));
                }
                ++index;
            }
            project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), false, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
        }
        finally {
            monitor.done();
        }
    }

    public static URI getLocationURI(IClasspathEntry entry) {
        IPath path = null;
        path = entry.getEntryKind() == 4 ? JavaCore.getResolvedVariablePath((IPath)entry.getPath()) : entry.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        URI location = null;
        location = root.exists(path) ? root.getFile(path).getRawLocationURI() : URIUtil.toURI((IPath)path);
        return location;
    }

    protected BinaryRefactoringHistoryWizard(boolean overview, String caption, String title, String description) {
        super(overview, caption, title, description);
    }

    protected BinaryRefactoringHistoryWizard(String caption, String title, String description) {
        super(caption, title, description);
    }

    protected RefactoringStatus aboutToPerformHistory(IProgressMonitor monitor) {
        RefactoringStatus status;
        block13: {
            status = new RefactoringStatus();
            try {
                IJavaProject project;
                IPackageFragmentRoot root;
                this.fJavaProject = null;
                this.fSourceFolder = null;
                this.fProcessedFragments.clear();
                monitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, 520);
                status.merge(super.aboutToPerformHistory((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2)));
                if (status.hasFatalError() || (root = this.getPackageFragmentRoot()) == null) break block13;
                status.merge(BinaryRefactoringHistoryWizard.checkPackageFragmentRoots(root, (IProgressMonitor)new SubProgressMonitor(monitor, 90, 2)));
                if (status.hasFatalError()) break block13;
                status.merge(this.checkSourceAttachmentRefactorings((IProgressMonitor)new SubProgressMonitor(monitor, 20, 2)));
                if (status.hasFatalError() || (project = root.getJavaProject()) == null) break block13;
                IFolder folder = project.getProject().getFolder(SOURCE_FOLDER + String.valueOf(System.currentTimeMillis()));
                try {
                    try {
                        this.fAutoBuild = CoreUtility.setAutoBuilding(false);
                        RefactoringHistory history = this.getRefactoringHistory();
                        if (history != null && !history.isEmpty()) {
                            BinaryRefactoringHistoryWizard.configureClasspath(project, root, folder, (IProgressMonitor)new SubProgressMonitor(monitor, 300, 2));
                        }
                    }
                    catch (CoreException exception) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)exception.getLocalizedMessage()));
                        try {
                            project.setRawClasspath(project.readRawClasspath(), false, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                        }
                        catch (CoreException throwable) {
                            JavaPlugin.log(throwable);
                        }
                        if (!status.hasFatalError()) {
                            this.fJavaProject = project;
                            this.fSourceFolder = folder;
                        }
                    }
                }
                finally {
                    if (!status.hasFatalError()) {
                        this.fJavaProject = project;
                        this.fSourceFolder = folder;
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
        return status;
    }

    protected RefactoringStatus aboutToPerformRefactoring(Refactoring refactoring, RefactoringDescriptor descriptor, IProgressMonitor monitor) {
        RefactoringStatus status = new RefactoringStatus();
        monitor.done();
        return status;
    }

    protected boolean canUseSourceAttachment() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            try {
                return root.getSourceAttachmentPath() != null;
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
        return false;
    }

    protected RefactoringStatus checkSourceAttachmentRefactorings(IProgressMonitor monitor) {
        RefactoringStatus status = new RefactoringStatus();
        try {
            if (!this.canUseSourceAttachment()) {
                RefactoringDescriptorProxy[] proxies = this.getRefactoringHistory().getDescriptors();
                monitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, proxies.length * 100);
                int index = 0;
                while (index < proxies.length) {
                    int flags;
                    RefactoringDescriptor descriptor = proxies[index].requestDescriptor((IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                    if (descriptor != null && ((flags = descriptor.getFlags()) & 0x40000) != 0) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(JarImportMessages.BinaryRefactoringHistoryWizard_error_missing_source_attachment, descriptor.getDescription())));
                    }
                    ++index;
                }
            } else {
                monitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, 1);
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private RefactoringStatus createNecessarySourceCode(IProgressMonitor monitor) {
        RefactoringStatus status;
        block13: {
            status = new RefactoringStatus();
            try {
                monitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, 240);
                IPackageFragmentRoot root = this.getPackageFragmentRoot();
                if (root == null || this.fSourceFolder == null || this.fJavaProject == null) break block13;
                try {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 40, 2);
                    IJavaElement[] elements = root.getChildren();
                    ArrayList<IPackageFragment> list = new ArrayList<IPackageFragment>(elements.length);
                    try {
                        subMonitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, elements.length);
                        int index = 0;
                        while (index < elements.length) {
                            IJavaElement element = elements[index];
                            if (!this.fProcessedFragments.contains(element) && !element.getElementName().equals(META_INF_FRAGMENT)) {
                                list.add((IPackageFragment)element);
                            }
                            subMonitor.worked(1);
                            ++index;
                        }
                    }
                    finally {
                        subMonitor.done();
                    }
                    if (list.isEmpty()) break block13;
                    this.fProcessedFragments.addAll(list);
                    URI uri = this.fSourceFolder.getRawLocationURI();
                    if (uri == null) break block13;
                    final IPackageFragmentRoot sourceFolder = this.fJavaProject.getPackageFragmentRoot((IResource)this.fSourceFolder);
                    AbstractCodeCreationOperation runnable = null;
                    runnable = this.canUseSourceAttachment() ? new SourceCreationOperation(uri, list){
                        private IPackageFragment fFragment;
                        {
                            super($anonymous0, $anonymous1);
                            this.fFragment = null;
                        }

                        @Override
                        protected final void createCompilationUnit(IFileStore store, String name, String content, IProgressMonitor pm) throws CoreException {
                            this.fFragment.createCompilationUnit(name, content, true, pm);
                        }

                        @Override
                        protected final void createPackageFragment(IFileStore store, String name, IProgressMonitor pm) throws CoreException {
                            this.fFragment = sourceFolder.createPackageFragment(name, true, pm);
                        }
                    } : new StubCreationOperation(uri, list, true){
                        private IPackageFragment fFragment;
                        {
                            super($anonymous0, $anonymous1, $anonymous2);
                            this.fFragment = null;
                        }

                        @Override
                        protected final void createCompilationUnit(IFileStore store, String name, String content, IProgressMonitor pm) throws CoreException {
                            this.fFragment.createCompilationUnit(name, content, true, pm);
                        }

                        @Override
                        protected final void createPackageFragment(IFileStore store, String name, IProgressMonitor pm) throws CoreException {
                            this.fFragment = sourceFolder.createPackageFragment(name, true, pm);
                        }
                    };
                    try {
                        runnable.run((IProgressMonitor)new SubProgressMonitor(monitor, 150, 2));
                    }
                    finally {
                        this.fSourceFolder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                    }
                }
                catch (CoreException exception) {
                    status.addFatalError(exception.getLocalizedMessage());
                }
            }
            finally {
                monitor.done();
            }
        }
        return status;
    }

    protected RefactoringContext createRefactoringContext(RefactoringDescriptor descriptor, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)descriptor);
        this.createNecessarySourceCode(monitor);
        if (descriptor instanceof JavaRefactoringDescriptor) {
            JavaRefactoringDescriptor javaDescriptor = (JavaRefactoringDescriptor)descriptor;
            RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)javaDescriptor.getID());
            Map map = contribution.retrieveArgumentMap(descriptor);
            if (this.fJavaProject == null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments));
                return null;
            }
            String name = this.fJavaProject.getElementName();
            String handle = (String)map.get("input");
            if (handle != null && handle.length() > 0) {
                map.put("input", this.getTransformedHandle(name, handle));
            }
            int count = 1;
            String attribute = "element" + count;
            while ((handle = (String)map.get(attribute)) != null) {
                if (handle.length() > 0) {
                    map.put(attribute, this.getTransformedHandle(name, handle));
                }
                attribute = "element" + ++count;
            }
            try {
                descriptor = contribution.createDescriptor(descriptor.getID(), name, descriptor.getDescription(), descriptor.getComment(), map, descriptor.getFlags());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments));
                return null;
            }
        }
        return descriptor.createRefactoringContext(status);
    }

    protected boolean deconfigureClasspath(IClasspathEntry[] entries, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    private void deconfigureClasspath(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(JarImportMessages.JarImportWizard_cleanup_import, 300);
            if (this.fJavaProject != null) {
                boolean valid;
                IClasspathEntry[] entries = this.fJavaProject.readRawClasspath();
                boolean changed = this.deconfigureClasspath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                RefactoringHistory history = this.getRefactoringHistory();
                boolean bl = valid = history != null && !history.isEmpty();
                if (valid) {
                    RefactoringCore.getUndoManager().flush();
                }
                if (valid || changed) {
                    this.fJavaProject.setRawClasspath(entries, changed, (IProgressMonitor)new SubProgressMonitor(monitor, 60, 2));
                }
            }
            if (this.fSourceFolder != null) {
                IFileStore store = EFS.getStore((URI)this.fSourceFolder.getRawLocationURI());
                if (store.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2)).exists()) {
                    store.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                }
                this.fSourceFolder.delete(true, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                this.fSourceFolder.clearHistory((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                this.fSourceFolder = null;
            }
            if (this.fJavaProject != null) {
                try {
                    this.fJavaProject.getResource().refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                }
                catch (CoreException exception) {
                    JavaPlugin.log(exception);
                }
            }
        }
        finally {
            this.fJavaProject = null;
            monitor.done();
        }
    }

    protected abstract IPackageFragmentRoot getPackageFragmentRoot();

    protected abstract RefactoringHistory getRefactoringHistory();

    private String getTransformedHandle(String project, String handle) {
        IJavaElement target;
        if (this.fSourceFolder != null && (target = JavaCore.create((IFolder)this.fSourceFolder)) instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot extended = (IPackageFragmentRoot)target;
            String sourceIdentifier = null;
            IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(project, handle, false);
            if (element != null) {
                IJavaElement result;
                IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
                if (root != null) {
                    sourceIdentifier = root.getHandleIdentifier();
                } else {
                    IJavaProject javaProject = element.getJavaProject();
                    if (javaProject != null) {
                        sourceIdentifier = javaProject.getHandleIdentifier();
                    }
                }
                if (sourceIdentifier != null && (result = JavaCore.create((String)(String.valueOf(extended.getHandleIdentifier()) + element.getHandleIdentifier().substring(sourceIdentifier.length())))) != null) {
                    return JavaRefactoringDescriptorUtil.elementToHandle(project, result);
                }
            }
        }
        return handle;
    }

    protected RefactoringStatus historyPerformed(IProgressMonitor monitor) {
        try {
            RefactoringStatus status;
            block15: {
                monitor.beginTask(JarImportMessages.JarImportWizard_cleanup_import, 100);
                status = super.historyPerformed((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                if (!status.hasFatalError()) {
                    try {
                        try {
                            this.deconfigureClasspath((IProgressMonitor)new SubProgressMonitor(monitor, 90, 2));
                        }
                        catch (CoreException exception) {
                            status.addError(exception.getLocalizedMessage());
                            try {
                                CoreUtility.setAutoBuilding(this.fAutoBuild);
                            }
                            catch (CoreException exception2) {
                                JavaPlugin.log(exception2);
                            }
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            CoreUtility.setAutoBuilding(this.fAutoBuild);
                        }
                        catch (CoreException exception) {
                            JavaPlugin.log(exception);
                        }
                        throw throwable;
                    }
                    try {
                        CoreUtility.setAutoBuilding(this.fAutoBuild);
                    }
                    catch (CoreException exception) {
                        JavaPlugin.log(exception);
                    }
                }
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    public boolean performCancel() {
        this.fCancelled = true;
        return super.performCancel();
    }

    protected RefactoringStatus refactoringPerformed(Refactoring refactoring, IProgressMonitor monitor) {
        try {
            monitor.beginTask("", 120);
            RefactoringStatus status = super.refactoringPerformed(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
            if (!status.hasFatalError() && this.fSourceFolder != null) {
                try {
                    this.fSourceFolder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                }
                catch (CoreException exception) {
                    JavaPlugin.log(exception);
                }
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected boolean selectPreviewChange(Change change) {
        if (this.fSourceFolder != null) {
            IAdaptable adaptable;
            IResource resource;
            IPath source = this.fSourceFolder.getFullPath();
            Object element = change.getModifiedElement();
            if (element instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) != null && source.isPrefixOf(resource.getFullPath())) {
                return false;
            }
        }
        return super.selectPreviewChange(change);
    }

    protected boolean selectStatusEntry(RefactoringStatusEntry entry) {
        if (this.fSourceFolder != null) {
            IResource resource;
            JavaStatusContext extended;
            ICompilationUnit unit;
            IPath source = this.fSourceFolder.getFullPath();
            RefactoringStatusContext context = entry.getContext();
            if (context instanceof JavaStatusContext && (unit = (extended = (JavaStatusContext)context).getCompilationUnit()) != null && (resource = unit.getResource()) != null && source.isPrefixOf(resource.getFullPath())) {
                return false;
            }
        }
        return super.selectStatusEntry(entry);
    }
}

