/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;

public class MarkerResolutionProposal
implements IJavaCompletionProposal {
    private IMarkerResolution fResolution;
    private IMarker fMarker;

    public MarkerResolutionProposal(IMarkerResolution resolution, IMarker marker) {
        this.fResolution = resolution;
        this.fMarker = marker;
    }

    public void apply(IDocument document) {
        this.fResolution.run(this.fMarker);
    }

    public String getAdditionalProposalInfo() {
        if (this.fResolution instanceof IMarkerResolution2) {
            return ((IMarkerResolution2)this.fResolution).getDescription();
        }
        if (this.fResolution instanceof IJavaCompletionProposal) {
            return ((IJavaCompletionProposal)this.fResolution).getAdditionalProposalInfo();
        }
        try {
            String problemDesc = (String)this.fMarker.getAttribute("message");
            return Messages.format(CorrectionMessages.MarkerResolutionProposal_additionaldesc, problemDesc);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.fResolution.getLabel();
    }

    public Image getImage() {
        if (this.fResolution instanceof IMarkerResolution2) {
            return ((IMarkerResolution2)this.fResolution).getImage();
        }
        if (this.fResolution instanceof IJavaCompletionProposal) {
            return ((IJavaCompletionProposal)this.fResolution).getImage();
        }
        return JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
    }

    @Override
    public int getRelevance() {
        if (this.fResolution instanceof IJavaCompletionProposal) {
            return ((IJavaCompletionProposal)this.fResolution).getRelevance();
        }
        return 10;
    }

    public Point getSelection(IDocument document) {
        if (this.fResolution instanceof IJavaCompletionProposal) {
            return ((IJavaCompletionProposal)this.fResolution).getSelection(document);
        }
        return null;
    }
}

