/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;

public class BestMatchHover
extends AbstractJavaEditorTextHover {
    private List<JavaEditorTextHoverDescriptor> fTextHoverSpecifications;
    private List<IJavaEditorTextHover> fInstantiatedTextHovers;
    private ITextHover fBestHover;

    public BestMatchHover() {
        this.installTextHovers();
    }

    public BestMatchHover(IEditorPart editor) {
        this();
        this.setEditor(editor);
    }

    private void installTextHovers() {
        this.fTextHoverSpecifications = new ArrayList<JavaEditorTextHoverDescriptor>(2);
        this.fInstantiatedTextHovers = new ArrayList<IJavaEditorTextHover>(2);
        JavaEditorTextHoverDescriptor[] hoverDescs = JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (!"org.eclipse.jdt.ui.BestMatchHover".equals(hoverDescs[i].getId())) {
                this.fTextHoverSpecifications.add(hoverDescs[i]);
            }
            ++i;
        }
    }

    private void checkTextHovers() {
        if (this.fTextHoverSpecifications == null) {
            return;
        }
        boolean done = true;
        int i = -1;
        Iterator<JavaEditorTextHoverDescriptor> iterator = this.fTextHoverSpecifications.iterator();
        while (iterator.hasNext()) {
            ++i;
            JavaEditorTextHoverDescriptor spec = iterator.next();
            if (spec == null) continue;
            done = false;
            IJavaEditorTextHover hover = spec.createTextHover();
            if (hover != null) {
                hover.setEditor(this.getEditor());
                this.fTextHoverSpecifications.set(i, null);
            }
            if (i == this.fInstantiatedTextHovers.size()) {
                this.fInstantiatedTextHovers.add(i, hover);
                continue;
            }
            this.fInstantiatedTextHovers.set(i, hover);
        }
        if (done) {
            this.fTextHoverSpecifications = null;
        }
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        for (ITextHover iTextHover : this.fInstantiatedTextHovers) {
            String s;
            if (iTextHover == null || (s = iTextHover.getHoverInfo(textViewer, hoverRegion)) == null || s.trim().length() <= 0) continue;
            this.fBestHover = iTextHover;
            return s;
        }
        return null;
    }

    @Override
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.getHoverInfo2(textViewer, hoverRegion, false);
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion, boolean forInformationProvider) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        for (ITextHover iTextHover : this.fInstantiatedTextHovers) {
            if (iTextHover == null) continue;
            if (iTextHover instanceof ITextHoverExtension2) {
                Object info = ((ITextHoverExtension2)iTextHover).getHoverInfo2(textViewer, hoverRegion);
                if (info == null || forInformationProvider && BestMatchHover.getInformationPresenterControlCreator(iTextHover) == null) continue;
                this.fBestHover = iTextHover;
                return info;
            }
            String s = iTextHover.getHoverInfo(textViewer, hoverRegion);
            if (s == null || s.trim().length() <= 0) continue;
            this.fBestHover = iTextHover;
            return s;
        }
        return null;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.fBestHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fBestHover).getHoverControlCreator();
        }
        return null;
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        return BestMatchHover.getInformationPresenterControlCreator(this.fBestHover);
    }

    private static IInformationControlCreator getInformationPresenterControlCreator(ITextHover hover) {
        if (hover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)hover).getInformationPresenterControlCreator();
        }
        if (hover instanceof AbstractJavaEditorTextHover) {
            return ((AbstractJavaEditorTextHover)hover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

