/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TypeNameMatchLabelProvider
extends LabelProvider {
    public static final int SHOW_FULLYQUALIFIED = 1;
    public static final int SHOW_PACKAGE_POSTFIX = 2;
    public static final int SHOW_PACKAGE_ONLY = 4;
    public static final int SHOW_ROOT_POSTFIX = 8;
    public static final int SHOW_TYPE_ONLY = 16;
    public static final int SHOW_TYPE_CONTAINER_ONLY = 32;
    public static final int SHOW_POST_QUALIFIED = 64;
    private int fFlags;

    public TypeNameMatchLabelProvider(int flags) {
        this.fFlags = flags;
    }

    public String getText(Object element) {
        if (!(element instanceof TypeNameMatch)) {
            return super.getText(element);
        }
        return TypeNameMatchLabelProvider.getText((TypeNameMatch)element, this.fFlags);
    }

    public Image getImage(Object element) {
        if (!(element instanceof TypeNameMatch)) {
            return super.getImage(element);
        }
        return TypeNameMatchLabelProvider.getImage((TypeNameMatch)element, this.fFlags);
    }

    private static boolean isSet(int flag, int flags) {
        return (flags & flag) != 0;
    }

    private static String getPackageName(String packName) {
        if (packName.length() == 0) {
            return JavaUIMessages.TypeInfoLabelProvider_default_package;
        }
        return packName;
    }

    public static String getText(TypeNameMatch typeRef, int flags) {
        String packName;
        String containerName;
        StringBuffer buf = new StringBuffer();
        if (TypeNameMatchLabelProvider.isSet(16, flags)) {
            buf.append(typeRef.getSimpleTypeName());
        } else if (TypeNameMatchLabelProvider.isSet(32, flags)) {
            containerName = typeRef.getTypeContainerName();
            buf.append(TypeNameMatchLabelProvider.getPackageName(containerName));
        } else if (TypeNameMatchLabelProvider.isSet(4, flags)) {
            packName = typeRef.getPackageName();
            buf.append(TypeNameMatchLabelProvider.getPackageName(packName));
        } else {
            if (TypeNameMatchLabelProvider.isSet(1, flags)) {
                buf.append(typeRef.getFullyQualifiedName());
            } else if (TypeNameMatchLabelProvider.isSet(64, flags)) {
                buf.append(typeRef.getSimpleTypeName());
                containerName = typeRef.getTypeContainerName();
                if (containerName != null && containerName.length() > 0) {
                    buf.append(JavaElementLabels.CONCAT_STRING);
                    buf.append(containerName);
                }
            } else {
                buf.append(typeRef.getTypeQualifiedName());
            }
            if (TypeNameMatchLabelProvider.isSet(2, flags)) {
                buf.append(JavaElementLabels.CONCAT_STRING);
                packName = typeRef.getPackageName();
                buf.append(TypeNameMatchLabelProvider.getPackageName(packName));
            }
        }
        if (TypeNameMatchLabelProvider.isSet(8, flags)) {
            buf.append(JavaElementLabels.CONCAT_STRING);
            IPackageFragmentRoot root = typeRef.getPackageFragmentRoot();
            JavaElementLabels.getPackageFragmentRootLabel(root, 0x20000000000L, buf);
        }
        return BasicElementLabels.getJavaElementName((String)buf.toString());
    }

    public static ImageDescriptor getImageDescriptor(TypeNameMatch typeRef, int flags) {
        if (TypeNameMatchLabelProvider.isSet(32, flags)) {
            if (typeRef.getPackageName().equals(typeRef.getTypeContainerName())) {
                return JavaPluginImages.DESC_OBJS_PACKAGE;
            }
            return JavaPluginImages.DESC_OBJS_CLASS;
        }
        if (TypeNameMatchLabelProvider.isSet(4, flags)) {
            return JavaPluginImages.DESC_OBJS_PACKAGE;
        }
        boolean isInner = typeRef.getTypeContainerName().indexOf(46) != -1;
        int modifiers = typeRef.getModifiers();
        ImageDescriptor desc = JavaElementImageProvider.getTypeImageDescriptor(isInner, false, modifiers, false);
        int adornmentFlags = 0;
        if (Flags.isFinal((int)modifiers)) {
            adornmentFlags |= 2;
        }
        if (Flags.isAbstract((int)modifiers) && !Flags.isInterface((int)modifiers)) {
            adornmentFlags |= 1;
        }
        if (Flags.isStatic((int)modifiers)) {
            adornmentFlags |= 8;
        }
        if (Flags.isDeprecated((int)modifiers)) {
            adornmentFlags |= 0x400;
        }
        return new JavaElementImageDescriptor(desc, adornmentFlags, JavaElementImageProvider.BIG_SIZE);
    }

    public static Image getImage(TypeNameMatch typeRef, int flags) {
        return JavaPlugin.getImageDescriptorRegistry().get(TypeNameMatchLabelProvider.getImageDescriptor(typeRef, flags));
    }
}

