/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.IWorkingCopyProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class StandardJavaElementContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers;
    protected boolean fProvideWorkingCopy;

    public StandardJavaElementContentProvider() {
        this(false);
    }

    @Deprecated
    public StandardJavaElementContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        this(provideMembers);
    }

    public StandardJavaElementContentProvider(boolean provideMembers) {
        this.fProvideMembers = provideMembers;
        this.fProvideWorkingCopy = provideMembers;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean b) {
        this.fProvideMembers = b;
    }

    @Deprecated
    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    @Deprecated
    public void setProvideWorkingCopy(boolean b) {
        this.fProvideWorkingCopy = b;
    }

    @Override
    public boolean providesWorkingCopies() {
        return this.getProvideWorkingCopy();
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            if (element instanceof IJavaModel) {
                return this.getJavaProjects((IJavaModel)element);
            }
            if (element instanceof IJavaProject) {
                return this.getPackageFragmentRoots((IJavaProject)element);
            }
            if (element instanceof IPackageFragmentRoot) {
                return this.getPackageFragmentRootContent((IPackageFragmentRoot)element);
            }
            if (element instanceof IPackageFragment) {
                return this.getPackageContent((IPackageFragment)element);
            }
            if (element instanceof IFolder) {
                return this.getFolderContent((IFolder)element);
            }
            if (element instanceof IJarEntryResource) {
                return ((IJarEntryResource)element).getChildren();
            }
            if (this.getProvideMembers() && element instanceof ISourceReference && element instanceof IParent) {
                return ((IParent)element).getChildren();
            }
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren(Object element) {
        Object[] children;
        IJavaProject jp;
        if (this.getProvideMembers()) {
            if (element instanceof ICompilationUnit || element instanceof IClassFile) {
                return true;
            }
        } else if (element instanceof ICompilationUnit || element instanceof IClassFile || element instanceof IFile) {
            return false;
        }
        if (element instanceof IJavaProject && !(jp = (IJavaProject)element).getProject().isOpen()) {
            return false;
        }
        if (element instanceof IParent) {
            try {
                if (((IParent)element).hasChildren()) {
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {
                return true;
            }
        }
        return (children = this.getChildren(element)) != null && children.length > 0;
    }

    public Object getParent(Object element) {
        if (!this.exists(element)) {
            return null;
        }
        return this.internalGetParent(element);
    }

    protected Object[] getPackageFragmentRootContent(IPackageFragmentRoot root) throws JavaModelException {
        ITypeRoot moduleRoot;
        Object[] fragments = root.getChildren();
        if (JavaModelUtil.is9OrHigher((IJavaProject)root.getJavaProject()) && (moduleRoot = this.getModuleRoot(root)) != null) {
            IJavaElement defaultPackage = moduleRoot.getParent();
            if (!JavaModelUtil.containsOrdinaryCompilationUnit((IPackageFragment)((IPackageFragment)defaultPackage))) {
                int i = 0;
                while (i < fragments.length) {
                    if (fragments[i].equals(defaultPackage)) {
                        fragments = (IJavaElement[])Arrays.copyOf(fragments, fragments.length);
                        fragments[i] = moduleRoot;
                        break;
                    }
                    ++i;
                }
            } else {
                int length = fragments.length;
                fragments = (IJavaElement[])Arrays.copyOf(fragments, length + 1);
                fragments[length] = moduleRoot;
            }
        }
        if (this.isProjectPackageFragmentRoot(root)) {
            return fragments;
        }
        Object[] nonJavaResources = root.getNonJavaResources();
        if (nonJavaResources == null) {
            return fragments;
        }
        return StandardJavaElementContentProvider.concatenate(fragments, nonJavaResources);
    }

    ITypeRoot getModuleRoot(IPackageFragmentRoot root) throws JavaModelException {
        IModuleDescription module = root.getModuleDescription();
        if (module == null) {
            IPackageFragment dfltPack = root.getPackageFragment("");
            if (dfltPack.exists()) {
                IJavaElement[] iJavaElementArray = dfltPack.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    if (child instanceof ITypeRoot && JavaModelUtil.isModuleInfo((ITypeRoot)((ITypeRoot)child)) && ((ITypeRoot)child).getChildren().length == 0) {
                        return (ITypeRoot)child;
                    }
                    ++n2;
                }
            }
            return null;
        }
        return (ITypeRoot)module.getParent();
    }

    protected Object[] getPackageFragmentRoots(IJavaProject project) throws JavaModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        ArrayList<Object> list = new ArrayList<Object>(roots.length);
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (this.isProjectPackageFragmentRoot(root)) {
                Object[] fragments = this.getPackageFragmentRootContent(root);
                int j = 0;
                while (j < fragments.length) {
                    list.add(fragments[j]);
                    ++j;
                }
            } else {
                list.add(root);
            }
            ++i;
        }
        Object[] resources = project.getNonJavaResources();
        int i2 = 0;
        while (i2 < resources.length) {
            list.add(resources[i2]);
            ++i2;
        }
        return list.toArray();
    }

    protected Object[] getJavaProjects(IJavaModel jm) throws JavaModelException {
        return jm.getJavaProjects();
    }

    protected Object[] getPackageContent(IPackageFragment fragment) throws JavaModelException {
        if (fragment.getKind() == 1) {
            Object[] compilationUnits = this.filterModuleInfo(fragment, (ITypeRoot[])fragment.getCompilationUnits());
            return StandardJavaElementContentProvider.concatenate(compilationUnits, fragment.getNonJavaResources());
        }
        Object[] classFiles = fragment.getOrdinaryClassFiles();
        return StandardJavaElementContentProvider.concatenate(classFiles, fragment.getNonJavaResources());
    }

    private ITypeRoot[] filterModuleInfo(IPackageFragment fragment, ITypeRoot[] units) {
        if (fragment.isDefaultPackage() && JavaModelUtil.is9OrHigher((IJavaProject)fragment.getJavaProject())) {
            int count = 0;
            ITypeRoot[] newUnits = new ITypeRoot[units.length];
            int i = 0;
            while (i < units.length) {
                if (!JavaModelUtil.isModuleInfo((ITypeRoot)units[i])) {
                    newUnits[count++] = units[i];
                }
                ++i;
            }
            if (count < units.length) {
                return Arrays.copyOf(newUnits, count);
            }
        }
        return units;
    }

    protected Object[] getFolderContent(IFolder folder) throws CoreException {
        Object[] members = folder.members();
        IJavaProject javaProject = JavaCore.create((IProject)folder.getProject());
        if (javaProject == null || !javaProject.exists()) {
            return members;
        }
        boolean isFolderOnClasspath = javaProject.isOnClasspath((IResource)folder);
        ArrayList<Object> nonJavaResources = new ArrayList<Object>();
        int i = 0;
        while (i < members.length) {
            Object member = members[i];
            if (isFolderOnClasspath) {
                if (javaProject.findPackageFragmentRoot(member.getFullPath()) == null) {
                    nonJavaResources.add(member);
                }
            } else if (!javaProject.isOnClasspath((IResource)member)) {
                nonJavaResources.add(member);
            } else {
                IJavaElement element = JavaCore.create((IResource)member, (IJavaProject)javaProject);
                if (element instanceof IPackageFragmentRoot && javaProject.equals(element.getJavaProject()) && ((IPackageFragmentRoot)element).getKind() != 1) {
                    nonJavaResources.add(member);
                }
            }
            ++i;
        }
        return nonJavaResources.toArray();
    }

    protected boolean isClassPathChange(IJavaElementDelta delta) {
        if (delta.getElement().getElementType() != 3) {
            return false;
        }
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    protected Object skipProjectPackageFragmentRoot(IPackageFragmentRoot root) {
        if (this.isProjectPackageFragmentRoot(root)) {
            return root.getParent();
        }
        return root;
    }

    protected boolean isPackageFragmentEmpty(IJavaElement element) throws JavaModelException {
        IPackageFragment fragment;
        return element instanceof IPackageFragment && (fragment = (IPackageFragment)element).exists() && !fragment.hasChildren() && fragment.getNonJavaResources().length <= 0 && fragment.hasSubpackages();
    }

    protected boolean isProjectPackageFragmentRoot(IPackageFragmentRoot root) {
        IJavaProject javaProject = root.getJavaProject();
        return javaProject != null && javaProject.getPath().equals((Object)root.getPath());
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).exists();
        }
        return true;
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IJavaElement jParent = JavaCore.create((IResource)parent);
            if (jParent != null && jParent.exists()) {
                return jParent;
            }
            return parent;
        }
        if (element instanceof IJavaElement) {
            IJavaElement parent = ((IJavaElement)element).getParent();
            if (element instanceof IPackageFragment) {
                return this.skipProjectPackageFragmentRoot((IPackageFragmentRoot)parent);
            }
            if (element instanceof ITypeRoot && JavaModelUtil.isModuleInfo((ITypeRoot)((ITypeRoot)element)) && parent instanceof IPackageFragment && ((IPackageFragment)parent).isDefaultPackage()) {
                return parent.getParent();
            }
            return parent;
        }
        if (element instanceof IJarEntryResource) {
            return ((IJarEntryResource)element).getParent();
        }
        return null;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        if (a1Len == 0) {
            return a2;
        }
        if (a2Len == 0) {
            return a1;
        }
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }
}

