/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AddActivationHeaderResolution;
import org.eclipse.pde.internal.ui.correction.AddActivationPolicyResolution;
import org.eclipse.pde.internal.ui.correction.AddAutomaticModuleResolution;
import org.eclipse.pde.internal.ui.correction.AddBuildEntryResolution;
import org.eclipse.pde.internal.ui.correction.AddBundleClassPathMarkerResolution;
import org.eclipse.pde.internal.ui.correction.AddBundleManifestVersionResolution;
import org.eclipse.pde.internal.ui.correction.AddDefaultExecutionEnvironmentResolution;
import org.eclipse.pde.internal.ui.correction.AddExportPackageMarkerResolution;
import org.eclipse.pde.internal.ui.correction.AddNewExtensionPointResolution;
import org.eclipse.pde.internal.ui.correction.AddNewExtensionResolution;
import org.eclipse.pde.internal.ui.correction.AddSingletonToSymbolicName;
import org.eclipse.pde.internal.ui.correction.AddSourceBuildEntryResolution;
import org.eclipse.pde.internal.ui.correction.AppendSeperatorBuildEntryResolution;
import org.eclipse.pde.internal.ui.correction.ChooseClassXMLResolution;
import org.eclipse.pde.internal.ui.correction.ChooseManifestClassResolution;
import org.eclipse.pde.internal.ui.correction.ConfigureProblemSeverityForPDECompilerResolution;
import org.eclipse.pde.internal.ui.correction.ConfigureTargetPlatformResolution;
import org.eclipse.pde.internal.ui.correction.CreateClassXMLResolution;
import org.eclipse.pde.internal.ui.correction.CreateJREBundleHeaderResolution;
import org.eclipse.pde.internal.ui.correction.CreateManifestClassResolution;
import org.eclipse.pde.internal.ui.correction.DeletePluginBaseResolution;
import org.eclipse.pde.internal.ui.correction.ExternalizeResolution;
import org.eclipse.pde.internal.ui.correction.ExternalizeStringsResolution;
import org.eclipse.pde.internal.ui.correction.MultiFixResolution;
import org.eclipse.pde.internal.ui.correction.NoLineTerminationResolution;
import org.eclipse.pde.internal.ui.correction.OptionalImportPackageResolution;
import org.eclipse.pde.internal.ui.correction.OptionalRequireBundleResolution;
import org.eclipse.pde.internal.ui.correction.RemoveBuildEntryResolution;
import org.eclipse.pde.internal.ui.correction.RemoveExportPackageResolution;
import org.eclipse.pde.internal.ui.correction.RemoveImportExportServicesResolution;
import org.eclipse.pde.internal.ui.correction.RemoveImportPackageResolution;
import org.eclipse.pde.internal.ui.correction.RemoveInternalDirectiveEntryResolution;
import org.eclipse.pde.internal.ui.correction.RemoveLazyLoadingDirectiveResolution;
import org.eclipse.pde.internal.ui.correction.RemoveNodeXMLResolution;
import org.eclipse.pde.internal.ui.correction.RemoveRequireBundleResolution;
import org.eclipse.pde.internal.ui.correction.RemoveSeperatorBuildEntryResolution;
import org.eclipse.pde.internal.ui.correction.RemoveStaticProjectReferences;
import org.eclipse.pde.internal.ui.correction.RemoveUnknownExecEnvironments;
import org.eclipse.pde.internal.ui.correction.RenameProvidePackageResolution;
import org.eclipse.pde.internal.ui.correction.ReplaceBuildEntryResolution;
import org.eclipse.pde.internal.ui.correction.UnsupportedSingletonDirectiveResolution;
import org.eclipse.pde.internal.ui.correction.UpdateActivationResolution;
import org.eclipse.pde.internal.ui.correction.UpdateClasspathResolution;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class ResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];

    public IMarkerResolution[] getResolutions(IMarker marker) {
        IMarkerResolution[] res = this.getNonConfigSevResolutions(marker);
        String str = marker.getAttribute("compilerKey", "");
        if (str.length() > 0) {
            ArrayList<IMarkerResolution> list = new ArrayList<IMarkerResolution>(Arrays.asList(res));
            list.add((IMarkerResolution)new ConfigureProblemSeverityForPDECompilerResolution(marker, 4, str));
            return list.toArray(new IMarkerResolution[0]);
        }
        return res;
    }

    public IMarkerResolution[] getNonConfigSevResolutions(IMarker marker) {
        int problemID = this.getProblemId(marker);
        switch (problemID) {
            case 4097: {
                if (marker.getAttribute("deprecatedAutostart.canAdd", true) || TargetPlatformHelper.getTargetVersion() <= 3.3) {
                    return new IMarkerResolution[]{new UpdateActivationResolution(2, marker.getAttribute("deprecatedAutostart.header", "Eclipse-AutoStart")), new AddActivationHeaderResolution(1, marker.getAttribute("header", "Eclipse-AutoStart"))};
                }
                return new IMarkerResolution[]{new UpdateActivationResolution(2, marker.getAttribute("deprecatedAutostart.header", "Eclipse-AutoStart"))};
            }
            case 4098: {
                return new IMarkerResolution[]{new CreateJREBundleHeaderResolution(1)};
            }
            case 4099: {
                return new IMarkerResolution[]{new AddSingletonToSymbolicName(2, true)};
            }
            case 4100: {
                return new IMarkerResolution[]{new AddSingletonToSymbolicName(2, false)};
            }
            case 4113: {
                return new IMarkerResolution[]{new UnsupportedSingletonDirectiveResolution(2)};
            }
            case 4101: {
                return new IMarkerResolution[]{new RemoveStaticProjectReferences(3)};
            }
            case 4102: {
                return this.getUnresolvedExportProposals(marker);
            }
            case 4103: {
                return this.getUnresolvedImportPackageProposals(marker);
            }
            case 4104: {
                return this.getUnresolvedBundle(marker);
            }
            case 4112: {
                return new IMarkerResolution[]{new CreateManifestClassResolution(1, "Bundle-Activator"), new ChooseManifestClassResolution(2, "Bundle-Activator")};
            }
            case 4105: {
                return new IMarkerResolution[]{new CreateManifestClassResolution(1, "Plugin-Class"), new ChooseManifestClassResolution(2, "Plugin-Class")};
            }
            case 4114: {
                return this.getRemoveInternalDirectiveResolution(marker);
            }
            case 4115: {
                return new IMarkerResolution[]{new UpdateClasspathResolution(2)};
            }
            case 4116: {
                return new IMarkerResolution[]{new RemoveUnknownExecEnvironments(3)};
            }
            case 4117: {
                return new IMarkerResolution[]{new RemoveImportExportServicesResolution(3, "Import-Service")};
            }
            case 4118: {
                return new IMarkerResolution[]{new RemoveImportExportServicesResolution(3, "Export-Service")};
            }
            case 4119: {
                return new IMarkerResolution[]{new RemoveRequireBundleResolution(3, marker.getAttribute("bundleId", null))};
            }
            case 4120: {
                return new IMarkerResolution[]{new AddExportPackageMarkerResolution(1, marker.getAttribute("packages", null))};
            }
            case 8194: {
                return new IMarkerResolution[]{new RemoveSeperatorBuildEntryResolution(2, marker)};
            }
            case 8193: {
                return new IMarkerResolution[]{new AppendSeperatorBuildEntryResolution(2, marker)};
            }
            case 8195: {
                return this.getBuildEntryAdditionResolutions(marker, null);
            }
            case 8199: {
                return this.getBuildEntryAdditionResolutions(marker, PDEUIMessages.MultiFixResolution_JavaFixAll);
            }
            case 8196: {
                return new IMarkerResolution[]{new AddSourceBuildEntryResolution(1, marker)};
            }
            case 8197: {
                return new IMarkerResolution[]{new RemoveBuildEntryResolution(3, marker)};
            }
            case 8198: {
                return new IMarkerResolution[]{new ReplaceBuildEntryResolution(2, marker)};
            }
            case 12289: {
                return new IMarkerResolution[]{new RemoveNodeXMLResolution(3, marker)};
            }
            case 12290: {
                return new IMarkerResolution[]{new ExternalizeResolution(2, marker), new ExternalizeStringsResolution(2)};
            }
            case 12291: {
                return new IMarkerResolution[]{new CreateClassXMLResolution(1, marker), new ChooseClassXMLResolution(2, marker)};
            }
            case 12292: {
                return new IMarkerResolution[]{new DeletePluginBaseResolution(3), new AddNewExtensionResolution(1), new AddNewExtensionPointResolution(1)};
            }
            case 4121: {
                return new IMarkerResolution[]{new RenameProvidePackageResolution(2)};
            }
            case 4128: {
                return new IMarkerResolution[]{new AddDefaultExecutionEnvironmentResolution(1, marker.getAttribute("ee_id", null))};
            }
            case 4129: {
                return new IMarkerResolution[]{new AddBundleClassPathMarkerResolution(1, marker.getAttribute("entry", null))};
            }
            case 4130: {
                return new IMarkerResolution[]{new RemoveLazyLoadingDirectiveResolution(3, marker.getAttribute("header", "Eclipse-LazyStart"))};
            }
            case 4132: {
                if (marker.getAttribute("noLineTermination.hasContent", true)) {
                    return new IMarkerResolution[]{new NoLineTerminationResolution(1)};
                }
                return new IMarkerResolution[]{new NoLineTerminationResolution(3)};
            }
            case 4133: {
                return new IMarkerResolution[]{new AddBundleManifestVersionResolution()};
            }
            case 4134: {
                return new IMarkerResolution[]{new AddActivationPolicyResolution(1)};
            }
            case 4136: {
                return new IMarkerResolution[]{new AddAutomaticModuleResolution(1, marker)};
            }
        }
        return NO_RESOLUTIONS;
    }

    int getProblemId(IMarker marker) {
        int problemID = marker.getAttribute("problemId", -1);
        if (problemID != -1) {
            return problemID;
        }
        return marker.getAttribute("id", -1);
    }

    private IMarkerResolution[] getBuildEntryAdditionResolutions(IMarker marker, String multiFixDescription) {
        ArrayList<WorkbenchMarkerResolution> resolutions = new ArrayList<WorkbenchMarkerResolution>(2);
        resolutions.add(new AddBuildEntryResolution(1, marker));
        int i = 0;
        while (true) {
            try {
                String entry = (String)marker.getAttribute("buildEntry.key." + i);
                if (entry == null) break;
                String value = (String)marker.getAttribute("buildEntry.tokenValue." + i);
                resolutions.add(new AddBuildEntryResolution(1, marker, entry, value));
            }
            catch (CoreException coreException) {
                break;
            }
            ++i;
        }
        try {
            String markerCategory = (String)marker.getAttribute("categoryId");
            int problemID = this.getProblemId(marker);
            IMarker[] relatedMarkers = marker.getResource().findMarkers(marker.getType(), true, 2);
            int i2 = 0;
            while (i2 < relatedMarkers.length) {
                if (markerCategory.equals(relatedMarkers[i2].getAttribute("categoryId")) && this.getProblemId(relatedMarkers[i2]) == problemID && !marker.equals((Object)relatedMarkers[i2])) {
                    resolutions.add(new MultiFixResolution(marker, multiFixDescription));
                    break;
                }
                ++i2;
            }
        }
        catch (CoreException coreException) {}
        return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
    }

    private IMarkerResolution[] getRemoveInternalDirectiveResolution(IMarker marker) {
        IResource res;
        String packageName = marker.getAttribute("packageName", null);
        if (packageName != null && (res = marker.getResource()) != null) {
            return new IMarkerResolution[]{new RemoveInternalDirectiveEntryResolution(3, packageName)};
        }
        return NO_RESOLUTIONS;
    }

    private IMarkerResolution[] getUnresolvedExportProposals(IMarker marker) {
        IResource res;
        String packageName = marker.getAttribute("packageName", null);
        if (packageName != null && (res = marker.getResource()) != null) {
            return new IMarkerResolution[]{new RemoveExportPackageResolution(3, packageName)};
        }
        return NO_RESOLUTIONS;
    }

    private IMarkerResolution[] getUnresolvedImportPackageProposals(IMarker marker) {
        String packageName = marker.getAttribute("packageName", null);
        if (packageName == null) {
            return NO_RESOLUTIONS;
        }
        boolean optionalPkg = marker.getAttribute("optional", false);
        if (optionalPkg) {
            return new IMarkerResolution[]{new RemoveImportPackageResolution(3, packageName), new ConfigureTargetPlatformResolution()};
        }
        return new IMarkerResolution[]{new RemoveImportPackageResolution(3, packageName), new OptionalImportPackageResolution(2, packageName), new ConfigureTargetPlatformResolution()};
    }

    private IMarkerResolution[] getUnresolvedBundle(IMarker marker) {
        String bundleId = marker.getAttribute("bundleId", null);
        if (bundleId == null) {
            return NO_RESOLUTIONS;
        }
        boolean optionalBundle = marker.getAttribute("optional", false);
        if (optionalBundle) {
            return new IMarkerResolution[]{new RemoveRequireBundleResolution(3, bundleId), new ConfigureTargetPlatformResolution()};
        }
        return new IMarkerResolution[]{new RemoveRequireBundleResolution(3, bundleId), new OptionalRequireBundleResolution(2, bundleId), new ConfigureTargetPlatformResolution()};
    }

    public boolean hasResolutions(IMarker marker) {
        return this.getProblemId(marker) > 0;
    }
}

