/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.util.Properties;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.context.ManifestDocumentSetupParticipant;
import org.eclipse.pde.internal.ui.editor.context.XMLDocumentSetupParticpant;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.ManifestConfiguration;
import org.eclipse.pde.internal.ui.editor.text.XMLConfiguration;
import org.eclipse.pde.internal.ui.nls.ExternalizeStringsLabelProvider;
import org.eclipse.pde.internal.ui.nls.ExternalizeStringsProcessor;
import org.eclipse.pde.internal.ui.nls.ModelChange;
import org.eclipse.pde.internal.ui.nls.ModelChangeElement;
import org.eclipse.pde.internal.ui.nls.ModelChangeFile;
import org.eclipse.pde.internal.ui.nls.ModelChangeLabelProvider;
import org.eclipse.pde.internal.ui.nls.ModelChangeTable;
import org.eclipse.pde.internal.ui.nls.StringHelper;
import org.eclipse.pde.internal.ui.refactoring.PDERefactor;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class ExternalizeStringsWizardPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "ExternalizeStringsWizardPage";
    public static final int EXTERN = 0;
    public static final int VALUE = 1;
    public static final int KEY = 2;
    private static final int SIZE = 3;
    private static final String[] TABLE_PROPERTIES = new String[3];
    private static final String[] TABLE_COLUMNS = new String[3];
    private ModelChangeTable fModelChangeTable;
    private ContainerCheckedTreeViewer fInputViewer;
    private Button fSelectAll;
    private Button fDeselectAll;
    private Label fProjectLabel;
    private Text fLocalizationText;
    private CheckboxTableViewer fPropertiesViewer;
    private Table fTable;
    private SourceViewer fSourceViewer;
    private ViewerFilter fErrorElementFilter;
    private ModifyListener fModifyListener;
    private Object fCurrSelection;
    private ModelChangeElement fErrorElement;
    private String fPreErrorKey;
    private IDocument fEmptyDoc;
    private IColorManager fColorManager;
    private XMLConfiguration fXMLConfig;
    private XMLDocumentSetupParticpant fXMLSetupParticipant;
    private ManifestDocumentSetupParticipant fManifestSetupParticipant;
    private ManifestConfiguration fManifestConfig;

    static {
        ExternalizeStringsWizardPage.TABLE_PROPERTIES[0] = "extern";
        ExternalizeStringsWizardPage.TABLE_PROPERTIES[1] = "value";
        ExternalizeStringsWizardPage.TABLE_PROPERTIES[2] = "key";
        ExternalizeStringsWizardPage.TABLE_COLUMNS[0] = "";
        ExternalizeStringsWizardPage.TABLE_COLUMNS[1] = PDEUIMessages.ExternalizeStringsWizardPage_value;
        ExternalizeStringsWizardPage.TABLE_COLUMNS[2] = PDEUIMessages.ExternalizeStringsWizardPage_subKey;
    }

    protected ExternalizeStringsWizardPage(ModelChangeTable changeTable) {
        super(PAGE_NAME);
        this.setTitle(PDEUIMessages.ExternalizeStringsWizardPage_pageTitle);
        this.setDescription(PDEUIMessages.ExternalizeStringsWizardPage_pageDescription);
        this.fModelChangeTable = changeTable;
        this.fErrorElementFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!(element instanceof ModelChangeElement)) {
                    return false;
                }
                ModelChangeElement change = (ModelChangeElement)element;
                return change.equals(ExternalizeStringsWizardPage.this.fErrorElement);
            }
        };
        this.fModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String localization = ExternalizeStringsWizardPage.this.fLocalizationText.getText();
                if (StringHelper.isValidLocalization(localization)) {
                    ExternalizeStringsWizardPage.this.setEnabled((Control)ExternalizeStringsWizardPage.this.fLocalizationText, true);
                    ExternalizeStringsWizardPage.this.setPageComplete(ExternalizeStringsWizardPage.this.hasCheckedElements());
                    ExternalizeStringsWizardPage.this.setErrorMessage(null);
                    if (ExternalizeStringsWizardPage.this.fCurrSelection instanceof ModelChange) {
                        ((ModelChange)ExternalizeStringsWizardPage.this.fCurrSelection).setBundleLocalization(ExternalizeStringsWizardPage.this.fLocalizationText.getText());
                    } else if (ExternalizeStringsWizardPage.this.fCurrSelection instanceof ModelChangeFile) {
                        ((ModelChangeFile)ExternalizeStringsWizardPage.this.fCurrSelection).getModel().setBundleLocalization(ExternalizeStringsWizardPage.this.fLocalizationText.getText());
                    }
                } else {
                    ExternalizeStringsWizardPage.this.setEnabled((Control)ExternalizeStringsWizardPage.this.fLocalizationText, false);
                    ExternalizeStringsWizardPage.this.fLocalizationText.setEditable(true);
                    ExternalizeStringsWizardPage.this.setPageComplete(false);
                    ExternalizeStringsWizardPage.this.setErrorMessage(PDEUIMessages.ExternalizeStringsWizardPage_badLocalizationError);
                }
            }
        };
        this.fColorManager = ColorManager.getDefault();
        this.fXMLConfig = new XMLConfiguration(this.fColorManager);
        this.fXMLSetupParticipant = new XMLDocumentSetupParticpant();
        this.fManifestConfig = new ManifestConfiguration(this.fColorManager);
        this.fManifestSetupParticipant = new ManifestDocumentSetupParticipant();
    }

    public void dispose() {
        this.fColorManager.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        SashForm superSash = new SashForm(parent, 256);
        superSash.setFont(parent.getFont());
        superSash.setLayoutData((Object)new GridData(1808));
        this.createInputContents((Composite)superSash);
        SashForm sash = new SashForm((Composite)superSash, 512);
        sash.setFont(superSash.getFont());
        sash.setLayoutData((Object)new GridData(1808));
        this.createTableViewer((Composite)sash);
        this.createSourceViewer((Composite)sash);
        this.initialize();
        this.setPageComplete(this.hasCheckedElements());
        superSash.setWeights(new int[]{4, 7});
        this.setControl((Control)superSash);
        Dialog.applyDialogFont((Control)superSash);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)superSash, "org.eclipse.pde.doc.user.externalize_strings_page");
    }

    private void createInputContents(Composite composite) {
        Composite fileComposite = new Composite(composite, 0);
        fileComposite.setLayout((Layout)new GridLayout());
        fileComposite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(fileComposite, 0);
        label.setText(PDEUIMessages.ExternalizeStringsWizardPage_resourcelabel);
        this.fInputViewer = new ContainerCheckedTreeViewer(fileComposite, 2820);
        this.fInputViewer.setContentProvider((IContentProvider)new ModelChangeContentProvider());
        this.fInputViewer.setLabelProvider((IBaseLabelProvider)new ModelChangeLabelProvider());
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        this.fInputViewer.getTree().setLayoutData((Object)gd);
        this.fInputViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExternalizeStringsWizardPage.this.handleSelectionChanged(event);
            }
        });
        this.fInputViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExternalizeStringsWizardPage.this.setPageComplete(ExternalizeStringsWizardPage.this.hasCheckedElements());
            }
        });
        this.fInputViewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        Composite buttonComposite = new Composite(fileComposite, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(768));
        this.fSelectAll = new Button(buttonComposite, 8);
        this.fSelectAll.setText(PDEUIMessages.ExternalizeStringsWizardPage_selectAllButton);
        this.fSelectAll.setLayoutData((Object)new GridData(768));
        this.fSelectAll.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fInputViewer.setCheckedElements(this.fModelChangeTable.getAllModelChanges().toArray());
            this.setPageComplete(this.hasCheckedElements());
        }));
        this.fDeselectAll = new Button(buttonComposite, 8);
        this.fDeselectAll.setText(PDEUIMessages.ExternalizeStringsWizardPage_deselectAllButton);
        this.fDeselectAll.setLayoutData((Object)new GridData(768));
        this.fDeselectAll.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fInputViewer.setCheckedElements(new Object[0]);
            this.setPageComplete(this.hasCheckedElements());
        }));
        Composite infoComposite = new Composite(fileComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        infoComposite.setLayout((Layout)layout);
        infoComposite.setLayoutData((Object)new GridData(768));
        Label project = new Label(infoComposite, 0);
        project.setText(PDEUIMessages.ExternalizeStringsWizardPage_projectLabel);
        this.fProjectLabel = new Label(infoComposite, 0);
        gd = new GridData(768);
        gd.horizontalIndent = 10;
        this.fProjectLabel.setLayoutData((Object)gd);
        this.fProjectLabel.setText(PDEUIMessages.ExternalizeStringsWizardPage_noUnderlyingResource);
        Label properties = new Label(infoComposite, 0);
        properties.setText(PDEUIMessages.ExternalizeStringsWizardPage_localizationLabel);
        this.fLocalizationText = new Text(infoComposite, 2048);
        gd = new GridData(768);
        gd.horizontalIndent = 10;
        this.fLocalizationText.setLayoutData((Object)gd);
        this.fLocalizationText.setText(PDEUIMessages.ExternalizeStringsWizardPage_noUnderlyingResource);
        this.fLocalizationText.addModifyListener(this.fModifyListener);
        this.fInputViewer.setInput((Object)PDEPlugin.getDefault());
    }

    private void createTableViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText(PDEUIMessages.ExternalizeStringsWizardPage_propertiesLabel);
        label.setLayoutData((Object)new GridData(768));
        this.fPropertiesViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)101120);
        this.fTable = this.fPropertiesViewer.getTable();
        this.fTable.setFont(composite.getFont());
        this.fTable.setLayoutData((Object)new GridData(1808));
        this.fTable.setLayout((Layout)new GridLayout());
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        int i = 0;
        while (i < TABLE_COLUMNS.length) {
            TableColumn tc = new TableColumn(this.fTable, 0);
            tc.setText(TABLE_COLUMNS[i]);
            tc.setResizable(i != 0);
            tc.setWidth(i == 0 ? 20 : 200);
            ++i;
        }
        this.fPropertiesViewer.setUseHashlookup(true);
        this.fPropertiesViewer.setCellEditors(this.createCellEditors());
        this.fPropertiesViewer.setColumnProperties(TABLE_PROPERTIES);
        this.fPropertiesViewer.setCellModifier((ICellModifier)new ExternalizeStringsCellModifier());
        this.fPropertiesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object selection;
                if (ExternalizeStringsWizardPage.this.fInputViewer.getSelection() instanceof IStructuredSelection && (selection = ((IStructuredSelection)ExternalizeStringsWizardPage.this.fInputViewer.getSelection()).getFirstElement()) instanceof ModelChangeFile) {
                    ModelChangeFile cf = (ModelChangeFile)selection;
                    return cf.getModel().getChangesInFile(cf.getFile()).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fPropertiesViewer.setLabelProvider((IBaseLabelProvider)new ExternalizeStringsLabelProvider());
        this.fPropertiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExternalizeStringsWizardPage.this.handlePropertySelection();
            }
        });
        this.fPropertiesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof ModelChangeElement) {
                    ((ModelChangeElement)element).setExternalized(event.getChecked());
                    ExternalizeStringsWizardPage.this.fPropertiesViewer.update(element, null);
                }
            }
        });
        this.fPropertiesViewer.setInput(new Object());
    }

    private void createSourceViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText(PDEUIMessages.ExternalizeStringsWizardPage_sourceLabel);
        label.setLayoutData((Object)new GridData());
        this.fSourceViewer = new SourceViewer(composite, null, 2816);
        this.fSourceViewer.setEditable(false);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        this.fSourceViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fEmptyDoc = new Document();
        this.fSourceViewer.setDocument(this.fEmptyDoc);
    }

    private void initialize() {
        Object[] preSelect = this.fModelChangeTable.getPreSelected();
        this.fInputViewer.setSelection((ISelection)new StructuredSelection(preSelect));
        this.fInputViewer.setCheckedElements(this.fModelChangeTable.getPreSelected());
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        block14: {
            if (!(event.getSelection() instanceof IStructuredSelection)) {
                return;
            }
            Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (selection == null) {
                this.fCurrSelection = null;
                this.fSourceViewer.setDocument(this.fEmptyDoc);
            } else {
                if (selection.equals(this.fCurrSelection)) {
                    return;
                }
                if (selection instanceof ModelChangeFile) {
                    this.fCurrSelection = selection;
                    IFile file = ((ModelChangeFile)this.fCurrSelection).getFile();
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    try {
                        try {
                            try {
                                manager.connect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)monitor);
                                this.updateSourceViewer(manager, file);
                            }
                            catch (MalformedTreeException malformedTreeException) {
                                manager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)monitor);
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            manager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)monitor);
                            throw throwable;
                        }
                        manager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)monitor);
                    }
                    catch (CoreException coreException) {}
                } else if (selection instanceof ModelChange) {
                    this.fCurrSelection = selection;
                    this.fSourceViewer.setDocument(this.fEmptyDoc);
                    this.updatePropertiesLabel(((ModelChange)this.fCurrSelection).getParentModel());
                }
            }
        }
        this.refreshPropertiesViewer(false);
    }

    private void refreshPropertiesViewer(boolean updateLabels) {
        this.fPropertiesViewer.refresh(updateLabels);
        TableItem[] items = this.fTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() instanceof ModelChangeElement) {
                ModelChangeElement element = (ModelChangeElement)items[i].getData();
                this.fPropertiesViewer.setChecked((Object)element, element.isExternalized());
            }
            ++i;
        }
    }

    private void updateSourceViewer(ITextFileBufferManager manager, IFile sourceFile) {
        IDocument document = manager.getTextFileBuffer(sourceFile.getFullPath(), LocationKind.IFILE).getDocument();
        TreeItem item = this.fInputViewer.getTree().getSelection()[0];
        IPluginModelBase model = ((ModelChange)item.getParentItem().getData()).getParentModel();
        if (this.fSourceViewer.getDocument() != null) {
            this.fSourceViewer.unconfigure();
        }
        if (sourceFile.getFileExtension().equalsIgnoreCase("xml")) {
            this.fSourceViewer.configure((SourceViewerConfiguration)this.fXMLConfig);
            this.fXMLSetupParticipant.setup(document);
        } else {
            this.fSourceViewer.configure((SourceViewerConfiguration)this.fManifestConfig);
            this.fManifestSetupParticipant.setup(document);
        }
        this.fSourceViewer.setDocument(document);
        this.updatePropertiesLabel(model);
    }

    private void updatePropertiesLabel(IPluginModelBase model) {
        ModelChange modelChange = this.fModelChangeTable.getModelChange(model);
        this.fProjectLabel.setText(model.getUnderlyingResource().getProject().getName());
        this.fLocalizationText.setEditable(!modelChange.localizationSet());
        this.fLocalizationText.setText(modelChange.getBundleLocalization());
    }

    private void handlePropertySelection() {
        if (!(this.fPropertiesViewer.getSelection() instanceof IStructuredSelection)) {
            return;
        }
        Object selection = ((IStructuredSelection)this.fPropertiesViewer.getSelection()).getFirstElement();
        if (selection instanceof ModelChangeElement && this.fSourceViewer.getDocument() != null) {
            ModelChangeElement element = (ModelChangeElement)selection;
            int offset = element.getOffset();
            int length = element.getLength();
            this.fSourceViewer.setSelectedRange(offset, length);
            this.fSourceViewer.revealRange(offset, length);
        }
    }

    private CellEditor[] createCellEditors() {
        CellEditor[] editors = new CellEditor[]{null, null, new TextCellEditor((Composite)this.fTable)};
        return editors;
    }

    private void validateKey(String key, ModelChangeElement element) {
        String oldKey;
        ModelChange modelChange = ((ModelChangeFile)this.fCurrSelection).getModel();
        Properties properties = modelChange.getProperties();
        String error = null;
        String string = oldKey = this.fPreErrorKey != null ? this.fPreErrorKey : element.getKey();
        if (!key.equals(this.fPreErrorKey)) {
            if (key.trim().length() < 1) {
                error = this.getErrorMessage(PDEUIMessages.ExternalizeStringsWizardPage_keyEmptyError, oldKey);
            } else if (key.charAt(0) == '#' || key.charAt(0) == '!' || key.charAt(0) == '%') {
                error = this.getErrorMessage(PDEUIMessages.ExternalizeStringsWizardPage_keyCommentError, oldKey);
            } else if (key.indexOf(58) != -1 || key.indexOf(61) != -1 || key.indexOf(32) != -1) {
                error = this.getErrorMessage(PDEUIMessages.ExternalizeStringsWizardPage_keyError, oldKey);
            } else if ((!key.equals(oldKey) || this.fPreErrorKey != null) && properties.containsKey(key)) {
                error = this.getErrorMessage(PDEUIMessages.ExternalizeStringsWizardPage_keyDuplicateError, oldKey);
            }
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null && this.hasCheckedElements());
        if (error == null) {
            this.fErrorElement = null;
            this.fPreErrorKey = null;
            this.setEnabled(this.fPropertiesViewer.getControl(), true);
            this.fPropertiesViewer.removeFilter(this.fErrorElementFilter);
            this.refreshPropertiesViewer(true);
            properties.setProperty(key, element.getValue());
        } else if (this.fPreErrorKey == null) {
            this.fErrorElement = element;
            this.fPreErrorKey = oldKey;
            this.setEnabled(this.fPropertiesViewer.getControl(), false);
            this.fPropertiesViewer.addFilter(this.fErrorElementFilter);
        }
    }

    private String getErrorMessage(String error, String suggestion) {
        StringBuffer sb = new StringBuffer(error);
        if (suggestion != null) {
            sb.append(PDEUIMessages.ExternalizeStringsWizardPage_keySuggested);
            sb.append(suggestion);
        }
        return sb.toString();
    }

    public Object[] getChangeFiles() {
        return this.fInputViewer.getCheckedElements();
    }

    private boolean hasCheckedElements() {
        return this.fInputViewer.getCheckedElements().length > 0;
    }

    private void setEnabled(Control exception, boolean enabled) {
        if (!exception.equals(this.fInputViewer.getControl())) {
            this.fInputViewer.getControl().setEnabled(enabled);
        }
        if (!exception.equals(this.fPropertiesViewer.getControl())) {
            this.fPropertiesViewer.getControl().setEnabled(enabled);
        }
        if (!exception.equals(this.fLocalizationText)) {
            this.fLocalizationText.setEnabled(enabled);
        }
        if (!exception.equals(this.fSelectAll)) {
            this.fSelectAll.setEnabled(enabled);
        }
        if (!exception.equals(this.fDeselectAll)) {
            this.fDeselectAll.setEnabled(enabled);
        }
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        if (complete) {
            ((ExternalizeStringsProcessor)((PDERefactor)this.getRefactoring()).getProcessor()).setChangeFiles(this.fInputViewer.getCheckedElements());
        }
    }

    private class ExternalizeStringsCellModifier
    implements ICellModifier {
        private ExternalizeStringsCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property != null && element instanceof ModelChangeElement && !TABLE_PROPERTIES[1].equals(property) && (ExternalizeStringsWizardPage.this.isPageComplete() || element.equals(ExternalizeStringsWizardPage.this.fErrorElement)) && TABLE_PROPERTIES[2].equals(property) && ((ModelChangeElement)element).isExternalized();
        }

        public Object getValue(Object element, String property) {
            if (element instanceof ModelChangeElement) {
                ModelChangeElement changeElement = (ModelChangeElement)element;
                if (TABLE_PROPERTIES[2].equals(property)) {
                    return StringHelper.unwindEscapeChars(changeElement.getKey());
                }
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            Object data;
            if (element instanceof TableItem && (data = ((TableItem)element).getData()) instanceof ModelChangeElement) {
                ModelChangeElement changeElement = (ModelChangeElement)data;
                if (TABLE_PROPERTIES[2].equals(property)) {
                    String newKey = StringHelper.windEscapeChars((String)value);
                    ExternalizeStringsWizardPage.this.validateKey(newKey, changeElement);
                    changeElement.setKey(newKey);
                    ExternalizeStringsWizardPage.this.fPropertiesViewer.update(data, null);
                }
            }
        }
    }

    private class ModelChangeContentProvider
    implements ITreeContentProvider {
        private ModelChangeContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return ExternalizeStringsWizardPage.this.fModelChangeTable.getAllModelChanges().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (!(parentElement instanceof ModelChange)) {
                return new Object[0];
            }
            return ((ModelChange)parentElement).getModelChangeFiles();
        }

        public Object getParent(Object element) {
            if (element instanceof ModelChangeFile) {
                return ((ModelChangeFile)element).getModel();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ModelChange;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

