/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal.oauth;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.utils.DateUtils;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.internal.util.JSONUtil;

public class AuthToken {
    private static String ACCESS_TOKEN = "access_token";
    private static String TOKEN_TYPE = "token_type";
    private static String SCOPE = "scope";
    private static String REFRESH_TOKEN = "refresh_token";
    private static String EXPIRES_IN = "expires_in";
    private static String EXPIRES = "_expires_";
    private Map<String, String> details;
    private Date expiryDate;

    private AuthToken(Map<String, String> details, Date expiryDate) {
        this.details = details;
        this.expiryDate = expiryDate;
    }

    public AuthToken(String jsonRepresentation, Date responseDate) {
        try {
            Object o = JSONUtil.parse((InputStream)IOUtil.streamUTF((String)jsonRepresentation), null);
            if (!(o instanceof Map)) {
                throw new IllegalArgumentException("not a valid auth token object");
            }
            this.details = (Map)o;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("not a valid auth token object");
        }
        if (!this.details.containsKey(ACCESS_TOKEN)) {
            throw new IllegalArgumentException("does not appear to be a valid auth token object");
        }
        if (this.details.containsKey(EXPIRES_IN)) {
            long expiry = Long.parseLong(this.details.remove(EXPIRES_IN));
            this.expiryDate = new Date(responseDate.getTime() + expiry * 1000L);
            this.details.put(EXPIRES, DateUtils.formatDate((Date)this.expiryDate));
        }
    }

    public static AuthToken deserialize(String serializedForm) throws IllegalArgumentException {
        if (serializedForm == null) {
            throw new IllegalArgumentException("no token");
        }
        try {
            Object o = JSONUtil.parse((InputStream)IOUtil.streamUTF((String)serializedForm), null);
            if (!(o instanceof Map)) {
                throw new IllegalArgumentException("not a JSON object");
            }
            Map details = (Map)o;
            if (details.containsKey(EXPIRES_IN) || !details.containsKey(ACCESS_TOKEN)) {
                throw new IllegalArgumentException("does not appear to be a valid auth token object");
            }
            Date expiryDate = null;
            if (details.containsKey(EXPIRES)) {
                expiryDate = DateUtils.parseDate((String)((String)details.get(EXPIRES)));
            }
            return new AuthToken(details, expiryDate);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getAccessToken() {
        return this.details.get(ACCESS_TOKEN);
    }

    public String getRefreshToken() {
        return this.details.get(REFRESH_TOKEN);
    }

    public String getTokenType() {
        return this.details.get(TOKEN_TYPE);
    }

    public Set<String> getScopes() {
        HashSet<String> result = new HashSet<String>();
        String scopes = this.details.get(SCOPE);
        if (scopes != null) {
            String[] stringArray = scopes.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                result.add(s);
                ++n2;
            }
        }
        return result;
    }

    public boolean isExpired() {
        return this.expiryDate != null && this.expiryDate.compareTo(new Date()) <= 0;
    }

    public String serialize() throws IOException {
        int length;
        InputStream inputStream = JSONUtil.build(this.details);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }
}

