/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.reporting;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.STABLE, since="1.0")
public final class ReportEntry {
    private final LocalDateTime timestamp = LocalDateTime.now();
    private final Map<String, String> keyValuePairs = new LinkedHashMap<String, String>();

    public static ReportEntry from(Map<String, String> keyValuePairs) {
        Preconditions.notNull(keyValuePairs, (String)"keyValuePairs must not be null");
        ReportEntry reportEntry = new ReportEntry();
        keyValuePairs.forEach(reportEntry::add);
        return reportEntry;
    }

    public static ReportEntry from(String key, String value) {
        ReportEntry reportEntry = new ReportEntry();
        reportEntry.add(key, value);
        return reportEntry;
    }

    private void add(String key, String value) {
        Preconditions.notBlank((String)key, (String)"key must not be null or blank");
        Preconditions.notBlank((String)value, (String)"value must not be null or blank");
        this.keyValuePairs.put(key, value);
    }

    public final Map<String, String> getKeyValuePairs() {
        return Collections.unmodifiableMap(this.keyValuePairs);
    }

    public final LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("timestamp", (Object)this.timestamp);
        this.keyValuePairs.forEach((arg_0, arg_1) -> ((ToStringBuilder)builder).append(arg_0, arg_1));
        return builder.toString();
    }
}

