/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.instantrelation.generator.metier;

import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLConstraintRef;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLRelationModelFactory;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.Precedence;
import fr.inria.aoste.timesquare.instantrelation.exceptions.ResolveClockConstraintException;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.AbstractCreator;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.Description;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.ModelElementReference;

public abstract class AbstractCreatorPrecedes
extends AbstractCreator {
    private boolean strict = true;
    protected final ModelElementReference source;
    protected final ModelElementReference target;

    public AbstractCreatorPrecedes(CCSLConstraintRef cref, ModelElementReference source, ModelElementReference target) {
        super(cref);
        this.source = source;
        this.target = target;
    }

    public AbstractCreatorPrecedes(CCSLConstraintRef cref, ModelElementReference source, ModelElementReference target, boolean strict) {
        super(cref);
        this.source = source;
        this.target = target;
        this.strict = strict;
    }

    public final Precedence createRelationPrecedence(EventOccurrence first, EventOccurrence second, boolean strictly) {
        Precedence relationPrecedence = CCSLRelationModelFactory.eINSTANCE.createPrecedence();
        relationPrecedence.setIsStrict(strictly);
        relationPrecedence.setSource(first);
        relationPrecedence.setTarget(second);
        return relationPrecedence;
    }

    @Override
    public boolean addChecking() {
        return this.source != this.target && this.source != null && this.target != null;
    }

    public final synchronized ModelElementReference getSource() {
        return this.source;
    }

    public final synchronized ModelElementReference getTarget() {
        return this.target;
    }

    public final synchronized boolean isStrict() {
        return this.strict;
    }

    @Override
    public void resolve() throws ResolveClockConstraintException {
        EventOccurrence esource = this.getEventOccurrenceOnStepTrace(this.source);
        EventOccurrence etarget = this.getEventOccurrenceOnStepTrace(this.target);
        this.resolve(esource, etarget);
    }

    protected void workTarget(EventOccurrence etarget) throws ResolveClockConstraintException {
        EventOccurrence msource;
        boolean btarget = this.clockTick(etarget);
        if (btarget && this.targetvalid() && (msource = this.poolsource()) != null) {
            this.addRelation(this.createRelationPrecedence(msource, etarget, this.strict));
        }
    }

    protected void workSource(EventOccurrence esource) {
        boolean bsource = this.clockTick(esource);
        if (bsource && this.sourcevalid()) {
            this.addsource(esource);
        }
    }

    protected void resolve(EventOccurrence esource, EventOccurrence etarget) throws ResolveClockConstraintException {
        if (this.strict) {
            this.workTarget(etarget);
            this.workSource(esource);
        } else {
            this.workSource(esource);
            this.workTarget(etarget);
        }
    }

    protected abstract void notifyTargetWithoutSource() throws ResolveClockConstraintException;

    protected abstract EventOccurrence poolsource();

    protected abstract void addsource(EventOccurrence var1);

    protected boolean sourcevalid() {
        return true;
    }

    protected boolean targetvalid() {
        return true;
    }

    @Override
    public Description createDescription() {
        return Description.createDescriptionPrecede(this.source, this.target, this.strict, this.getCcslConstraintRef());
    }
}

