/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.antlr.editors;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.vcd.IVcd;
import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.ListConnections;
import fr.inria.aoste.timesquare.vcd.VcdZoom;
import fr.inria.aoste.timesquare.vcd.antlr.editors.ToolBarAPi;
import fr.inria.aoste.timesquare.vcd.antlr.editors.VCDTextEditor;
import fr.inria.aoste.timesquare.vcd.antlr.editors.VcdMultiPageEditorContributor;
import fr.inria.aoste.timesquare.vcd.antlr.view.ConstraintView;
import fr.inria.aoste.timesquare.vcd.antlr.view.VcdDiagramReader;
import fr.inria.aoste.timesquare.vcd.draw.FigureCanvasBase;
import fr.inria.aoste.timesquare.vcd.menu.Mode;
import fr.inria.aoste.timesquare.vcd.menu.VcdMenu;
import fr.inria.aoste.timesquare.vcd.model.IDeclarationCommand;
import fr.inria.aoste.timesquare.vcd.model.VCDDefinitions;
import fr.inria.aoste.timesquare.vcd.model.command.ScopeCommand;
import fr.inria.aoste.timesquare.vcd.model.comment.IConstraintData;
import fr.inria.aoste.timesquare.vcd.model.keyword.ScopeType;
import fr.inria.aoste.timesquare.vcd.model.visitor.Collector;
import fr.inria.aoste.timesquare.vcd.model.visitor.TraceCollector;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import fr.inria.aoste.timesquare.vcd.view.ConstraintsFactory;
import fr.inria.aoste.timesquare.vcd.view.IConstructContraint;
import fr.inria.aoste.timesquare.vcd.view.IVcdMultiPageEditor;
import fr.inria.aoste.timesquare.vcd.view.Iupdate;
import fr.inria.aoste.timesquare.vcd.view.MarkerFactory;
import fr.inria.aoste.timesquare.vcd.view.VcdFactory;
import fr.inria.aoste.timesquare.vcd.view.figure.CountFigure;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;

public class VcdMultiPageEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
IVcdMultiPageEditor,
IVcdDiagram,
Iupdate {
    private static VCDDefinitions vcdFromBackend = null;
    private static IFile file = null;
    private ConstraintsFactory _constraintsFactory;
    private MarkerFactory _markerFactory;
    private boolean _ctrlKey = false;
    private VCDTextEditor _vcdTextEditor = null;
    private VcdFactory _vcdFactory = null;
    private Mode _ghostMode = null;
    private ListConnections _listConnections;
    private double _markerZoomValue = 2.0;
    private Shell _shell;
    private boolean _isSimulation = false;
    private TraceCollector _traceCollector;
    private double _traceCollectorZoomValue = 2.0;
    private VCDDefinitions _vcdModel;
    private double _zoomValue = 1.0;
    protected VcdMultiPageEditorContributor _vcdMultiPageEditorContributor = null;
    private VcdZoom _vcdZoom = null;
    private FigureCanvasBase _figureCanvasBase = null;
    private VcdColorPreferences _colorSettings;
    private VcdMenu _vcdMenu;
    private static VcdColorPreferences _colorSettingsFromBackend = null;
    private boolean isdisposed = false;
    int _activePageNumber = 0;

    private static final IFile getFile() {
        return file;
    }

    private static final void setFile(IFile file) {
        VcdMultiPageEditor.file = file;
    }

    public VcdMultiPageEditor() {
        CountFigure.disp();
        this._colorSettings = _colorSettingsFromBackend != null ? _colorSettingsFromBackend : VcdColorPreferences.createColor();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this._listConnections = this.createList();
        this._vcdZoom = new VcdZoom(this._listConnections, (IVcdDiagram)this);
        this._figureCanvasBase = new FigureCanvasBase((IVcd)this, this._colorSettings);
        this._vcdMenu = new VcdMenu((IVcdDiagram)this);
    }

    public VcdColorPreferences getColorPreferences() {
        return this._colorSettings;
    }

    public VcdMenu getVcdmenu() {
        return this._vcdMenu;
    }

    public void setFocus() {
        try {
            IEditorActionBarContributor contributor;
            super.setFocus();
            if (this._vcdMenu == null) {
                this._vcdMenu = new VcdMenu((IVcdDiagram)this);
            }
            if ((contributor = this.getEditorSite().getActionBarContributor()) instanceof MultiPageEditorActionBarContributor) {
                this._vcdMultiPageEditorContributor = (VcdMultiPageEditorContributor)contributor;
                ((MultiPageEditorActionBarContributor)contributor).setActivePage((IEditorPart)this);
            }
            if (this._vcdZoom != null) {
                this._vcdZoom.setIczoom(ToolBarAPi.getDef().getCombozoom());
            }
            ToolBarAPi.getDef().setCurrentVcd(this);
            if (this._vcdModel != null) {
                ConstraintView.getCurrentConstraintView().setConstraint(this._vcdModel.getConstraintList());
            }
            ConstraintView.getCurrentConstraintView().setFocus();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setActiveVCDPage() {
        if (this.getPageCount() != 0) {
            this.setActivePage(0);
        }
    }

    protected void setActivePage(int pageIndex) {
        try {
            if (this._vcdMenu != null) {
                this._vcdMenu.getFindAction();
                this._vcdMenu.getOrderAction();
            }
            super.setActivePage(pageIndex);
            this.setFocus();
        }
        catch (Exception e) {
            ErrorConsole.printError((Throwable)e);
        }
    }

    public void create() {
        this._shell = this.getContainer().getShell();
        this._figureCanvasBase.createListener(this._listConnections, (IVcdDiagram)this);
        this.setPartName(this.getEditorInput().getName());
    }

    public void syncModel2Text() {
        try {
            if (this._vcdModel == null) {
                return;
            }
            String s = this._vcdModel.getVCDString();
            if (this._vcdTextEditor != null) {
                this._vcdTextEditor.updateFull(s, true);
            }
        }
        catch (Exception ex) {
            ErrorConsole.printError((Throwable)ex);
        }
    }

    public int getSizeFile(IFile f) {
        block3: {
            try {
                if (f.exists()) break block3;
                return 0;
            }
            catch (Exception ex) {
                ErrorConsole.printError((Throwable)ex);
                return 0;
            }
        }
        f.refreshLocal(0, null);
        int n = f.getContents().available();
        return n;
    }

    public boolean isNewFile(IFile f) {
        return f.equals((Object)VcdMultiPageEditor.getFile());
    }

    public void setSimulationProgress(int step) {
        if (this._figureCanvasBase != null) {
            this._figureCanvasBase.setSimulationProgress(step);
        }
    }

    public ListConnections createList() {
        return new ListConnections(new ArrayList(), new ArrayList(), new HashMap());
    }

    void createPage0() {
        try {
            this._isSimulation = false;
            IFile ifloc = ((FileEditorInput)this.getEditorInput()).getFile();
            if (!this.isNewFile(ifloc) && this.getSizeFile(ifloc) != 0) {
                ErrorConsole.printOKln((String)("VCD : Read " + ifloc.getName()));
                String editorName = this.getEditorInput().getName();
                FileEditorInput fileEditorInput = (FileEditorInput)this.getEditorInput();
                new VcdDiagramReader().read(this, fileEditorInput.getStorage().getContents(), editorName, this._colorSettings);
                if (this._vcdModel == null) {
                    return;
                }
            } else {
                this._isSimulation = true;
                ErrorConsole.printOKln((String)"VCD : Simulation ");
                this._vcdModel = vcdFromBackend;
                if (this._vcdModel == null) {
                    this._vcdModel = new VCDDefinitions();
                    this._vcdModel.setScope(new ScopeCommand(ScopeType.module, "default"));
                }
                Collector.drawInEditor((IVcdDiagram)this, (VCDDefinitions)this._vcdModel, (VcdColorPreferences)this._colorSettings);
                this._vcdModel.setFactory(this._vcdFactory);
            }
            if (this._vcdModel != null) {
                this._vcdModel.setVcdfolder(ifloc.getParent());
            }
        }
        catch (Throwable ex) {
            ErrorConsole.printError((Throwable)ex, (String)"---> Read/Init Error");
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        if (this._vcdModel.getFactory() == null) {
            this._vcdModel.setFactory(this.getVcdFactory());
        }
        this.getVcdFactory().setVcdZoom(this._vcdZoom);
        this.getVcdFactory().setVcdDef(this._vcdModel);
        this._constraintsFactory = new ConstraintsFactory(this._listConnections, (IVcd)this);
        for (IConstraintData constraintData : this._vcdModel.getConstraintList()) {
            if (constraintData.getConstraints() == null) continue;
            constraintData.getConstraints().setVcdFactory(this._vcdModel.getFactory());
            constraintData.getConstraints().setList(this._listConnections);
            constraintData.getConstraints().setIcc((IConstructContraint)this._constraintsFactory);
        }
        this._markerFactory = new MarkerFactory(this._listConnections, (IVcdDiagram)this);
        this._figureCanvasBase.makeVcd(this.getContainer(), this._isSimulation);
        if (this._figureCanvasBase.getComposite() != null) {
            this._figureCanvasBase.getComposite().getVerticalBar().setVisible(true);
            this._figureCanvasBase.getComposite().getHorizontalBar().setVisible(true);
        }
        this.addPage(0, (Control)this._figureCanvasBase.getComposite());
        this.setPageText(0, "Vcd Viewer");
        this.create();
        this._figureCanvasBase.scrollUpdate();
        this._figureCanvasBase.layoutall();
        this.setGhostMode(this._ghostMode);
    }

    void createPage1() {
        try {
            FileEditorInput iep = (FileEditorInput)this.getEditorInput();
            IFile ifloc = iep.getFile();
            System.out.println(String.valueOf(ifloc.getName()) + " " + ifloc.getParent());
            ifloc.getParent().refreshLocal(1, null);
            if (!ifloc.exists()) {
                return;
            }
            this._vcdTextEditor = new VCDTextEditor(this.getVcdmenu(), !this._isSimulation);
            int index = this.addPage((IEditorPart)this._vcdTextEditor, (IEditorInput)iep);
            this.setPageText(index, this._vcdTextEditor.getTitle());
        }
        catch (Exception ex) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", (String)ex.getMessage(), null);
            ErrorConsole.printError((Throwable)ex);
        }
    }

    protected void createPages() {
        this.createPage0();
        this.createPage1();
        this.pageChange(0);
        this.setActivePage(0);
        this.setFocus();
    }

    public void print() {
        this._figureCanvasBase.printer(this.getTitle());
    }

    public void vcdMultiPageEditorRefresh() {
        try {
            IEditorActionBarContributor contributor;
            if (this.isdisposed) {
                return;
            }
            ErrorConsole.println((String)("Reload " + this.getTitle()));
            CountFigure.disp();
            if (this._colorSettings != null) {
                this._colorSettings.updatecolor();
            }
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            if (this.getMyShell().isDisposed()) {
                return;
            }
            if (this._vcdZoom != null) {
                this._vcdZoom.unSetVdt();
            }
            VcdMultiPageEditor.setFile(null);
            IFile ifloc = ((FileEditorInput)this.getEditorInput()).getFile();
            ifloc.getParent().refreshLocal(0, null);
            if (this.getPageCount() > 0) {
                this.removePage(0);
            }
            if (this.getPageCount() == 1) {
                this.removePage(0);
            }
            ToolBarAPi.getDef().unsetCurrentVcd(this);
            if (this._vcdModel != null && ConstraintView.exist()) {
                ConstraintView.getCurrentConstraintView().unsetConstraint(this._vcdModel.getConstraintList());
            }
            if ((contributor = this.getEditorSite().getActionBarContributor()) != null && contributor instanceof VcdMultiPageEditorContributor) {
                ((VcdMultiPageEditorContributor)contributor).unsetEditor(null);
            }
            if (this._listConnections != null) {
                this._listConnections.clearAll();
            }
            if (this._traceCollector != null) {
                this._traceCollector.clear();
            }
            if (this._vcdFactory != null) {
                this._vcdFactory.clear();
            }
            if (this._vcdModel != null) {
                this._vcdModel.getArraylistSimulationCommand().clear();
                this._vcdModel.getArraylistDeclarationCommand().clear();
                this._vcdModel.getConstraintCommentCommand().clear();
                this._vcdModel.setScope(null);
            }
            if (this._vcdTextEditor != null) {
                this._vcdTextEditor.removemenu();
                this._vcdTextEditor.dispose();
            }
            if (this._vcdMultiPageEditorContributor != null) {
                this._vcdMultiPageEditorContributor.dispose();
            }
            if (this._figureCanvasBase != null) {
                this._figureCanvasBase.dispose();
            }
            this._figureCanvasBase = null;
            this._vcdMultiPageEditorContributor = null;
            this._vcdModel = null;
            this._vcdFactory = null;
            this._traceCollector = null;
            this._vcdMenu = new VcdMenu((IVcdDiagram)this);
            this._listConnections = this.createList();
            this._vcdZoom = new VcdZoom(this._listConnections, (IVcdDiagram)this);
            this._figureCanvasBase = new FigureCanvasBase((IVcd)this, this._colorSettings);
            this.createPage0();
            this.createPage1();
            this._figureCanvasBase.getComposite().setFocus();
            this._vcdZoom.setIczoom(ToolBarAPi.getDef().getCombozoom());
            this._vcdZoom.applyScrollZoom();
            this._vcdTextEditor = null;
            ToolBarAPi.getDef().setCurrentVcd(this);
            ConstraintView.getCurrentConstraintView().setFocus();
            ConstraintView.getCurrentConstraintView().resetConstraint(this._vcdModel.getConstraintList());
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        catch (Throwable ex) {
            ErrorConsole.printError((Throwable)ex);
        }
    }

    public void dispose() {
        try {
            CountFigure.disp();
            this.isdisposed = true;
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            ToolBarAPi.getDef().unsetCurrentVcd(this);
            if (this._vcdModel != null) {
                if (ConstraintView.exist()) {
                    ConstraintView.getCurrentConstraintView().unsetConstraint(this._vcdModel.getConstraintList());
                }
                this._vcdModel.getConstraintList().clear();
            }
            this._figureCanvasBase.dispose();
            this._vcdZoom.unSetVdt();
            IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
            if (contributor != null && contributor instanceof VcdMultiPageEditorContributor) {
                ((VcdMultiPageEditorContributor)contributor).unsetEditor(null);
            }
            this._listConnections.clearAll();
            this._traceCollector.clear();
            this._vcdFactory.clear();
            if (this._vcdModel != null) {
                this._vcdModel.getArraylistSimulationCommand().clear();
                for (IDeclarationCommand idc : this._vcdModel.getArraylistDeclarationCommand()) {
                    if (idc == null) continue;
                    idc.clear();
                }
                this._vcdModel.getArraylistDeclarationCommand().clear();
                this._vcdModel.getConstraintCommentCommand().clear();
                this._vcdModel.setScope(null);
            }
            if (this._vcdTextEditor != null) {
                this._vcdTextEditor.removemenu();
                this._vcdTextEditor.dispose();
            }
            if (this._vcdMultiPageEditorContributor != null) {
                this._vcdMultiPageEditorContributor.dispose();
            }
            if (this._vcdMenu != null) {
                this._vcdMenu.clear();
            }
            this._vcdMultiPageEditorContributor = null;
            this._vcdModel = null;
            this._colorSettings = null;
            this._vcdFactory = null;
            this._constraintsFactory = null;
            this._listConnections = null;
            this._markerFactory = null;
            this._figureCanvasBase = null;
            this._vcdZoom = null;
            this._vcdMenu = null;
            this._traceCollector = null;
            this._vcdTextEditor = null;
            CountFigure.disp();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.dispose();
    }

    protected void finalize() throws Throwable {
        ConstraintView.refreshCourant();
        System.out.println("Delete VCDEditor");
        CountFigure.disp();
        ErrorConsole.printOKln((String)"Delete VCDEditor");
        super.finalize();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getPageCount() > 2 && this.getEditor(1) != null) {
            this.getEditor(1).doSave(monitor);
        }
        if (this._vcdTextEditor != null) {
            this._vcdTextEditor.doSave(monitor);
            if (!this.isdisposed) {
                this.setPageText(1, this._vcdTextEditor.getTitle());
            }
            this.setInput(this._vcdTextEditor.getEditorInput());
        }
        if (this.isdisposed) {
            return;
        }
        this.removePage(0);
        this.createPage0();
    }

    public void doSaveAs() {
        if (this.getEditor(0) != null) {
            this.getEditor(0).doSaveAs();
        }
        if (this._vcdTextEditor != null) {
            this._vcdTextEditor.doSaveAs();
            this.setPageText(1, this._vcdTextEditor.getTitle());
            this.setInput(this._vcdTextEditor.getEditorInput());
        }
    }

    public FigureCanvas getCanvas() {
        return this._figureCanvasBase.getClockCanvas();
    }

    public ConstraintsFactory getConstraintsFactory() {
        return this._constraintsFactory;
    }

    public MarkerFactory getMarkerFactory() {
        return this._markerFactory;
    }

    public VcdFactory getVcdFactory() {
        return this._vcdFactory;
    }

    public boolean isContainGhost() {
        if (this.getTraceCollector() == null) {
            return false;
        }
        return this.getTraceCollector().isContainGhost();
    }

    public ListConnections getListConnections() {
        return this._listConnections;
    }

    public FigureCanvasBase getfcb() {
        return this._figureCanvasBase;
    }

    public double getMarkerZoom() {
        return this._markerZoomValue;
    }

    public Shell getMyShell() {
        return this._shell;
    }

    public FigureCanvas getNames() {
        return this._figureCanvasBase.getNames();
    }

    public FigureCanvas getScaleCanvas() {
        return this._figureCanvasBase.getScaleCanvas();
    }

    public ToolBar getToolbar() {
        return this._figureCanvasBase.getToolbar();
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isCtrlKey() {
        return this._ctrlKey;
    }

    public Mode isGhostMode() {
        return this._ghostMode;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSimulation() {
        return this._isSimulation;
    }

    public final int getActivePageID() {
        return this._activePageNumber;
    }

    public final VCDTextEditor getTextEditor() {
        return this._vcdTextEditor;
    }

    protected void pageChange(int newPageIndex) {
        this._activePageNumber = newPageIndex;
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)contributor).setActivePage((IEditorPart)this);
        }
        if (this.getEditor(newPageIndex) != null) {
            super.pageChange(newPageIndex);
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = VcdMultiPageEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)VcdMultiPageEditor.this._vcdTextEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(VcdMultiPageEditor.this._vcdTextEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public void setCtrlKey(boolean ctrlKey) {
        this._ctrlKey = ctrlKey;
    }

    public void setVcdFactory(VcdFactory _vcdFactory) {
        this._vcdFactory = _vcdFactory;
    }

    public void setGhostMode(Mode _ghostMode) {
        if (_ghostMode == null) {
            return;
        }
        if (_ghostMode.isShow()) {
            if (this.getConstraintsFactory() != null) {
                this.getConstraintsFactory().showAllGhost();
            }
            if (this._vcdMenu != null) {
                this._vcdMenu.setGhostSelected(Mode.show);
            }
            this.getTraceCollector().ghostMode(true);
        }
        if (_ghostMode.isHide()) {
            if (this.getConstraintsFactory() != null) {
                this.getConstraintsFactory().hideAllGhost();
            }
            if (this._vcdMenu != null) {
                this._vcdMenu.setGhostSelected(Mode.hide);
            }
            this.getTraceCollector().ghostMode(false);
        }
        this._ghostMode = _ghostMode;
    }

    public void setMarkerZoom(double markerZoom) {
        this._markerZoomValue = markerZoom;
    }

    public void setSimulation(boolean simulation) {
        this._isSimulation = simulation;
    }

    public void setTc(TraceCollector _traceCollector) {
        this._traceCollector = _traceCollector;
    }

    public TraceCollector getTraceCollector() {
        return this._traceCollector;
    }

    public void setTcZoom(double _traceCollectorZoomValue) {
        this._traceCollectorZoomValue = _traceCollectorZoomValue;
    }

    public double getTraceZoomValue() {
        return this._traceCollectorZoomValue;
    }

    public void setVcdModel(VCDDefinitions _vcdDefinitions) {
        this._vcdModel = _vcdDefinitions;
    }

    public VCDDefinitions getVcdModel() {
        return this._vcdModel;
    }

    public void setZoomValue(double zoom) {
        this._zoomValue = zoom;
    }

    public double getZoomValue() {
        return this._zoomValue;
    }

    public VcdZoom getVcdzoom() {
        return this._vcdZoom;
    }

    public int update(int n1, int n2, boolean b) {
        return 0;
    }

    public int update2(int n1, int n2, boolean b) {
        if (this._figureCanvasBase != null) {
            return this._figureCanvasBase.update2(n1, n2, b);
        }
        return 0;
    }

    public static VcdMultiPageEditor createNewVcdMultiPageEditor(VCDDefinitions vcdModel, IFile f, VcdColorPreferences colorPrefs) {
        try {
            vcdFromBackend = vcdModel;
            _colorSettingsFromBackend = colorPrefs;
            VcdMultiPageEditor.setFile(f);
            IWorkbench _iWorkbench = PlatformUI.getWorkbench();
            _iWorkbench.getActiveWorkbenchWindow();
            IEditorPart editorInput = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)f);
            editorInput.getEditorSite().getPart().setFocus();
            VcdMultiPageEditor _vcdMultiPageEditor = (VcdMultiPageEditor)editorInput;
            _vcdMultiPageEditor.setGhostMode(Mode.show);
            vcdFromBackend = null;
            VcdMultiPageEditor.setFile(null);
            _colorSettingsFromBackend = null;
            return _vcdMultiPageEditor;
        }
        catch (PartInitException ex) {
            ErrorConsole.printError((Throwable)ex, (String)"PartInitException");
        }
        catch (Throwable ex) {
            ErrorConsole.printError((Throwable)ex);
        }
        vcdFromBackend = null;
        VcdMultiPageEditor.setFile(null);
        _colorSettingsFromBackend = null;
        return null;
    }
}

