/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.extended;

import fr.kairos.timesquare.ccsl.IConstraint;
import fr.kairos.timesquare.ccsl.IDefinition;
import fr.kairos.timesquare.ccsl.IRelation;
import fr.kairos.timesquare.ccsl.ISpecification;
import fr.kairos.timesquare.ccsl.extended.Definition;
import fr.kairos.timesquare.ccsl.extended.Relation;
import fr.kairos.timesquare.ccsl.extended.StringExpression;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class XCCSLBuilder
implements ISpecification {
    private Set<String> clocks = new HashSet<String>();
    private ArrayList<IConstraint> constraints = new ArrayList();
    private static String[] SUPPORTED_relations = new String[]{"Subclock", "Exclusion", "Alternation", "Causality", "Precedence"};
    private static String[] SUPPORTED_expressions = new String[]{"Union", "Intersection", "Minus", "Inf", "Sup", "Periodic"};
    private Set<String> intDefs = new HashSet<String>();
    private static String[] periods = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"};

    @Override
    public void addClock(String name) {
        this.clocks.add(name);
    }

    private void addRelation(IRelation relation) {
        switch (relation.getConstraintName()) {
            case "Subclock": {
                this.constraints.add(new Relation("SubClock", "LeftClock -> " + relation.getLeft(), "RightClock -> " + relation.getRight()));
                break;
            }
            case "Exclusion": {
                this.constraints.add(new Relation("Exclusion", "Clock1 -> " + relation.getLeft(), "Clock2 -> " + relation.getRight()));
                break;
            }
            case "Causality": {
                int min = relation.getIntParam("min", 0);
                int max = relation.getIntParam("max", -1);
                if (min != 0 || max != -1) {
                    System.err.println("Ignore min/max:" + min + " " + max);
                }
                this.constraints.add(new Relation("Causes", "LeftClock -> " + relation.getLeft(), "RightClock -> " + relation.getRight()));
                break;
            }
            case "Precedence": {
                int min = relation.getIntParam("min", 0);
                int max = relation.getIntParam("max", -1);
                if (min == 0 && max == 1) {
                    this.alternates(relation);
                    break;
                }
                if (min != 0 || max != -1) {
                    System.err.println("Ignore min/max:" + min + " " + max);
                }
                this.constraints.add(new Relation("Precedes", "LeftClock -> " + relation.getLeft(), "RightClock -> " + relation.getRight()));
                break;
            }
            case "Alternation": {
                this.alternates(relation);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported relation " + relation);
            }
        }
    }

    private void alternates(IRelation relation) {
        this.constraints.add(new Relation("Alternates", "AlternatesLeftClock -> " + relation.getLeft(), "AlternatesRightClock -> " + relation.getRight()));
    }

    @Override
    public void add(IConstraint constraint) {
        if (constraint instanceof IRelation) {
            this.addRelation((IRelation)constraint);
        } else if (constraint instanceof IDefinition) {
            this.addDefinition((IDefinition)constraint);
        }
    }

    private void addDefinition(IDefinition definition) {
        switch (definition.getConstraintName()) {
            case "Inf": 
            case "Sup": 
            case "Union": 
            case "Intersection": {
                this.build(definition);
                break;
            }
            case "Minus": {
                this.build(definition, "MinusLeftClock", "MinusRightClock");
                break;
            }
            case "Periodic": {
                int period = definition.getIntParam("period", 1);
                int from = definition.getIntParam("from", 0);
                int upto = definition.getIntParam("upto", -1);
                String defClk = definition.getDefinedClock();
                String base = definition.getRefClocks()[0];
                if (upto != -1) {
                    this.constraints.add(new StringExpression("Wait", String.valueOf(base) + "_w", "WaitingClock -> " + base, "WaitingValue -> " + this.addInt(upto + period)));
                    this.constraints.add(new StringExpression("UpTo", String.valueOf(base) + "_u", "ClockToFollow -> " + base, "KillerCLock -> " + base + "_w"));
                    base = String.valueOf(base) + "_u";
                }
                String p = this.addInt(period);
                String o = this.addInt(from);
                this.constraints.add(new StringExpression("Periodic", defClk, "PeriodicBaseClock -> " + base, "PeriodicPeriod -> " + p, "PeriodicOffset -> " + o));
                break;
            }
            case "DelayFor": {
                String base;
                int from = definition.getIntParam("from", 0);
                int upto = definition.getIntParam("upto", -1);
                String b = base = definition.getRefClocks()[0];
                String defClk = definition.getDefinedClock();
                if (upto != -1) {
                    this.constraints.add(new StringExpression("Wait", String.valueOf(defClk) + "_w", "WaitingClock -> " + base, "WaitingValue -> " + this.addInt(upto)));
                    this.constraints.add(new StringExpression("UpTo", String.valueOf(defClk) + "_u", "ClockToFollow -> " + base, "KillerCLock -> " + defClk + "_w"));
                    b = String.valueOf(defClk) + "_u";
                }
                if (definition.getRefClocks().length > 1) {
                    base = definition.getRefClocks()[1];
                }
                if (base != b && from == 0) {
                    this.constraints.add(new StringExpression("SampledOn", defClk, "SampledOnSampledClock -> " + b, "SampledOnTrigger -> " + base));
                    break;
                }
                this.constraints.add(new StringExpression("DelayFor", defClk, "DelayForClockToDelay -> " + b, "DelayForClockForCounting -> " + base, "DelayForDelay -> " + this.addInt(from)));
                break;
            }
            default: {
                throw new RuntimeException("Unsupported definition " + definition);
            }
        }
    }

    private String addInt(int v) {
        if (v < 11) {
            return periods[v];
        }
        String name = "_" + v;
        this.intDefs.add("Integer " + name + ":int = " + v);
        return name;
    }

    private void build(IDefinition definition, String left, String right) {
        this.buildOther(definition.getConstraintName(), definition.getDefinedClock(), left, right, definition.getRefClocks());
    }

    private void buildOther(String cName, String def, String left, String right, String ... clocks) {
        String r = clocks[1];
        if (clocks.length > 2) {
            String newDef = String.valueOf(def) + "_0";
            this.buildOther(cName, newDef, left, right, Arrays.copyOfRange(clocks, 1, clocks.length));
            r = newDef;
        }
        this.constraints.add(new Definition(cName, def, String.valueOf(left) + " -> " + clocks[0], String.valueOf(right) + " -> " + r));
    }

    private void build(IDefinition definition) {
        this.build(definition, "Clock1", "Clock2");
    }

    @Override
    public boolean isConstraintSupported(String name) {
        String s;
        String[] stringArray = SUPPORTED_relations;
        int n = SUPPORTED_relations.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(name)) {
                return true;
            }
            ++n2;
        }
        stringArray = SUPPORTED_expressions;
        n = SUPPORTED_expressions.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void print(Writer wr, String name) {
        PrintWriter pw = new PrintWriter(wr);
        pw.println("ClockConstraintSystem " + name + " {");
        pw.println("    imports {");
        pw.println("\t\timport \"platform:/plugin/fr.inria.aoste.timesquare.ccslkernel.model/ccsllibrary/kernel.ccslLib\" as lib0;");
        pw.println("\t\timport \"platform:/plugin/fr.inria.aoste.timesquare.ccslkernel.model/ccsllibrary/CCSL.ccslLib\" as lib1;");
        pw.println("    }");
        pw.println("    entryBlock main");
        pw.println();
        pw.println("    Block main {");
        for (String clock : this.clocks) {
            pw.println("\t\tClock " + clock);
        }
        pw.println();
        for (String def : this.intDefs) {
            pw.println("\t\t" + def);
        }
        pw.println();
        for (IConstraint cons : this.constraints) {
            pw.println("        " + cons);
        }
        pw.println("\t}");
        pw.println("}");
        pw.close();
    }

    public void printTo(String name, File path) throws IOException {
        if (!path.exists()) {
            throw new RuntimeException("Path " + path + " does not exist. Should create before calling");
        }
        File f = new File(path, String.valueOf(name) + ".extendedCCSL");
        FileWriter fw = new FileWriter(f);
        this.print(fw, name);
        fw.close();
    }
}

