/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.sat;

import fr.kairos.timesquare.ccsl.adapters.SimpleToGeneric;
import fr.kairos.timesquare.ccsl.sat.Clock;
import fr.kairos.timesquare.ccsl.sat.ClockCollector;
import fr.kairos.timesquare.ccsl.sat.ClockStatus;
import fr.kairos.timesquare.ccsl.sat.IClock;
import fr.kairos.timesquare.ccsl.sat.IClockBuilder;
import fr.kairos.timesquare.ccsl.sat.IClockManager;
import fr.kairos.timesquare.ccsl.sat.ISATSolver;
import fr.kairos.timesquare.ccsl.sat.ISATSolverBuilder;
import fr.kairos.timesquare.ccsl.sat.IStep;
import fr.kairos.timesquare.ccsl.sat.SemanticBuilder;
import fr.kairos.timesquare.ccsl.sat.StepIterableFilter;
import fr.kairos.timesquare.ccsl.simple.ISpecificationBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;

public class SATSolver
implements IClockManager,
IClockBuilder {
    private ISpecificationBuilder specBuilder;
    private ISATSolverBuilder solverBuilder;
    private ClockCollector collector;
    private int current = 0;

    public SATSolver(ISATSolverBuilder solverBuilder, ISpecificationBuilder specBuilder) {
        this(solverBuilder, specBuilder, null);
    }

    public SATSolver(ISATSolverBuilder solverBuilder, ISpecificationBuilder specBuilder, IClockBuilder clockBuilder) {
        this.specBuilder = specBuilder;
        this.solverBuilder = solverBuilder;
        this.collector = new ClockCollector(clockBuilder == null ? this : clockBuilder);
        specBuilder.build(new SimpleToGeneric(this.collector));
    }

    @Override
    public IClock buildClock(String name) {
        return new Clock();
    }

    @Override
    public IClock clock(String clock) {
        return this.collector.nameToClock(clock);
    }

    private IClock clock(int id) {
        return this.collector.idToClock(id);
    }

    private void tick(Scanner sc, IStep step) throws IOException {
        for (int clock : new StepIterableFilter(ClockStatus.Must, step)) {
            this.clock(clock).tick(this.current);
        }
        for (int i : new StepIterableFilter(ClockStatus.May, step)) {
            if (sc == null || !sc.hasNextInt()) break;
            if (sc.nextInt() != 1) continue;
            this.clock(i).tick(this.current);
        }
        ++this.current;
    }

    void printTrace(int nbStep) {
        System.out.print("clock    | ");
        int i = 0;
        while (i < nbStep) {
            System.out.printf("%3d", i);
            ++i;
        }
        System.out.println();
        int id = 0;
        for (IClock c : this.collector) {
            System.out.printf("%8s | ", this.collector.getNameFromId(id));
            System.out.println(c.toString());
            ++id;
        }
    }

    private List<IStep> printAllSolutions(ISATSolver boolSpec) throws Exception {
        List<IStep> solutions = boolSpec.allSolutions();
        boolean unsat = true;
        int nb = 1;
        for (IStep solution : solutions) {
            unsat = false;
            System.out.printf("%2d:", nb++);
            int i = 0;
            for (IClock clock : this.collector) {
                switch (solution.status(i)) {
                    case Cannot: {
                        System.out.print(" !");
                        break;
                    }
                    case Must: {
                        System.out.print("  ");
                        break;
                    }
                    case May: {
                        System.out.print(" ?");
                    }
                }
                System.out.print(this.collector.getNameFromId(i));
                ++i;
            }
            System.out.println();
        }
        if (unsat) {
            System.out.println("UNSAT");
        }
        return solutions;
    }

    void step(boolean debug) throws Exception {
        ISATSolver boolSpec = this.solverBuilder.build();
        boolSpec.setNameMapper(this.collector);
        SemanticBuilder simple = new SemanticBuilder(boolSpec, this);
        this.specBuilder.build(simple);
        IStep sol = boolSpec.pickOneSolution();
        if (debug) {
            System.out.println(String.valueOf(this.current) + ": ");
            this.printAllSolutions(boolSpec);
        }
        this.tick(null, sol);
    }

    public void stepAndPrint(int nbStep, boolean debug) throws Exception {
        int i = 0;
        while (i < nbStep) {
            this.step(debug);
            ++i;
        }
        this.printTrace(nbStep);
    }

    private ISATSolver iStep() {
        ISATSolver boolSpec = this.solverBuilder.build();
        boolSpec.setNameMapper(this.collector);
        SemanticBuilder simple = new SemanticBuilder(boolSpec, this);
        this.specBuilder.build(simple);
        return boolSpec;
    }

    public int interactiveStep() throws Exception {
        int nbStep = 0;
        Scanner sc = new Scanner(System.in);
        sc.useDelimiter("\\s*");
        while (true) {
            ISATSolver boolSpec = this.iStep();
            System.out.println(" 0: stop");
            List<IStep> solutions = this.printAllSolutions(boolSpec);
            System.out.println(String.valueOf(solutions.size()) + " solutions. pick one ?");
            String line = sc.nextLine();
            Scanner sLine = new Scanner(line);
            int v = sLine.nextInt();
            if (v < 1 || v > solutions.size()) break;
            IStep solution = solutions.get(v - 1);
            ++nbStep;
            this.tick(sLine, solution);
        }
        sc.close();
        this.printTrace(nbStep);
        return nbStep;
    }
}

