/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.query;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IOvalAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.CompositeLayout;
import org.eclipse.sirius.diagram.description.Layout;
import org.eclipse.sirius.diagram.description.OrderedTreeLayout;
import org.eclipse.sirius.diagram.ui.business.api.query.EdgeQuery;

public class ConnectionEditPartQuery {
    private ConnectionEditPart connectionEditPart;

    public ConnectionEditPartQuery(ConnectionEditPart connectionEditPart) {
        this.connectionEditPart = connectionEditPart;
    }

    public boolean isLayoutComponent() {
        Diagram diagram;
        boolean isLayoutComponent = false;
        if (this.isEdgeWithTreeRoutingStyle() && (diagram = this.getDiagram()) != null && diagram.getElement() instanceof DSemanticDiagram) {
            DSemanticDiagram dSemanticDiagram = (DSemanticDiagram)diagram.getElement();
            Layout layout = dSemanticDiagram.getDescription().getLayout();
            isLayoutComponent = this.isOrderedTreeLayoutOrComponentLayout(layout);
        }
        return isLayoutComponent;
    }

    public boolean isEdgeWithTreeRoutingStyle() {
        boolean isEdgeTreeRoutingStyle = false;
        if (this.connectionEditPart.getModel() instanceof Edge) {
            isEdgeTreeRoutingStyle = new EdgeQuery((Edge)this.connectionEditPart.getModel()).isEdgeWithTreeRoutingStyle();
        }
        return isEdgeTreeRoutingStyle;
    }

    public boolean isEdgeWithRectilinearRoutingStyle() {
        boolean isEdgeWithRectilinearRoutingStyle = false;
        if (this.connectionEditPart.getModel() instanceof Edge) {
            isEdgeWithRectilinearRoutingStyle = new EdgeQuery((Edge)this.connectionEditPart.getModel()).isEdgeWithRectilinearRoutingStyle();
        }
        return isEdgeWithRectilinearRoutingStyle;
    }

    public boolean isEdgeWithObliqueRoutingStyle() {
        boolean isEdgeWithObliqueRoutingStyle = false;
        if (this.connectionEditPart.getModel() instanceof Edge) {
            isEdgeWithObliqueRoutingStyle = new EdgeQuery((Edge)this.connectionEditPart.getModel()).isEdgeWithObliqueRoutingStyle();
        }
        return isEdgeWithObliqueRoutingStyle;
    }

    private Diagram getDiagram() {
        DiagramEditPart diagramEditPart;
        DiagramRootEditPart diagramRootEditPart;
        Diagram diagram = null;
        if (this.connectionEditPart.getParent() instanceof DiagramRootEditPart && (diagramRootEditPart = (DiagramRootEditPart)this.connectionEditPart.getParent()).getChildren().get(0) instanceof DiagramEditPart && (diagramEditPart = (DiagramEditPart)diagramRootEditPart.getChildren().get(0)).getModel() instanceof Diagram) {
            diagram = (Diagram)diagramEditPart.getModel();
        }
        return diagram;
    }

    private boolean isOrderedTreeLayoutOrComponentLayout(Layout layout) {
        boolean isLayout = false;
        if (layout instanceof OrderedTreeLayout || layout instanceof CompositeLayout) {
            isLayout = layout instanceof CompositeLayout ? true : true;
        }
        return isLayout;
    }

    public boolean checkShapesIntersect() {
        Connection conn;
        boolean result = false;
        if (this.connectionEditPart instanceof AbstractConnectionEditPart && (conn = ((AbstractConnectionEditPart)this.connectionEditPart).getConnectionFigure()).getSourceAnchor().getOwner() != null && !(conn.getSourceAnchor().getOwner() instanceof Connection) && conn.getTargetAnchor().getOwner() != null && !(conn.getTargetAnchor().getOwner() instanceof Connection)) {
            PrecisionRectangle sourceBounds = this.getShapeBounds(conn.getSourceAnchor().getOwner());
            PrecisionRectangle targetBounds = this.getShapeBounds(conn.getTargetAnchor().getOwner());
            conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)sourceBounds);
            conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)targetBounds);
            if (sourceBounds.intersects((Rectangle)targetBounds) && !sourceBounds.contains((Rectangle)targetBounds) && !targetBounds.contains((Rectangle)sourceBounds) || sourceBounds.equals((Object)targetBounds)) {
                result = true;
            }
        }
        return result;
    }

    private PrecisionRectangle getShapeBounds(IFigure figure) {
        PrecisionRectangle result = new PrecisionRectangle(figure.getBounds());
        if (figure instanceof IOvalAnchorableFigure) {
            result = new PrecisionRectangle(((IOvalAnchorableFigure)figure).getOvalBounds());
        } else if (figure instanceof IPolygonAnchorableFigure) {
            result = new PrecisionRectangle(((IPolygonAnchorableFigure)figure).getPolygonPoints().getBounds());
        }
        return result;
    }
}

