/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.AbstractTabbarFiller;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.contributions.TabbarContributionFactory;
import org.eclipse.ui.IWorkbenchPage;

public class TabbarFillerWithContributions
extends AbstractTabbarFiller {
    private static final String SHOWING_MODE_SYSTEM_PROPERTY = "org.eclipse.sirius.ui.activateShowingMode";
    private static final String ARRANGE_SELECTION = "org.eclipse.sirius.diagram.ui.tabbar.arrangeselection";
    private static final String REFRESH = "org.eclipse.sirius.diagram.ui.tabbar.refresh";
    private static final String LAYER_FILTER = "org.eclipse.sirius.diagram.ui.tabbar.layerfilter";
    private static final String HIDE_PIN = "org.eclipse.sirius.diagram.ui.tabbar.hidepin";
    private static final String PAST = "org.eclipse.sirius.diagram.ui.tabbar.past";
    private static final String HIDE_DELETE = "org.eclipse.sirius.diagram.ui.tabbar.hidedelete";
    private static final String ZOOM = "org.eclipse.sirius.diagram.ui.tabbar.zoom";
    private static final String EXPORT = "org.eclipse.sirius.diagram.ui.tabbar.export";
    private static final String FONT = "org.eclipse.sirius.diagram.ui.tabbar.font";
    private static final String STYLE = "org.eclipse.sirius.diagram.ui.tabbar.style";
    private static final String SIZE = "org.eclipse.sirius.diagram.ui.tabbar.size";
    private List<IContributionItem> dynamicContributions = new ArrayList<IContributionItem>();
    private ArrayList<IContributionItem> diagramContributionItems = new ArrayList();
    private ArrayList<IContributionItem> diagramElementContributionItems = new ArrayList();
    private TabbarContributionFactory contributionFactory = new TabbarContributionFactory();

    public TabbarFillerWithContributions(ToolBarManager manager, IWorkbenchPage page) {
        super(manager, page);
    }

    @Override
    protected void doFill() {
        this.configureGroupSeparators();
        this.addDiagramContributionItems();
        this.addDiagramElementContributionItems();
        this.refreshItemsVisibility(null);
        ArrayList<IContributionItem> currentContributions = new ArrayList<IContributionItem>(Arrays.asList(this.manager.getItems()));
        this.addTabbarContributions();
        this.dynamicContributions = new ArrayList<IContributionItem>(Arrays.asList(this.manager.getItems()));
        this.dynamicContributions.removeAll(currentContributions);
        this.update(null);
    }

    @Override
    public void update(ISelection iSelection) {
        this.refreshItemsVisibility(iSelection);
        this.manager.update(true);
    }

    protected void refreshItemsVisibility(ISelection selection) {
        List<IContributionItem> existingItems = Arrays.asList(this.manager.getItems());
        for (IContributionItem current : existingItems) {
            if (this.dynamicContributions.contains(current) || current.isSeparator()) continue;
            current.setVisible(false);
        }
        List<IContributionItem> contributionItems = this.getContributionItems(selection);
        for (IContributionItem item : contributionItems) {
            if (!existingItems.contains(item)) continue;
            item.setVisible(true);
        }
    }

    private List<IContributionItem> getContributionItems(ISelection selection) {
        Object firstElement;
        ArrayList<IContributionItem> contributedItems = this.diagramContributionItems;
        if (selection instanceof IStructuredSelection && !((firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof AbstractDDiagramEditPart)) {
            contributedItems = this.diagramElementContributionItems;
        }
        return contributedItems;
    }

    private void configureGroupSeparators() {
        this.initSeparator(ARRANGE_SELECTION);
        this.initSeparator(REFRESH);
        this.initSeparator(LAYER_FILTER);
        this.initSeparator(HIDE_PIN);
        this.initSeparator(PAST);
        this.initSeparator(HIDE_DELETE);
        this.initSeparator(ZOOM);
        this.initSeparator(EXPORT);
        this.initSeparator(FONT);
        this.initSeparator(STYLE);
        this.initSeparator(SIZE);
    }

    private void initSeparator(String name) {
        Separator contributionItem = new Separator(name);
        this.manager.add((IContributionItem)contributionItem);
    }

    private void addDiagramContributionItems() {
        if (Boolean.getBoolean("org.eclipse.sirius.experimental.popupMenuImprovement")) {
            this.addContributionItem(this.diagramContributionItems, ARRANGE_SELECTION, this.contributionFactory.createSelectAllContribution(this.part, this.manager));
        } else {
            this.addContributionItem(this.diagramContributionItems, ARRANGE_SELECTION, this.contributionFactory.createSelectMenuManager());
        }
        this.addContributionItem(this.diagramContributionItems, ARRANGE_SELECTION, this.contributionFactory.createArrangeMenuManager(this.part));
        this.addContributionItem(this.diagramContributionItems, REFRESH, this.contributionFactory.createRefreshContribution());
        this.addContributionItem(this.diagramContributionItems, LAYER_FILTER, this.contributionFactory.createConcernContribution(this.part));
        this.addContributionItem(this.diagramContributionItems, LAYER_FILTER, this.contributionFactory.createFilterContribution(this.part, this.manager));
        this.addContributionItem(this.diagramContributionItems, LAYER_FILTER, this.contributionFactory.createLayerContribution(this.part, this.manager));
        this.addContributionItem(this.diagramContributionItems, HIDE_PIN, this.contributionFactory.createSelectPinnedElementsContribution(this.part));
        this.addContributionItem(this.diagramContributionItems, HIDE_PIN, this.contributionFactory.createSelectHiddenElementsContribution(this.part));
        this.addContributionItem(this.diagramContributionItems, PAST, this.contributionFactory.createPasteFormatContribution(this.part));
        this.addContributionItem(this.diagramContributionItems, ZOOM, this.contributionFactory.createZoomContribution(this.part));
        this.addContributionItem(this.diagramContributionItems, ZOOM, this.contributionFactory.createZoomOutContribution(this.part));
        this.addContributionItem(this.diagramContributionItems, ZOOM, this.contributionFactory.createZoomInContribution(this.part));
        if (Boolean.getBoolean(SHOWING_MODE_SYSTEM_PROPERTY)) {
            this.addContributionItem(this.diagramContributionItems, EXPORT, this.contributionFactory.createShowingModeContributionItem(this.part, this.manager));
        }
        this.addContributionItem(this.diagramContributionItems, EXPORT, this.contributionFactory.createLayoutingModeContributionItem(this.part));
        this.addContributionItem(this.diagramContributionItems, EXPORT, this.contributionFactory.createSaveAsImageContributionItem());
    }

    private void addContributionItem(Collection<IContributionItem> contributionItems, String separatorName, IContributionItem contributionItem) {
        if (contributionItem != null) {
            contributionItems.add(contributionItem);
            this.manager.insertAfter(separatorName, contributionItem);
        }
    }

    private void addDiagramElementContributionItems() {
        this.addContributionItem(this.diagramElementContributionItems, ARRANGE_SELECTION, this.contributionFactory.createStraightenContribution());
        this.addContributionItem(this.diagramElementContributionItems, ARRANGE_SELECTION, this.contributionFactory.createDistributeContribution());
        this.addContributionItem(this.diagramElementContributionItems, ARRANGE_SELECTION, this.contributionFactory.createAlignMenuManager());
        this.addContributionItem(this.diagramElementContributionItems, ARRANGE_SELECTION, this.contributionFactory.createArrangeMenuManager(this.part));
        IContributionItem pinElementContributionItem = this.contributionFactory.createPinElementContribution(this.part);
        this.addContributionItem(this.diagramElementContributionItems, HIDE_PIN, this.contributionFactory.createUnPinElementContribution(this.part, pinElementContributionItem));
        this.addContributionItem(this.diagramElementContributionItems, HIDE_PIN, pinElementContributionItem);
        this.addContributionItem(this.diagramElementContributionItems, PAST, this.contributionFactory.createCopyFormatContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, HIDE_DELETE, this.contributionFactory.createDeleteFromModelContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, HIDE_DELETE, this.contributionFactory.createDeleteFromDiagramContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, HIDE_DELETE, this.contributionFactory.createHideElementContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, FONT, this.contributionFactory.createFontDialogContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, FONT, this.contributionFactory.createFontColorContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, FONT, this.contributionFactory.createItalicFontStyleContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, FONT, this.contributionFactory.createBoldFontStyleContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, STYLE, this.contributionFactory.createCopyAppearancePropertiesContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, STYLE, this.contributionFactory.createResetStylePropertyContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, STYLE, this.contributionFactory.createSetStyleToWorkspaceImageContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, STYLE, this.contributionFactory.createRouterContribution());
        this.addContributionItem(this.diagramElementContributionItems, STYLE, this.contributionFactory.createLineColorPropertyContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, STYLE, this.contributionFactory.createFillColorContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, SIZE, this.contributionFactory.createAutoSizeContribution(this.part));
        this.addContributionItem(this.diagramElementContributionItems, SIZE, this.contributionFactory.createSizeBothContribution(this.part));
    }

    @Override
    public void dispose() {
        this.releaseTabbarContributions();
        super.dispose();
    }
}

