/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.cheatsheets.CheatSheetListener;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetEvent;

public class CheatSheetManager
implements ICheatSheetManager {
    private static final String PARENT_PREFIX = "parent.";
    private static final String VARIABLE_END = "}";
    private static final String VARIABLE_BEGIN = "${";
    private String cheatsheetID;
    private List<CheatSheetListener> listeners;
    private Map<String, String> dataTable = null;
    private ICheatSheetManager parent;

    public CheatSheetManager(CheatSheetElement element) {
        this.cheatsheetID = element.getID();
        this.listeners = new ArrayList<CheatSheetListener>();
        CheatSheetListener listener = element.createListenerInstance();
        if (listener != null) {
            this.addListener(listener);
        }
    }

    @Override
    public String getCheatSheetID() {
        return this.cheatsheetID;
    }

    public void fireEvent(int eventType) {
        Iterator<CheatSheetListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            CheatSheetEvent event = new CheatSheetEvent(eventType, this.cheatsheetID, this);
            CheatSheetListener listener = iterator.next();
            listener.cheatSheetEvent(event);
        }
    }

    public Map<String, String> getData() {
        return this.dataTable;
    }

    public void setData(Map<String, String> data) {
        this.dataTable = data;
    }

    @Override
    public String getData(String key) {
        if (this.dataTable == null) {
            return null;
        }
        return this.dataTable.get(key);
    }

    public String getDataQualified(String qualifiedKey) {
        if (qualifiedKey.startsWith(PARENT_PREFIX) && this.parent != null) {
            return this.parent.getData(qualifiedKey.substring(PARENT_PREFIX.length()));
        }
        return this.getData(qualifiedKey);
    }

    public String getVariableData(String variable) {
        String result = variable;
        if (variable != null && variable.startsWith(VARIABLE_BEGIN) && variable.endsWith(VARIABLE_END)) {
            result = variable.substring(2, variable.length() - 1);
            result = this.getDataQualified(result);
        }
        return result;
    }

    public String performVariableSubstitution(String input) {
        String remaining = input;
        String output = "";
        while (remaining.length() > 0) {
            int varIndex = remaining.indexOf(VARIABLE_BEGIN);
            int endIndex = remaining.indexOf(VARIABLE_END, varIndex + 1);
            if (varIndex < 0 || endIndex < 0) {
                output = String.valueOf(output) + remaining;
                remaining = "";
                continue;
            }
            String varName = remaining.substring(varIndex + VARIABLE_BEGIN.length(), endIndex);
            String value = this.getDataQualified(varName);
            output = String.valueOf(output) + remaining.substring(0, varIndex);
            if (value != null) {
                output = String.valueOf(output) + value;
            }
            remaining = remaining.substring(endIndex + VARIABLE_END.length());
        }
        return output;
    }

    void setData(Hashtable<String, String> data) {
        this.dataTable = data;
    }

    @Override
    public void setData(String key, String data) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (data == null && this.dataTable != null) {
            this.dataTable.remove(key);
            return;
        }
        if (this.dataTable == null) {
            this.dataTable = new Hashtable<String, String>(30);
        }
        this.dataTable.put(key, data);
    }

    public void setDataQualified(String qualifiedKey, String data) {
        if (qualifiedKey == null) {
            throw new IllegalArgumentException();
        }
        if (qualifiedKey.startsWith(PARENT_PREFIX) && this.parent != null) {
            this.parent.setData(qualifiedKey.substring(PARENT_PREFIX.length()), data);
        } else {
            this.setData(qualifiedKey, data);
        }
    }

    public void addListener(CheatSheetListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public ICheatSheetManager getParent() {
        return this.parent;
    }

    public void setParent(ICheatSheetManager parent) {
        this.parent = parent;
    }

    @Override
    public Set<String> getKeySet() {
        if (this.dataTable == null) {
            return new HashSet<String>();
        }
        return this.dataTable.keySet();
    }
}

