/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.wizard;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.gendoc.wizard.AdditionnalParameterItem;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class AdditionnalParametersComposite
extends Composite {
    private static final String NAME_PROPERTY = "name";
    private static final String VALUE_PROPERTY = "value";
    private TableViewer viewer;
    private Table table;

    public AdditionnalParametersComposite(Composite parent) {
        super(parent, 0);
        this.buildControls();
    }

    protected void buildControls() {
        FillLayout compositeLayout = new FillLayout();
        this.setLayout((Layout)compositeLayout);
        this.table = new Table((Composite)this, 65536);
        this.table.setLinesVisible(true);
        this.viewer = this.buildAndLayoutTable(this.table);
        this.attachContentProvider(this.viewer);
        this.attachLabelProvider(this.viewer);
        this.attachCellEditors(this.viewer, (Composite)this.table);
    }

    private void attachLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((AdditionnalParameterItem)element).getLabel();
                    }
                    case 1: {
                        return ((AdditionnalParameterItem)element).getValue();
                    }
                }
                return "Invalid column: " + columnIndex;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener lpl) {
            }
        });
    }

    private void attachContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    private TableViewer buildAndLayoutTable(Table table) {
        TableViewer tableViewer = new TableViewer(table);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        table.setLayout((Layout)layout);
        TableColumn nameColumn = new TableColumn(table, 0x1000000);
        nameColumn.setText("Name");
        TableColumn valColumn = new TableColumn(table, 16384);
        valColumn.setText("Value");
        table.setHeaderVisible(true);
        return tableViewer;
    }

    private void attachCellEditors(final TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return !property.equals(AdditionnalParametersComposite.NAME_PROPERTY);
            }

            public Object getValue(Object element, String property) {
                if (AdditionnalParametersComposite.NAME_PROPERTY.equals(property)) {
                    return ((AdditionnalParameterItem)element).getLabel();
                }
                return ((AdditionnalParameterItem)element).getValue();
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                AdditionnalParameterItem data = (AdditionnalParameterItem)tableItem.getData();
                if (AdditionnalParametersComposite.NAME_PROPERTY.equals(property)) {
                    data.setLabel(value.toString());
                } else {
                    data.setValue(value.toString());
                }
                viewer.refresh((Object)data);
            }
        });
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor(parent), new TextCellEditor(parent)});
        viewer.setColumnProperties(new String[]{NAME_PROPERTY, VALUE_PROPERTY});
    }

    public void setInput(Map<String, String> additionnalParameters) {
        if (additionnalParameters != null) {
            Object[] inputs = new Object[additionnalParameters.size()];
            int i = 0;
            for (String s : additionnalParameters.keySet()) {
                inputs[i] = new AdditionnalParameterItem(additionnalParameters.get(s), s);
                ++i;
            }
            this.viewer.setInput((Object)inputs);
        } else {
            this.viewer.setInput(null);
        }
    }

    public List<AdditionnalParameterItem> getAdditionnalParametersValue() {
        ArrayList<AdditionnalParameterItem> items = new ArrayList<AdditionnalParameterItem>();
        Object[] params = (Object[])this.viewer.getInput();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                items.add((AdditionnalParameterItem)params[i]);
                ++i;
            }
        }
        return items;
    }
}

