/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.xlsx.cellmarkers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.xlsx.CellRef;
import org.eclipse.gendoc.document.parser.xlsx.XLSXParser;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.AbstractCellRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.CellMark;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.ICellRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.helper.XPathXlsxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CellAnchorMarker
extends AbstractCellRefMarker
implements ICellRefMarker {
    private boolean isRange = false;

    public CellAnchorMarker(String mark, String relationType, String xpath, boolean isRange) {
        super(relationType, xpath);
        this.isRange = isRange;
    }

    @Override
    public List<CellMark> getMarksToApply(XLSXParser xlsxParser) {
        Document doc = xlsxParser.getDocument();
        if (this.relationType != null) {
            try {
                XMLParser parser = xlsxParser.loadImplicitPartDocument(this.relationType);
                if (parser == null) {
                    return Collections.EMPTY_LIST;
                }
                doc = parser.getDocument();
            }
            catch (IOException e) {
                return Collections.EMPTY_LIST;
            }
        }
        try {
            ArrayList<CellMark> marks = new ArrayList<CellMark>();
            NodeList nl = XPathXlsxUtils.evaluateNodes(doc, this.xpath);
            int i = 0;
            while (i < nl.getLength()) {
                Element el = (Element)nl.item(0);
                CellRef ref = new CellRef(Integer.valueOf(XPathXlsxUtils.evaluateText(el, "xdr:from/xdr:row/text()")), Integer.valueOf(XPathXlsxUtils.evaluateText(el, "xdr:from/xdr:col/text()")));
                String elXPath = XPathXlsxUtils.getNodeXPath(el);
                marks.add(this.createMark(xlsxParser, ref, this.relationType, elXPath, 0));
                if (this.isRange) {
                    ref = new CellRef(Integer.valueOf(XPathXlsxUtils.evaluateText(el, "xdr:to/xdr:row/text()")), Integer.valueOf(XPathXlsxUtils.evaluateText(el, "xdr:to/xdr:col/text()")));
                    marks.add(this.createMark(xlsxParser, ref, this.relationType, elXPath, 0));
                }
                ++i;
            }
            return marks;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void layoutCellReference(XLSXParser xlsxParser, CellRef source, List<CellMark> targets) {
    }
}

