/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.clipboard.ui;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.glsp.ide.editor.clipboard.ClipboardService;
import org.eclipse.glsp.ide.editor.clipboard.ui.JsonTransfer;
import org.eclipse.glsp.ide.editor.utils.UIUtil;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.protocol.GLSPServer;
import org.eclipse.glsp.server.protocol.GLSPServerListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;

@Singleton
public class DisplayClipboardService
implements ClipboardService,
GLSPServerListener {
    @Inject
    protected Provider<GLSPClient> client;
    protected Clipboard clipboard;

    @Inject
    public DisplayClipboardService(GLSPServer server) {
        UIUtil.asyncExec(() -> {
            this.clipboard = new Clipboard(Display.getCurrent());
        });
        server.addListener((GLSPServerListener)this);
    }

    @Override
    public Optional<String> getClipboardContents(String type) {
        if ("application/json".equals(type)) {
            AtomicReference result = new AtomicReference();
            Display.getDefault().syncExec(() -> {
                if (Arrays.stream(this.clipboard.getAvailableTypes()).anyMatch(data -> JsonTransfer.getInstance().isSupportedType((TransferData)data))) {
                    result.set(Optional.ofNullable(this.clipboard.getContents((Transfer)JsonTransfer.getInstance())).map(String.class::cast));
                } else {
                    result.set(Optional.empty());
                }
            });
            return (Optional)result.get();
        }
        throw new IllegalArgumentException("The DisplayClipboardService only supports application/json type");
    }

    public void serverShutDown(GLSPServer glspServer) {
        this.clipboard.dispose();
    }

    @Override
    public void setClipboardContents(Map<String, String> clipboardData) {
        JsonTransfer json = JsonTransfer.getInstance();
        TextTransfer plainText = TextTransfer.getInstance();
        Object[] data = new String[clipboardData.size()];
        Transfer[] types = new Transfer[clipboardData.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : clipboardData.entrySet()) {
            String type = entry.getKey();
            String value = entry.getValue();
            data[i] = value;
            JsonTransfer jsonTransfer = types[i++] = "application/json".equals(type) ? json : plainText;
        }
        UIUtil.asyncExec(() -> this.clipboard.setContents(data, types));
    }
}

