/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.ui;

import java.net.URI;
import java.util.Optional;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.glsp.ide.editor.GLSPServerManager;
import org.eclipse.glsp.ide.editor.actions.GLSPActionProvider;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramComposite;
import org.eclipse.glsp.ide.editor.ui.GLSPIdeEditorPlugin;
import org.eclipse.glsp.ide.editor.utils.GLSPDiagramEditorMarkerUtil;
import org.eclipse.glsp.ide.editor.utils.IdeClientOptions;
import org.eclipse.glsp.ide.editor.utils.UIUtil;
import org.eclipse.glsp.server.actions.SaveModelAction;
import org.eclipse.glsp.server.actions.SelectAction;
import org.eclipse.glsp.server.disposable.DisposableCollection;
import org.eclipse.glsp.server.features.navigation.NavigateToTargetAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;

public class GLSPDiagramEditor
extends EditorPart
implements IGotoMarker,
ISelectionProvider {
    protected boolean dirty;
    protected final SelectionManager selectionListener = new SelectionManager();
    protected final DisposableCollection toDispose = new DisposableCollection();
    protected GLSPDiagramComposite diagram;

    public GLSPServerManager getServerManager() {
        Optional<GLSPServerManager> serverManager = GLSPIdeEditorPlugin.getDefault().getGLSPEditorRegistry().getGLSPServerManager(this);
        if (!serverManager.isPresent()) {
            throw new GLSPServerException("Could not retrieve GLSPServerManager. GLSP editor is not properly configured: " + this.getEditorSite().getId());
        }
        return serverManager.get();
    }

    protected Optional<GLSPActionProvider> getActionProvider() {
        return Optional.empty();
    }

    public String getEditorId() {
        return this.getConfigurationElement().getAttribute("id");
    }

    public String getClientId() {
        return this.diagram.getClientId();
    }

    public GLSPDiagramComposite getDiagram() {
        return this.diagram;
    }

    public void doSave(IProgressMonitor monitor) {
        this.diagram.dispatch((org.eclipse.glsp.server.actions.Action)new SaveModelAction());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            UIUtil.asyncExec(() -> this.firePropertyChange(257));
        }
    }

    public void gotoMarker(IMarker marker) {
        this.diagram.getModelStateOnceInitialized().thenAccept(modelState -> GLSPDiagramEditorMarkerUtil.asNavigationTarget(marker, Optional.of(modelState)).map(NavigateToTargetAction::new).ifPresent(this.diagram::dispatch));
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.validateEditorInput(input);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        IEclipseContext context = (IEclipseContext)site.getService(IEclipseContext.class);
        this.diagram = this.createGLSPDiagramComposite();
        this.diagram.init(context, this.getFilePath());
        this.diagram.getModelStateOnceInitialized().thenAccept(this::syncMarkers);
        this.diagram.addDirtyStateListener(dirty -> this.setDirty((boolean)dirty));
    }

    protected GLSPDiagramComposite createGLSPDiagramComposite() {
        return new GLSPDiagramComposite(this.getEditorId());
    }

    protected void validateEditorInput(IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid editor input: Must be IFileEditorInput");
        }
    }

    protected String getFilePath() {
        return Optional.ofNullable(this.getFile()).map(IResource::getLocationURI).map(URI::getPath).orElse("");
    }

    protected String getFileName() {
        return Optional.ofNullable(this.getFile()).map(IFile::getName).orElse("");
    }

    protected IFile getFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        this.diagram.createPartControl(parent);
        this.setPartName(this.generatePartName());
        this.getSite().setSelectionProvider((ISelectionProvider)this.diagram);
        this.createBrowserMenu();
    }

    protected void createBrowserMenu() {
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.diagram.getBrowser());
        this.getSite().registerContextMenu(menuManager, this.getSite().getSelectionProvider());
        this.diagram.getBrowser().setMenu(menu);
    }

    protected String generatePartName() {
        return this.getFileName();
    }

    protected void syncMarkers(GModelState modelState) {
        IdeClientOptions.getSourceUriAsIFile(modelState.getClientOptions()).map(workspaceFile -> GLSPDiagramEditorMarkerUtil.syncMarkers((IResource)workspaceFile, modelState.getClientId(), this.diagram.getActionDispatcher().getNow(null))).ifPresent(arg_0 -> ((DisposableCollection)this.toDispose).add(arg_0));
    }

    public void setFocus() {
        this.diagram.setFocus();
    }

    public void notifyAboutToBeDisposed() {
        this.diagram.notifyAboutToBeDisposed();
    }

    public void dispose() {
        this.diagram.dispose();
        super.dispose();
        this.toDispose.dispose();
    }

    protected static IAction actionFor(final Runnable runnable) {
        return new Action(){

            public void run() {
                runnable.run();
            }
        };
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListener.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListener.removeSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.diagram.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.diagram.setSelection(selection);
    }

    public void updateSelection(SelectAction selectAction) {
        this.diagram.updateSelection(selectAction);
    }

    protected static class SelectionManager
    extends EventManager {
        protected SelectionManager() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.addListenerObject(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.removeListenerObject(listener);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object[] objectArray = this.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ISelectionChangedListener selectionChangedListeners = (ISelectionChangedListener)listener;
                UIUtil.asyncExec(() -> selectionChangedListeners.selectionChanged(event));
                ++n2;
            }
        }
    }
}

