/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.utils;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.glsp.server.utils.ClientOptionsUtil;

public final class IdeClientOptions {
    private IdeClientOptions() {
    }

    public static Optional<IFile> getSourceUriAsIFile(Map<String, String> options) {
        return ClientOptionsUtil.getSourceUriAsFile(options).flatMap(IdeClientOptions::getFileAsIFile);
    }

    public static Optional<IFile> getFileAsIFile(File file) {
        Path location = new Path(file.getAbsolutePath());
        IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)location);
        return workspaceFile != null && workspaceFile.exists() ? Optional.of(workspaceFile) : Optional.empty();
    }

    public static Optional<File> getUriAsFile(String uri) {
        return ClientOptionsUtil.getSourceUriAsFile(Map.of("sourceUri", uri));
    }

    public static Optional<IFile> getUriAsIFile(String uri) {
        return IdeClientOptions.getUriAsFile(uri).flatMap(IdeClientOptions::getFileAsIFile);
    }
}

