/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.directediting;

import org.eclipse.glsp.server.types.Severity;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;

public class ValidationStatus {
    private Severity severity;
    private String message;
    private ResponseError error;

    public ValidationStatus(Severity severity, String message) {
        this(severity, message, null);
    }

    public ValidationStatus(Severity severity, String message, Throwable throwable) {
        this.severity = severity;
        this.message = message;
        this.error = ValidationStatus.toError(throwable);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setState(Severity severity) {
        this.severity = severity;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ResponseError getError() {
        return this.error;
    }

    public void setError(ResponseError error) {
        this.error = error;
    }

    public static ValidationStatus ok() {
        return new ValidationStatus(Severity.OK, null);
    }

    public static ValidationStatus ok(String message) {
        return new ValidationStatus(Severity.OK, message);
    }

    public static ValidationStatus warning(String message) {
        return new ValidationStatus(Severity.WARNING, message);
    }

    public static ValidationStatus error(String message) {
        return new ValidationStatus(Severity.ERROR, message);
    }

    public static ValidationStatus error(String message, Throwable throwable) {
        return new ValidationStatus(Severity.ERROR, message, throwable);
    }

    private static ResponseError toError(Throwable throwable) {
        return throwable == null ? null : (ResponseError)RemoteEndpoint.DEFAULT_EXCEPTION_HANDLER.apply(throwable);
    }
}

