/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.launch;

import com.google.gson.GsonBuilder;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.glsp.server.di.ServerModule;
import org.eclipse.glsp.server.gson.ServerGsonConfigurator;
import org.eclipse.glsp.server.launch.GLSPServerLauncher;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.protocol.GLSPServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;

public class SocketGLSPServerLauncher
extends GLSPServerLauncher {
    public static final String START_UP_COMPLETE_MSG = "[GLSP-Server]:Startup completed";
    private static Logger LOGGER = LogManager.getLogger(SocketGLSPServerLauncher.class);
    private ExecutorService threadPool;
    private AsynchronousServerSocketChannel serverSocket;
    private CompletableFuture<Void> onShutdown;

    public SocketGLSPServerLauncher(ServerModule serverModule, Module ... additionalModules) {
        super(serverModule, additionalModules);
    }

    @Override
    public void start(String hostname, int port) {
        try {
            Future<Void> onClose = this.asyncRun(hostname, port);
            onClose.get();
            LOGGER.info("Stopped GLSP server");
        }
        catch (IOException e) {
            LOGGER.error("Error during server startup!", (Throwable)e);
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error during server shutdown!", (Throwable)e);
        }
    }

    protected String getStartupCompleteMessage() {
        return START_UP_COMPLETE_MSG;
    }

    public Future<Void> asyncRun(String hostname, int port) throws IOException, InterruptedException, ExecutionException {
        this.onShutdown = new CompletableFuture();
        this.serverSocket = AsynchronousServerSocketChannel.open().bind(new InetSocketAddress(hostname, port));
        this.threadPool = Executors.newCachedThreadPool();
        CompletionHandler<AsynchronousSocketChannel, Void> handler = new CompletionHandler<AsynchronousSocketChannel, Void>(){

            @Override
            public void completed(AsynchronousSocketChannel result, Void attachment) {
                SocketGLSPServerLauncher.this.serverSocket.accept(null, this);
                SocketGLSPServerLauncher.this.createClientConnection(result);
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                LOGGER.error("Client Connection Failed: " + exc.getMessage(), exc);
            }
        };
        this.serverSocket.accept(null, handler);
        LOGGER.info("The GLSP server is ready to accept new client requests on port: " + port);
        System.out.println(this.getStartupCompleteMessage());
        return this.onShutdown;
    }

    protected void createClientConnection(AsynchronousSocketChannel socketChannel) {
        Injector injector = this.createInjector();
        GLSPServer glspServer = null;
        try {
            try {
                InputStream in = Channels.newInputStream(socketChannel);
                OutputStream out = Channels.newOutputStream(socketChannel);
                glspServer = (GLSPServer)injector.getInstance(GLSPServer.class);
                Launcher launcher = Launcher.createIoLauncher((Object)glspServer, GLSPClient.class, (InputStream)in, (OutputStream)out, (ExecutorService)this.threadPool, this.messageWrapper(injector), this.configureGson(injector));
                glspServer.connect((GLSPClient)launcher.getRemoteProxy());
                LOGGER.info("Starting GLSP server connection for client " + socketChannel.getRemoteAddress());
                launcher.startListening().get();
                LOGGER.info("Stopping GLSP server connection for client " + socketChannel.getRemoteAddress());
            }
            catch (IOException | InterruptedException | ExecutionException ex) {
                LOGGER.error("Failed to create client connection " + ex.getMessage(), (Throwable)ex);
                try {
                    socketChannel.close();
                    if (glspServer != null) {
                        glspServer.shutdown();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Excpetion occured when trying to close socketChannel", (Throwable)e);
                }
            }
        }
        finally {
            try {
                socketChannel.close();
                if (glspServer != null) {
                    glspServer.shutdown();
                }
            }
            catch (IOException e) {
                LOGGER.error("Excpetion occured when trying to close socketChannel", (Throwable)e);
            }
        }
    }

    protected Consumer<GsonBuilder> configureGson(Injector injector) {
        ServerGsonConfigurator gsonConf = (ServerGsonConfigurator)injector.getInstance(ServerGsonConfigurator.class);
        return builder -> {
            GsonBuilder gsonBuilder = gsonConf.configureGsonBuilder((GsonBuilder)builder);
        };
    }

    protected Function<MessageConsumer, MessageConsumer> messageWrapper(Injector injector) {
        return Function.identity();
    }

    @Override
    public void shutdown() {
        LOGGER.info("Closing all connections to the GLSP server...");
        if (this.serverSocket.isOpen()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close server socket: " + e.getMessage(), (Throwable)e);
            }
        }
        this.threadPool.shutdown();
        this.onShutdown.complete(null);
        LOGGER.info("Shutdown GLSP server");
    }
}

