/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;

public final class FutureUtil {
    private FutureUtil() {
    }

    public static CompletableFuture<Void> aggregateResults(Collection<CompletableFuture<Void>> actions) {
        if (actions.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        if (actions.size() == 1) {
            return actions.iterator().next();
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        AtomicInteger remainingActions = new AtomicInteger(actions.size());
        AtomicReference firstException = new AtomicReference();
        BiFunction<Void, Throwable, Void> onComplete = (any, ex) -> {
            if (ex != null && !firstException.compareAndSet(null, ex)) {
                ((Throwable)firstException.get()).addSuppressed((Throwable)ex);
            }
            if (remainingActions.decrementAndGet() == 0) {
                Throwable t = (Throwable)firstException.get();
                if (t == null) {
                    result.complete(null);
                } else {
                    result.completeExceptionally(t);
                }
            }
            return null;
        };
        for (CompletableFuture<Void> action : actions) {
            action.handle(onComplete);
        }
        return result;
    }
}

