/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.emf.notation;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.util.RootAdapterUtil;
import org.eclipse.glsp.server.emf.EMFModelIndex;
import org.eclipse.glsp.server.emf.model.notation.Diagram;
import org.eclipse.glsp.server.emf.model.notation.NotationElement;
import org.eclipse.glsp.server.emf.model.notation.NotationFactory;
import org.eclipse.glsp.server.emf.model.notation.SemanticElementReference;
import org.eclipse.glsp.server.emf.notation.EMFSemanticIdConverter;
import org.eclipse.glsp.server.emf.notation.util.NotationUtil;

public class EMFNotationModelIndex
extends EMFModelIndex {
    protected static Logger LOGGER = LogManager.getLogger(EMFNotationModelIndex.class);
    protected BiMap<EObject, NotationElement> notationIndex = HashBiMap.create();
    protected final EMFSemanticIdConverter idConverter;

    protected EMFNotationModelIndex(EObject target, EMFSemanticIdConverter idConverter) {
        super(target, idConverter);
        this.idConverter = idConverter;
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return super.isAdapterForType(type) || EMFNotationModelIndex.class.equals(type);
    }

    @Override
    public void clear() {
        super.clear();
        this.notationIndex.clear();
    }

    public Diagram indexAll(Diagram diagram, EObject semanticModel) {
        this.resolveDiagram(diagram, semanticModel);
        this.indexDiagram(diagram);
        return diagram;
    }

    public Optional<NotationElement> getNotation(EObject semanticElement) {
        return Optional.ofNullable((NotationElement)this.notationIndex.get((Object)semanticElement));
    }

    public <T extends NotationElement> Optional<T> getNotation(EObject semanticElement, Class<T> clazz) {
        return this.safeCast(this.getNotation(semanticElement), clazz);
    }

    public Optional<NotationElement> getNotation(String id) {
        return this.getEObject(id).flatMap(this::getNotation);
    }

    public <T extends NotationElement> Optional<T> getNotation(String id, Class<T> clazz) {
        return this.safeCast(this.getNotation(id), clazz);
    }

    public Optional<NotationElement> getNotation(GModelElement gModelElement) {
        return this.getNotation(gModelElement.getId());
    }

    public <T extends NotationElement> Optional<T> getNotation(GModelElement element, Class<T> clazz) {
        return this.safeCast(this.getNotation(element), clazz);
    }

    protected void indexDiagram(Diagram diagram) {
        this.indexNotation(diagram);
        diagram.getElements().forEach(this::indexNotation);
    }

    protected void indexNotation(NotationElement notationElement) {
        if (!NotationUtil.isUnresolved(notationElement)) {
            EObject semanticElement = notationElement.getSemanticElement().getResolvedSemanticElement();
            this.notationIndex.put((Object)semanticElement, (Object)notationElement);
            this.eObjectIndex.inverse().putIfAbsent((Object)semanticElement, (Object)this.getOrCreateId(semanticElement));
        }
    }

    protected void resolveDiagram(Diagram diagram, EObject semanticModel) {
        this.findUnresolvedElements(diagram, semanticModel).forEach(notation -> this.resolveNotationElement((NotationElement)notation, semanticModel));
    }

    protected void resolveNotationElement(NotationElement notation, EObject semanticModel) {
        if (notation != null) {
            SemanticElementReference resolved = this.resolveSemanticReference(notation.getSemanticElement(), semanticModel);
            notation.setSemanticElement(resolved);
        }
    }

    protected SemanticElementReference resolveSemanticReference(SemanticElementReference reference, EObject semanticModel) {
        if (reference.getResolvedSemanticElement() != null) {
            return reference;
        }
        return this.resolveSemanticElementReference(reference, semanticModel);
    }

    protected SemanticElementReference resolveSemanticElementReference(SemanticElementReference reference, EObject semanticModel) {
        if (semanticModel == null) {
            return reference;
        }
        Optional.ofNullable(this.idConverter.resolve(reference.getElementId(), semanticModel)).ifPresent(reference::setResolvedSemanticElement);
        return reference;
    }

    protected List<NotationElement> findUnresolvedElements(Diagram diagram, EObject semanticModel) {
        ArrayList<NotationElement> unresolved = new ArrayList<NotationElement>();
        if (NotationUtil.isUnresolved(diagram)) {
            unresolved.add(diagram);
        }
        diagram.getElements().stream().filter(NotationUtil::isUnresolved).forEach(unresolved::add);
        return unresolved;
    }

    protected SemanticElementReference createReference(EObject eObject) {
        SemanticElementReference reference = NotationFactory.eINSTANCE.createSemanticElementReference();
        reference.setResolvedSemanticElement(eObject);
        reference.setElementId(this.getOrCreateId(eObject).toString());
        return reference;
    }

    public static EMFNotationModelIndex getOrCreate(GModelElement element, EMFSemanticIdConverter idGenerator) {
        return (EMFNotationModelIndex)RootAdapterUtil.getOrCreate((EObject)element, root -> new EMFNotationModelIndex((EObject)root, idGenerator), EMFNotationModelIndex.class);
    }
}

