/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.gmodel.commandstack;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.util.BasicChangeRecorder;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.glsp.graph.GModelChangeNotifier;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelListener;
import org.eclipse.glsp.graph.GModelRoot;

public class GModelChangeRecorder
extends BasicChangeRecorder
implements GModelListener {
    private final GModelRoot modelRoot;

    public GModelChangeRecorder(GModelRoot root) {
        this.modelRoot = root;
        GModelChangeNotifier.get((GModelElement)this.modelRoot).addListener((GModelListener)this);
    }

    public void dispose() {
        GModelChangeNotifier.get((GModelElement)this.modelRoot).removeListener((GModelListener)this);
    }

    public GModelChangeRecorder beginRecording() {
        if (this.changeDescription == null) {
            this.changeDescription = this.createChangeDescription();
        }
        this.setChangeDescription(this.changeDescription);
        this.setRecording(true);
        return this;
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject) {
            Object feature = notification.getFeature();
            if (feature instanceof EReference) {
                EReference eReference;
                this.handleFeature((EStructuralFeature)eReference, (EReference)((eReference = (EReference)feature).isContainment() ? eReference : null), notification, (EObject)notifier);
            } else if (feature != null) {
                this.handleFeature((EStructuralFeature)feature, null, notification, (EObject)notifier);
            }
        }
    }

    protected void handleFeature(EStructuralFeature feature, EReference containment, Notification notification, EObject eObject) {
        List changes = null;
        FeatureChange change = null;
        if (this.shouldRecord(feature, eObject)) {
            changes = this.getFeatureChanges(eObject);
            change = this.getFeatureChange(changes, feature);
        }
        switch (notification.getEventType()) {
            case 1: 
            case 2: 
            case 9: {
                if (change != null || changes == null) break;
                if (feature.isMany()) {
                    BasicEList oldValue = new BasicEList((Collection)eObject.eGet(feature));
                    int index = notification.getPosition();
                    if (index != -1) {
                        oldValue.set(index, notification.getOldValue());
                    }
                    change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                } else {
                    Object oldValue = notification.getOldValue();
                    change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                }
                ((InternalEList)changes).addUnique((Object)change);
                break;
            }
            case 3: {
                if (change != null || changes == null) break;
                BasicEList oldValue = new BasicEList((Collection)eObject.eGet(feature));
                oldValue.remove(notification.getPosition());
                change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                ((InternalEList)changes).addUnique((Object)change);
                break;
            }
            case 5: {
                if (change != null || changes == null) break;
                BasicEList oldValue = new BasicEList((Collection)eObject.eGet(feature));
                int position = notification.getPosition();
                int i = ((Collection)notification.getNewValue()).size();
                while (--i >= 0) {
                    oldValue.remove(position);
                }
                change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                ((InternalEList)changes).addUnique((Object)change);
                break;
            }
            case 4: {
                if (change != null || changes == null) break;
                BasicEList oldValue = new BasicEList((Collection)eObject.eGet(feature));
                int position = notification.getPosition();
                if (position == -1) {
                    position = 0;
                }
                oldValue.add(position, notification.getOldValue());
                change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                ((InternalEList)changes).addUnique((Object)change);
                break;
            }
            case 6: {
                if (change != null || changes == null) break;
                List removedValues = (List)notification.getOldValue();
                BasicEList oldValue = new BasicEList((Collection)eObject.eGet(feature));
                int[] positions = (int[])notification.getNewValue();
                if (positions == null) {
                    oldValue.addAll(removedValues);
                } else {
                    int i = 0;
                    while (i < positions.length) {
                        oldValue.add(positions[i], removedValues.get(i));
                        ++i;
                    }
                }
                change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                ((InternalEList)changes).addUnique((Object)change);
                break;
            }
            case 7: {
                if (change != null || changes == null) break;
                BasicEList oldValue = new BasicEList((Collection)eObject.eGet(feature));
                int position = notification.getPosition();
                int oldPosition = (Integer)notification.getOldValue();
                oldValue.move(oldPosition, position);
                change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                ((InternalEList)changes).addUnique((Object)change);
                break;
            }
        }
    }
}

