/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.protocol;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class InitializeResult {
    private String protocolVersion;
    private Map<String, Collection<String>> serverActions;

    public InitializeResult(String protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.serverActions = new HashMap<String, Collection<String>>();
    }

    public InitializeResult(String protocolVersion, Map<String, Collection<String>> handledActions) {
        this(protocolVersion);
        this.serverActions = handledActions;
    }

    public void addServerActions(String diagramType, Collection<String> actionKinds) {
        Collection value = this.serverActions.computeIfAbsent(diagramType, key -> new HashSet());
        value.addAll(actionKinds);
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public Map<String, Collection<String>> getServerActions() {
        return this.serverActions;
    }

    public void setServerActions(Map<String, Collection<String>> serverActions) {
        this.serverActions = serverActions;
    }

    public String toString() {
        return "InitializeResult [protocolVersion=" + this.protocolVersion + ", serverActions=" + String.valueOf(this.serverActions) + "]";
    }
}

